/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureItemSQLElement;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonItemSQLElement;
import org.openconcerto.erp.core.sales.shipment.report.BonLivraisonXmlSheet;
import org.openconcerto.erp.core.sales.shipment.ui.BonDeLivraisonItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class BonDeLivraisonSQLComponent
extends TransfertBaseSQLComponent {
    private BonDeLivraisonItemTable tableBonItem;
    private ElementComboBox selectCommande;
    private ElementComboBox comboClient;
    private PanelOOSQLComponent panelOO;
    private JUniqueTextField textNumeroUnique;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final DeviseField textTotalHT = new DeviseField(6);
    private final DeviseField textTotalTVA = new DeviseField(6);
    private final DeviseField textTotalTTC = new DeviseField(6);
    private final JTextField textPoidsTotal = new JTextField(6);
    private final JTextField textNom = new JTextField(25);

    public BonDeLivraisonSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON"));
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.tableBonItem.getRowValuesTable();
    }

    @Override
    protected SQLRowValues createDefaults() {
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        this.tableBonItem.getModel().clearRows();
        SQLRowValues rowVals = super.createDefaults();
        if (rowVals == null) {
            rowVals = new SQLRowValues(this.getTable());
        }
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            rowVals.put("CREATE_VIRTUAL_STOCK", Boolean.TRUE);
        }
        if (this.getTable().contains("ID_TAXE_PORT")) {
            SQLRow taxeDefault = TaxeCache.getCache().getFirstTaxe();
            rowVals.put("ID_TAXE_PORT", taxeDefault.getID());
        }
        return rowVals;
    }

    @Override
    public void addViews() {
        this.textTotalHT.setOpaque(false);
        this.textTotalTVA.setOpaque(false);
        this.textTotalTTC.setOpaque(false);
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            this.addView(new JCheckBox(), "CREATE_VIRTUAL_STOCK");
        }
        this.selectCommande = new ElementComboBox();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("DATE"), 4), c);
        JDate date = new JDate(true);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)((Object)date), c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textNom, c);
        if (this.getTable().contains("DATE_LIVRAISON")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("DATE_LIVRAISON"), 4), c);
            JDate dateLivraison = new JDate(true);
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)((Object)dateLivraison), c);
            this.addView((JComponent)((Object)dateLivraison), "DATE_LIVRAISON");
        }
        JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        c.weighty = 0.0;
        this.add((Component)labelClient, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.comboClient = new ElementComboBox();
        this.add((Component)this.comboClient, c);
        if (this.getTable().contains("SPEC_LIVRAISON")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("SPEC_LIVRAISON"), 4), c);
            JTextField specLivraison = new JTextField();
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)specLivraison, c);
            this.addView(specLivraison, "SPEC_LIVRAISON");
        }
        final ElementComboBox boxTarif = new ElementComboBox();
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (BonDeLivraisonSQLComponent.this.comboClient.getElement().getTable().contains("ID_TARIF")) {
                    if (BonDeLivraisonSQLComponent.this.isFilling()) {
                        return;
                    }
                    SQLRow row = ((SQLRequestComboBox)evt.getSource()).getSelectedRow();
                    if (row != null) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                }
            }
        });
        JButton boutonAll = new JButton("Tout livrer");
        boutonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowValuesTableModel m = BonDeLivraisonSQLComponent.this.tableBonItem.getModel();
                int i = 0;
                while (i < m.getRowCount()) {
                    SQLRowValues rowVals = m.getRowValuesAt(i);
                    Object o = rowVals.getObject("QTE");
                    int qte = o == null ? 0 : ((Number)o).intValue();
                    m.putValue(qte, i, "QTE_LIVREE");
                    ++i;
                }
            }
        });
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.add((Component)new JLabel("Tarif \u00e0 appliquer"), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    BonDeLivraisonSQLComponent.this.tableBonItem.setTarif(selectedRow, !BonDeLivraisonSQLComponent.this.isFilling());
                }
            });
        }
        if (this.getTable().contains("A_ATTENTION")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("A_ATTENTION"), 4), c);
            JTextField specLivraison = new JTextField();
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)specLivraison, c);
            this.addView(specLivraison, "A_ATTENTION");
        }
        ArrayList<JButton> l = new ArrayList<JButton>();
        l.add(boutonAll);
        this.tableBonItem = new BonDeLivraisonItemTable(l);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.tableBonItem, c);
        c.anchor = 13;
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        DeviseField textPortHT = new DeviseField(5);
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldHA = new DeviseField();
        fieldHA.setOpaque(false);
        fieldService.setOpaque(false);
        if (this.getTable().contains("TOTAL_DEVISE")) {
            this.addSQLObject(fieldDevise, "TOTAL_DEVISE");
            this.addRequiredSQLObject(fieldService, "TOTAL_SERVICE");
        }
        if (this.getTable().contains("PREBILAN")) {
            this.addSQLObject(fieldHA, "PREBILAN");
        } else if (this.getTable().contains("T_HA")) {
            this.addSQLObject(fieldHA, "T_HA");
        }
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.gridwidth = 1;
        c.fill = 0;
        this.addSQLObject(this.textPoidsTotal, "TOTAL_POIDS");
        this.addRequiredSQLObject(this.textTotalHT, "TOTAL_HT");
        this.addRequiredSQLObject(this.textTotalTVA, "TOTAL_TVA");
        this.addRequiredSQLObject(this.textTotalTTC, "TOTAL_TTC");
        final TotalPanel panelTotal = new TotalPanel(this.tableBonItem, this.textTotalHT, this.textTotalTVA, this.textTotalTTC, textPortHT, textRemiseHT, fieldService, fieldHA, fieldDevise, this.textPoidsTotal, null, this.getTable().contains("ID_TAXE_PORT") ? boxTaxePort : null);
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        panel.add((Component)new JLabel(this.getLabelFor("TOTAL_POIDS")), cFrais);
        this.textPoidsTotal.setEnabled(false);
        this.textPoidsTotal.setHorizontalAlignment(4);
        this.textPoidsTotal.setDisabledTextColor(Color.BLACK);
        ++cFrais.gridx;
        panel.add((Component)this.textPoidsTotal, cFrais);
        panel.setOpaque(false);
        DefaultGridBagConstraints.lockMinimumSize(panel);
        DefaultGridBagConstraints.lockMinimumSize(textPortHT);
        this.addSQLObject(textPortHT, "PORT_HT");
        DefaultGridBagConstraints.lockMinimumSize(textRemiseHT);
        this.addSQLObject(textRemiseHT, "REMISE_HT");
        if (this.getTable().contains("ID_TAXE_PORT")) {
            JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
            labelPortHT.setHorizontalAlignment(4);
            cFrais.gridx = 0;
            ++cFrais.gridy;
            panel.add((Component)labelPortHT, cFrais);
            ++cFrais.gridx;
            panel.add((Component)textPortHT, cFrais);
            JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
            labelTaxeHT.setHorizontalAlignment(4);
            cFrais.gridx = 0;
            ++cFrais.gridy;
            panel.add((Component)labelTaxeHT, cFrais);
            ++cFrais.gridx;
            panel.add((Component)boxTaxePort, cFrais);
            this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
            boxTaxePort.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    panelTotal.updateTotal();
                }
            });
        }
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 0;
        panel.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        panel.add((Component)textRemiseHT, cFrais);
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 12;
        this.add((Component)panel, c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 2;
        this.add((Component)panelTotal, c);
        c.anchor = 17;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        TitledSeparator sep = new TitledSeparator("Informations compl\u00e9mentaires");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        ITextArea textInfos = new ITextArea(4, 4);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(textInfos);
        this.add((Component)scrollPane, c);
        textInfos.setBorder(null);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        this.addRequiredSQLObject((JComponent)((Object)date), "DATE");
        this.addSQLObject(textInfos, "INFOS");
        this.addSQLObject(this.textNom, "NOM");
        this.addSQLObject(this.selectCommande, "ID_COMMANDE_CLIENT");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }
        });
    }

    public BonDeLivraisonItemTable getTableBonItem() {
        return this.tableBonItem;
    }

    private void reconfigure(JTextField field) {
        field.setEnabled(false);
        field.setHorizontalAlignment(4);
        field.setDisabledTextColor(Color.BLACK);
        field.setBorder(null);
    }

    @Override
    public int insert(SQLRow order) {
        int idBon = this.getSelectedID();
        if (this.textNumeroUnique.checkValidation()) {
            SQLPreferences prefs;
            idBon = super.insert(order);
            this.tableBonItem.updateField("ID_BON_DE_LIVRAISON", idBon);
            this.tableBonItem.createArticle(idBon, this.getElement());
            BonLivraisonXmlSheet bSheet = new BonLivraisonXmlSheet(this.getTable().getRow(idBon));
            bSheet.createDocumentAsynchronous();
            bSheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt("BON_L_START");
                rowVals.put("BON_L_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (!(prefs = new SQLPreferences(this.getTable().getDBRoot())).getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
                try {
                    this.updateStock(idBon);
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idBon;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
    }

    @Override
    public void update() {
        if (!this.textNumeroUnique.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.tableBonItem.updateField("ID_BON_DE_LIVRAISON", this.getSelectedID());
        this.tableBonItem.createArticle(this.getSelectedID(), this.getElement());
        BonLivraisonXmlSheet bSheet = new BonLivraisonXmlSheet(this.getTable().getRow(this.getSelectedID()));
        bSheet.createDocumentAsynchronous();
        bSheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        if (!prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", this.getSelectedID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l != null) {
                int i = 0;
                while (i < l.size()) {
                    Object[] tmp = (Object[])l.get(i);
                    try {
                        eltMvtStock.archive(((Number)tmp[0]).intValue());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            try {
                this.updateStock(this.getSelectedID());
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void updateQte(int idBon) throws SQLException {
        SQLTable tableFactureElem = new SaisieVenteFactureItemSQLElement().getTable();
        SQLSelect selBonItem = new SQLSelect(this.getTable().getBase());
        BonDeLivraisonItemSQLElement bonElt = new BonDeLivraisonItemSQLElement();
        selBonItem.addSelect(bonElt.getTable().getField("ID_SAISIE_VENTE_FACTURE_ELEMENT"));
        selBonItem.addSelect(bonElt.getTable().getField("QTE_LIVREE"));
        selBonItem.setWhere(bonElt.getTable().getField("ID_BON_DE_LIVRAISON"), "=", idBon);
        String reqBonItem = selBonItem.asString();
        Object obBonItem = this.getTable().getBase().getDataSource().execute(reqBonItem, new ArrayListHandler());
        List myListBonItem = (List)obBonItem;
        int size = myListBonItem.size();
        int i = 0;
        while (i < size) {
            Object[] objTmp = (Object[])myListBonItem.get(i);
            SQLRow rowFactElem = tableFactureElem.getRow(((Number)objTmp[0]).intValue());
            SQLRowValues rowVals = new SQLRowValues(tableFactureElem);
            rowVals.put("QTE_LIVREE", (Object)(rowFactElem.getInt("QTE_LIVREE") + ((Number)objTmp[1]).intValue()));
            rowVals.update(rowFactElem.getID());
            ++i;
        }
    }

    public void cancelUpdateQte(int idBon) throws SQLException {
        SQLTable tableFactureElem = new SaisieVenteFactureItemSQLElement().getTable();
        SQLSelect selBonItem = new SQLSelect(this.getTable().getBase());
        BonDeLivraisonItemSQLElement bonElt = new BonDeLivraisonItemSQLElement();
        selBonItem.addSelect(bonElt.getTable().getField("ID_SAISIE_VENTE_FACTURE_ELEMENT"));
        selBonItem.addSelect(bonElt.getTable().getField("QTE_LIVREE"));
        selBonItem.setWhere(bonElt.getTable().getField("ID_BON_DE_LIVRAISON"), "=", idBon);
        String reqBonItem = selBonItem.asString();
        Object obBonItem = this.getTable().getBase().getDataSource().execute(reqBonItem, new ArrayListHandler());
        List myListBonItem = (List)obBonItem;
        int size = myListBonItem.size();
        int i = 0;
        while (i < size) {
            Object[] objTmp = (Object[])myListBonItem.get(i);
            SQLRow rowFactElem = tableFactureElem.getRow(((Number)objTmp[0]).intValue());
            SQLRowValues rowVals = new SQLRowValues(tableFactureElem);
            rowVals.put("QTE_LIVREE", (Object)(((Number)objTmp[1]).intValue() - rowFactElem.getInt("QTE_LIVREE")));
            rowVals.update(rowFactElem.getID());
            ++i;
        }
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "BL N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (!prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            SQLRow row = this.getTable().getRow(id);
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return BonDeLivraisonSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT")), this.getTable().contains("CREATE_VIRTUAL_STOCK") && row.getBoolean("CREATE_VIRTUAL_STOCK") != false ? StockItemsUpdater.TypeStockUpdate.REAL_VIRTUAL_DELIVER : StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
            stockUpdater.update();
        }
    }
}

