/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;

public class ListeDesBonsDeLivraisonAction
extends CreateFrameAbstractAction {
    public ListeDesBonsDeLivraisonAction() {
        this.putValue("Name", "Liste des bons de livraison");
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame("Bons de livraison");
        RowAction.PredicateRowAction toInvoiceAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesBonsDeLivraisonAction.this.transfertFactureClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.shipment.create.invoice");
        toInvoiceAction.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Livraisons non factur\u00e9es", this.createDeliveryWithoutInvoicePanel(toInvoiceAction));
        tabs.addTab("Livraisons factur\u00e9es", this.createDeliveryWithInvoicePanel());
        tabs.addTab("Toutes les livraisons", this.createAllDeliveryPanel(toInvoiceAction));
        frame.setContentPane(tabs);
        SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        FrameUtil.setBounds(frame);
        File file = IListFrame.getConfigFile(eltCmd, frame.getClass());
        if (file != null) {
            new WindowStateManager(frame, file).loadState();
        }
        return frame;
    }

    private ListeAddPanel getPanel(SQLElement eltCmd, SQLTableModelSourceOnline tableSource, final List<RowAction> allowedActions) {
        ListeAddPanel panel = new ListeAddPanel(eltCmd, new IListe(tableSource));
        ArrayList<SQLField> fields = new ArrayList<SQLField>(2);
        fields.add(eltCmd.getTable().getField("TOTAL_HT"));
        IListTotalPanel totalPanel = new IListTotalPanel(panel.getListe(), fields, "Total des livraisons de la liste");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(panel.getListe(), eltCmd.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        panel.getListe().addIListeActions(new MouseSheetXmlListeListener(CommandeClientXmlSheet.class){

            @Override
            public List<RowAction> addToMenu() {
                return allowedActions;
            }
        }.getRowActions());
        datePanel.setFilterOnDefault();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setOpaque(false);
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.fill = 0;
        c2.weightx = 1.0;
        bottomPanel.add((Component)datePanel, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.anchor = 13;
        bottomPanel.add((Component)totalPanel, c2);
        panel.add((Component)bottomPanel, c);
        return panel;
    }

    JPanel createAllDeliveryPanel(RowAction.PredicateRowAction toInvoiceAction) {
        SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        allowedActions.add(toInvoiceAction);
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions);
        return panel;
    }

    JPanel createDeliveryWithInvoicePanel() {
        SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        SQLInjector injector = SQLInjector.getInjector(eltCmd.getTable(), eltCmd.getTable().getTable("SAISIE_VENTE_FACTURE"));
        injector.setOnlyTransfered(tableSource);
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions);
        return panel;
    }

    JPanel createDeliveryWithoutInvoicePanel(RowAction.PredicateRowAction toInvoiceAction) {
        SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        allowedActions.add(toInvoiceAction);
        SQLInjector injector = SQLInjector.getInjector(eltCmd.getTable(), eltCmd.getTable().getTable("SAISIE_VENTE_FACTURE"));
        injector.setOnlyNotTransfered(tableSource);
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions);
        return panel;
    }

    private void transfertFactureClient(List<SQLRowValues> rows) {
        TransfertBaseSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE");
    }
}

