/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.product.ui.FamilleArticlePanel;
import org.openconcerto.erp.panel.ITreeSelection;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;

public class ListeDesArticlesAction
extends CreateFrameAbstractAction {
    private PanelFrame panelFrame;
    String title = "Liste des articles";
    private final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
    private final SQLTable sqlTableFamilleArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("FAMILLE_ARTICLE");

    public ListeDesArticlesAction() {
        this.putValue("Name", "Liste des articles");
    }

    public JFrame createFrame() {
        final SQLElement elt = Configuration.getInstance().getDirectory().getElement(this.sqlTableArticle);
        final FamilleArticlePanel panelFam = new FamilleArticlePanel(elt.getForeignElement("ID_FAMILLE_ARTICLE"));
        SQLTableModelSourceOnline createTableSource = elt.createTableSource(this.getWhere(panelFam));
        BaseSQLTableModelColumn colStock = new BaseSQLTableModelColumn("Valeur HT du stock", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor stock = r.getForeign("ID_STOCK");
                if (stock == null || stock.isUndefined()) {
                    return BigDecimal.ZERO;
                }
                float qte = stock.getFloat("QTE_REEL");
                BigDecimal ha = r.getBigDecimal("PA_HT");
                BigDecimal total = ha.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
                if (total.signum() == 1) {
                    return total;
                }
                return BigDecimal.ZERO;
            }

            @Override
            public Set<FieldPath> getPaths() {
                SQLTable table = elt.getTable();
                Path p = new Path(table);
                Path p2 = (Path)new Path(table).addForeignField("ID_STOCK");
                return CollectionUtils.createSet(new FieldPath(p, "PA_HT"), new FieldPath(p2, "QTE_REEL"));
            }
        };
        colStock.setRenderer(ComptaSQLConfElement.CURRENCY_RENDERER);
        createTableSource.getColumns().add(colStock);
        IListe liste = new IListe(createTableSource);
        final ListeAddPanel panel = new ListeAddPanel(elt, liste);
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(1);
        fields.add(Tuple2.create(liste.getSource().getColumn(liste.getSource().getColumns().size() - 1), IListTotalPanel.Type.SOMME));
        IListTotalPanel total = new IListTotalPanel(liste, fields, null, "Total");
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridy = 4;
        c2.anchor = 13;
        c2.weightx = 0.0;
        c2.fill = 0;
        panel.add((Component)total, c2);
        JSplitPane pane = new JSplitPane(1, new JScrollPane(panelFam), panel);
        JPanel panelAll = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelAll.add((Component)pane, c);
        ITreeSelection tree = panelFam.getFamilleTree();
        tree.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                panel.getListe().getRequest().setWhere(ListeDesArticlesAction.this.getWhere(panelFam));
            }
        });
        panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesArticlesAction.this.setTitle(panel);
            }
        });
        panel.getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    ListeDesArticlesAction.this.setTitle(panel);
                }
            }
        });
        panelFam.getCheckObsolete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getListe().getRequest().setWhere(ListeDesArticlesAction.this.getWhere(panelFam));
            }
        });
        this.panelFrame = new PanelFrame(panelAll, "Liste des articles");
        return this.panelFrame;
    }

    protected void setTitle(ListeAddPanel panel) {
        String title = this.title;
        if (panel.getListe().getModel().isLoading()) {
            title = String.valueOf(title) + ", chargement en cours";
        }
        if (panel.getListe().getModel().isSearching()) {
            title = String.valueOf(title) + ", recherche en cours";
        }
        if (this.panelFrame != null) {
            this.panelFrame.setTitle(title);
        }
    }

    public Where getWhere(FamilleArticlePanel panel) {
        int id = panel.getFamilleTree().getSelectedID();
        Where w = null;
        if (panel.getCheckObsolete().isSelected()) {
            w = new Where((FieldRef)this.sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        }
        if (id > 1) {
            SQLRow row = this.sqlTableFamilleArticle.getRow(id);
            Where w2 = new Where((FieldRef)this.sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", this.sqlTableFamilleArticle.getKey());
            String code = String.valueOf(row.getString("CODE")) + ".%";
            Where w3 = new Where((FieldRef)this.sqlTableFamilleArticle.getField("CODE"), "LIKE", (Object)code);
            w2 = w2.and(w3.or(new Where((FieldRef)this.sqlTableFamilleArticle.getKey(), "=", id)));
            w = w != null ? w.and(w2) : w2;
        }
        return w;
    }
}

