/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.util.HexDump;

public class ConcertProtocol {
    private static final char STX = '\u0002';
    private static final char ETX = '\u0003';
    private static final char EOT = '\u0004';
    private static final char ENQ = '\u0005';
    private static final char ACK = '\u0006';
    private static final char NACK = '\u0015';
    private static final char MODE_CARD = '1';
    private static final char TYPE_BUY = '0';
    private static final String CURRENCY_EUR = "978";
    private String port;

    public ConcertProtocol(String port) {
        this.port = port;
    }

    public boolean sendCardPayment(int amountInCents, String currency) throws Exception {
        if (currency == null) {
            currency = CURRENCY_EUR;
        }
        return this.sendPrototolE(1, amountInCents, true, '1', '0', currency, "OpenConcerto");
    }

    public boolean sendPrototolE(int posIndex, int amountInCents, boolean requireResponse, char mode, char type, String currency, String string) throws Exception {
        boolean result = false;
        if (posIndex > 99 || posIndex < 0) {
            throw new IllegalArgumentException("Pos index must be between 0 and 99");
        }
        if (amountInCents < 0) {
            throw new IllegalArgumentException("Amount must be positive");
        }
        if (currency.length() != 3) {
            throw new IllegalArgumentException("Bad currency code : " + currency);
        }
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        InputStream in = serialPort.getInputStream();
        out.write(5);
        byte[] buffer = new byte[512];
        int nbRead = in.read(buffer);
        if (nbRead != 1 || buffer[0] != 6) {
            String r = HexDump.toHex((byte[])buffer, (int)nbRead);
            serialPort.close();
            throw new IllegalStateException("Bad response received : " + r);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bOut.write(2);
        String n = ConcertProtocol.rightAlign(posIndex, 2, '0');
        bOut.write(n.getBytes());
        bOut.write(ConcertProtocol.rightAlign(amountInCents, 8, '0').getBytes());
        if (requireResponse) {
            bOut.write(49);
        } else {
            bOut.write(48);
        }
        bOut.write(mode);
        bOut.write(type);
        bOut.write(currency.getBytes());
        bOut.write(ConcertProtocol.leftAlign(string, 10, ' ').getBytes());
        bOut.write(3);
        byte b = this.getLrc(bOut.toByteArray());
        bOut.write(b);
        out.write(bOut.toByteArray());
        nbRead = in.read(buffer);
        if (nbRead != 1 || buffer[0] != 6) {
            String r = HexDump.toHex((byte[])buffer, (int)nbRead);
            serialPort.close();
            throw new IllegalStateException("Bad response received : " + nbRead + ": " + r);
        }
        out.write(4);
        int count = 0;
        int maxCount = 300;
        while (count < 300) {
            nbRead = in.read(buffer);
            if (nbRead > 0) {
                if (buffer[0] == 5) {
                    out.write(6);
                } else if (buffer[0] == 2) {
                    if (buffer[3] == 48) {
                        result = true;
                        out.write(6);
                        count = 300;
                    } else if (buffer[3] == 55) {
                        out.write(21);
                        count = 300;
                    }
                } else if (buffer[0] == 4) {
                    count = 300;
                }
            }
            Thread.sleep(200L);
            ++count;
        }
        out.close();
        in.close();
        serialPort.close();
        return result;
    }

    private byte getLrc(byte[] bytes) {
        byte LRC = 0;
        int i = 1;
        while (i < bytes.length) {
            LRC = (byte)(LRC ^ bytes[i]);
            ++i;
        }
        return LRC;
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        CommPort commPort = portIdentifier.open("CommUtil", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    private static String rightAlign(int value, int maxWidth, char fillChar) {
        String r = String.valueOf(value);
        if (r.length() > maxWidth) {
            return r.substring(0, maxWidth);
        }
        int n = maxWidth - r.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(fillChar) + r;
            ++i;
        }
        return r;
    }

    private static String leftAlign(String r, int maxWidth, char fillChar) {
        if (r.length() > maxWidth) {
            return r.substring(0, maxWidth);
        }
        int n = maxWidth - r.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(r) + fillChar;
            ++i;
        }
        return r;
    }
}

