/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.component.TransfertGroupSQLComponent;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClient;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesCommandesClientAction
extends CreateFrameAbstractAction {
    private BaseSQLTableModelColumn colAvancement;

    public ListeDesCommandesClientAction() {
        this.putValue("Name", "Liste des commandes clients");
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame("Commandes clients");
        SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        if (eltCmd.getTable().contains("ETAT_COMMANDE")) {
            JTabbedPane pane = new JTabbedPane();
            EtatCommandeClient[] etatCommandeClientArray = EtatCommandeClient.values();
            int n = etatCommandeClientArray.length;
            int n2 = 0;
            while (n2 < n) {
                EtatCommandeClient etat = etatCommandeClientArray[n2];
                JPanel orderPanel = this.createAllOrderPanel(etat);
                pane.add(etat.getTranslation(), orderPanel);
                ++n2;
            }
            frame.getContentPane().add(pane);
        } else {
            JPanel orderPanel = this.createAllOrderPanel(null);
            frame.getContentPane().add(orderPanel);
        }
        FrameUtil.setBounds(frame);
        File file = IListFrame.getConfigFile(eltCmd, frame.getClass());
        if (file != null) {
            new WindowStateManager(frame, file).loadState();
        }
        return frame;
    }

    JPanel createAllOrderPanel(final EtatCommandeClient etat) {
        final SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        if (etat != null) {
            tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where((FieldRef)eltCmd.getTable().getField("ETAT_COMMANDE"), "=", etat.getId()));
                    return input;
                }
            });
        }
        ArrayList<RowAction> allowedActions = new ArrayList<RowAction>();
        RowAction.PredicateRowAction bonAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesCommandesClientAction.this.transfertBonLivraisonClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.order.create.deliverynote");
        RowAction factureAction = new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesCommandesClientAction.this.transfertFactureClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.order.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.isEmpty()) {
                    return false;
                }
                if (selection.size() > 1) {
                    return true;
                }
                BigDecimal d = ListeDesCommandesClientAction.this.getAvancement(selection.get(0));
                return d.signum() == 0;
            }
        };
        RowAction acompteAction = new RowAction(new AbstractAction("Cr\u00e9er une facture interm\u00e9diaire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesCommandesClientAction.this.transfertAcompteClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.order.create.account"){
            BigDecimal cent;
            {
                this.cent = BigDecimal.ONE.movePointRight(2);
            }

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.isEmpty() || selection.size() > 1) {
                    return false;
                }
                BigDecimal d = ListeDesCommandesClientAction.this.getAvancement(selection.get(0));
                return NumberUtils.compare(d, this.cent) != 0;
            }
        };
        RowAction soldeAction = new RowAction(new AbstractAction("Facturer le solde"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesCommandesClientAction.this.transfertSoldeClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.order.create.account.solde"){
            BigDecimal cent;
            {
                this.cent = BigDecimal.ONE.movePointRight(2);
            }

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.isEmpty() || selection.size() > 1) {
                    return false;
                }
                BigDecimal d = ListeDesCommandesClientAction.this.getAvancement(selection.get(0));
                return NumberUtils.compare(d, this.cent) != 0 && NumberUtils.compare(d, BigDecimal.ZERO) != 0;
            }
        };
        RowAction.PredicateRowAction cmdAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int selectedId = IListe.get(e).getSelectedId();
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
                        elt.transfertCommande(selectedId);
                    }
                });
            }
        }, false, "sales.order.create.supplier.order");
        cmdAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        bonAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        allowedActions.add(bonAction);
        allowedActions.add(factureAction);
        allowedActions.add(acompteAction);
        allowedActions.add(soldeAction);
        allowedActions.add(cmdAction);
        this.colAvancement = new BaseSQLTableModelColumn("Avancement facturation", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return ListeDesCommandesClientAction.this.getAvancement(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = ((PathBuilder)((PathBuilder)new PathBuilder(eltCmd.getTable()).addTable("TR_COMMANDE_CLIENT")).addTable("SAISIE_VENTE_FACTURE")).build();
                return CollectionUtils.createSet(new FieldPath(p, "T_HT"));
            }
        };
        tableSource.getColumns().add(this.colAvancement);
        this.colAvancement.setRenderer(new PercentTableCellRenderer());
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource, allowedActions);
        return panel;
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_COMMANDE_CLIENT"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            Long l = rowFact.getLong("T_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private ListeAddPanel getPanel(SQLElement eltCmd, SQLTableModelSourceOnline tableSource, final List<RowAction> allowedActions) {
        ListeAddPanel panel = new ListeAddPanel(eltCmd, new IListe(tableSource)){

            @Override
            protected void createUI() {
                super.createUI();
                this.btnMngr.setAdditional(this.buttonEffacer, new ITransformer<JButton, String>(){

                    @Override
                    public String transformChecked(JButton input) {
                        SQLRow row = this.getListe().fetchSelectedRow();
                        BigDecimal b = ListeDesCommandesClientAction.this.getAvancement(row);
                        if (row.getLong("T_HT") > 0L && b.signum() != 0) {
                            return "Vous ne pouvez pas supprimer une commande factur\u00e9e !";
                        }
                        return null;
                    }
                });
                this.btnMngr.setAdditional(this.buttonModifier, new ITransformer<JButton, String>(){

                    @Override
                    public String transformChecked(JButton input) {
                        SQLRow row = this.getListe().fetchSelectedRow();
                        BigDecimal b = ListeDesCommandesClientAction.this.getAvancement(row);
                        if (row.getLong("T_HT") > 0L && b.signum() != 0) {
                            return "Vous ne pouvez pas modifier une commande factur\u00e9e !";
                        }
                        return null;
                    }
                });
            }
        };
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(2);
        fields.add(Tuple2.create(panel.getListe().getSource().getColumn(eltCmd.getTable().getField("T_HT")), IListTotalPanel.Type.SOMME));
        fields.add(Tuple2.create(this.colAvancement, IListTotalPanel.Type.AVANCEMENT_TTC));
        IListTotalPanel totalPanel = new IListTotalPanel(panel.getListe(), fields, null, "Total des commandes de la liste");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(panel.getListe(), eltCmd.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        panel.getListe().addIListeActions(new MouseSheetXmlListeListener(CommandeClientXmlSheet.class){

            @Override
            public List<RowAction> addToMenu() {
                return allowedActions;
            }
        }.getRowActions());
        datePanel.setFilterOnDefault();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setOpaque(false);
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.fill = 0;
        c2.weightx = 1.0;
        bottomPanel.add((Component)datePanel, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.anchor = 13;
        bottomPanel.add((Component)totalPanel, c2);
        panel.add((Component)bottomPanel, c);
        return panel;
    }

    private void transfertBonLivraisonClient(List<SQLRowValues> rows) {
        TransfertBaseSQLComponent.openTransfertFrame(rows, "BON_DE_LIVRAISON");
    }

    private void transfertFactureClient(List<SQLRowValues> rows) {
        TransfertBaseSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE");
    }

    private void transfertAcompteClient(List<SQLRowValues> rows) {
        TransfertGroupSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE", "sales.invoice.partial");
    }

    private void transfertSoldeClient(List<SQLRowValues> rows) {
        TransfertGroupSQLComponent.openTransfertFrame(rows, "SAISIE_VENTE_FACTURE", "sales.invoice.partial.balance");
    }
}

