/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.GestionDevise;

public class EcheanceClientSQLElement
extends ComptaSQLConfElement {
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy", Locale.ENGLISH);

    public EcheanceClientSQLElement() {
        super("ECHEANCE_CLIENT", "une \u00e9ch\u00e9ance client", "\u00e9ch\u00e9ances clients");
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get(arg0).fetchSelectedRow();
                MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Envoyer un mail"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get(arg0).fetchSelectedRow();
                EcheanceClientSQLElement.this.sendMail(row);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            RowAction actionCancel = new RowAction(new AbstractAction("Annuler la r\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir annuler la r\u00e9gularisation ?");
                    if (answer == 0) {
                        SQLRow row = IListe.get(e).getSelectedRow().asRow();
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.FALSE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA");
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionCancel);
            RowAction actionRegul = new RowAction(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    SQLRow row = IListe.get(e).fetchSelectedRow();
                    String price = GestionDevise.currencyToString(row.getLong("MONTANT"));
                    SQLRow rowClient = row.getForeignRow("ID_CLIENT");
                    String nomClient = rowClient.getString("NOM");
                    String piece = "";
                    SQLRow rowMvt = row.getForeignRow("ID_MOUVEMENT");
                    if (rowMvt != null) {
                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                        piece = rowPiece.getString("NOM");
                    }
                    if ((answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir r\u00e9gulariser l'\u00e9ch\u00e9ance de " + nomClient + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + ".")) == 0) {
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA") == false;
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionRegul);
        }
    }

    private void sendMail(SQLRow row) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        if (row != null) {
            String devise;
            int idMvtSource = MouvementSQLElement.getSourceId(row.getInt("ID_MOUVEMENT"));
            SQLRow rowMvtSource = base.getTable("MOUVEMENT").getRow(idMvtSource);
            if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                return;
            }
            int idFact = rowMvtSource.getInt("IDSOURCE");
            SQLRow rowFacture = base.getTable("SAISIE_VENTE_FACTURE").getRow(idFact);
            Set<SQLField> setContact = null;
            SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
            setContact = row.getTable().getForeignKeys(tableContact);
            Set<SQLField> setClient = null;
            SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
            setClient = row.getTable().getForeignKeys(tableClient);
            Long lTotal = (Long)rowFacture.getObject("T_TTC");
            Long lRestant = (Long)row.getObject("MONTANT");
            long lRestantDevise = lRestant;
            SQLRow rowTarif = rowFacture.getForeign("ID_TARIF");
            if (rowTarif != null && !rowTarif.isUndefined()) {
                SQLRow rowDevise = rowTarif.getForeign("ID_DEVISE");
                BigDecimal t = (BigDecimal)rowDevise.getObject("TAUX");
                BigDecimal bigDecimal = new BigDecimal(lRestantDevise);
                long l = lRestantDevise = t.signum() == 0 ? lRestantDevise : bigDecimal.multiply(t, DecimalUtils.HIGH_PRECISION).setScale(0, 4).longValue();
                devise = rowDevise.getString("CODE").trim().length() > 0 ? rowDevise.getString("CODE") : "\u20ac";
            } else {
                devise = "\u20ac";
            }
            Long lVerse = new Long(lTotal - lRestant);
            Date dFacture = (Date)rowFacture.getObject("DATE");
            SQLRow modeRegRow = rowFacture.getForeignRow("ID_MODE_REGLEMENT");
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), dFacture);
            final String references = rowFacture.getString("NOM");
            final String text = "Date: " + this.dateFormat.format(new Date()) + "\n" + "Concerning : Late Payment reminder\n" + "\n\n\nTo " + rowFacture.getForeign("ID_CLIENT").getString("NOM") + "," + "\n\n\nIt has come to our attention that the following invoice has not been paid to this day." + "\nInvoice # " + rowFacture.getString("NUMERO") + " from " + this.dateFormat.format(rowFacture.getDate("DATE").getTime()) + " of " + devise + " " + GestionDevise.currencyToString(lRestantDevise, true) + " duedate " + this.dateFormat.format(dateEch) + (references.trim().length() == 0 ? "" : ". Your references : " + references) + ".\nWe assume that this is a mere oversight and we would appreciate it if you would settle this invoice as soon as possible. In the event that this has already been accomplished in the meantime, please ignore this notice." + "\n\n\nThanking you in advance.";
            String mail = "";
            for (SQLField field : setContact) {
                if (mail != null && mail.trim().length() != 0) continue;
                mail = row.getForeignRow(field.getName()).getString("EMAIL");
            }
            for (SQLField field : setClient) {
                SQLRow rowCli = row.getForeignRow(field.getName());
                if (mail != null && mail.trim().length() != 0) continue;
                mail = rowCli.getString("MAIL");
            }
            final String adresseMail = mail;
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        EmailComposer.getInstance().compose(adresseMail, "Late Payment reminder - " + references, text, new File[0]);
                    }
                    catch (IOException exn) {
                        exn.printStackTrace();
                    }
                    catch (InterruptedException exn) {
                        exn.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        CollectionMap<String, String> map = new CollectionMap<String, String>();
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SAISIE_VENTE_FACTURE");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("MONTANT");
        l.add("ID_MOUVEMENT");
        l.add("NOMBRE_RELANCE");
        l.add("INFOS");
        l.add("DATE_LAST_RELANCE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("MONTANT");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("REG_COMPTA", null);
                graphToFetch.put("REGLE", null);
            }
        };
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private DeviseField montant;
            private JTextField nbRelance;
            private JDate date;
            private JTextField idMouvement;
            private ElementComboBox comboClient;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.montant = new DeviseField();
                this.nbRelance = new JTextField();
                this.date = new JDate();
                this.idMouvement = new JTextField();
                this.comboClient = new ElementComboBox();
                JLabel labelMouvement = new JLabel("Mouvement");
                this.add((Component)labelMouvement, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.add((Component)this.idMouvement, c);
                JLabel labelDate = new JLabel("Date");
                ++c.gridx;
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)((Object)this.date), c);
                JLabel labelClient = new JLabel("Client");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelClient, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)this.comboClient, c);
                JLabel labelRelance = new JLabel("Nombre de relance");
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                this.add((Component)labelRelance, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.nbRelance, c);
                c.gridwidth = 1;
                JLabel labelMontant = new JLabel("Montant");
                ++c.gridx;
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.montant, c);
                this.addSQLObject(this.montant, "MONTANT");
                this.addRequiredSQLObject((JComponent)((Object)this.date), "DATE");
                this.addSQLObject(this.nbRelance, "NOMBRE_RELANCE");
                this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
                this.addSQLObject(this.idMouvement, "ID_MOUVEMENT");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".commitment";
    }
}

