/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.payment.component.ModeDeReglementSQLComponent;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.SaisieVenteFactureItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieVenteFactureSQLComponent
extends TransfertBaseSQLComponent {
    private AbstractArticleItemTable tableFacture;
    private JLabel labelAffaire = new JLabel("Affaire");
    private DeviseField textPortHT;
    private DeviseField textAvoirTTC;
    private DeviseField textRemiseHT;
    private DeviseField fieldTTC;
    private DeviseField textTotalAvoir;
    private SQLElement factureElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
    private SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT").getTable();
    public static final SQLTable TABLE_ADRESSE = Configuration.getInstance().getDirectory().getElement("ADRESSE").getTable();
    private SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
    private final SQLElement client = Configuration.getInstance().getDirectory().getElement(this.tableClient);
    private JUniqueTextField textNumeroUnique;
    private ElementComboBox comboClient;
    private ElementComboBox comboAdresse;
    private ISQLCompteSelector compteSel;
    private final SQLTable tableNum = this.factureElt.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private JCheckBox checkCompteServiceAuto;
    private JCheckBox checkPrevisionnelle;
    private JCheckBox checkComplement;
    private JCheckBox checkAcompte;
    private JCheckBox checkCT;
    protected PanelOOSQLComponent panelOO;
    private ElementComboBox selAvoir;
    private ElementComboBox selAffaire;
    private ElementSQLObject eltModeRegl;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
    private ElementComboBox contact;
    private SQLRowAccessor rowSelected;
    private SQLElement eltContact = Configuration.getInstance().getDirectory().getElement("CONTACT");
    private JTextField refClient = new JTextField();
    private SQLRowValues defaultContactRowValues = new SQLRowValues(this.eltContact.getTable());
    protected TotalPanel totalTTC;
    private SQLTextCombo textTypeMission = new SQLTextCombo();
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            int idCli = SaisieVenteFactureSQLComponent.this.comboClient.getWantedID();
            if (!SaisieVenteFactureSQLComponent.this.isFilling() && idCli > 1) {
                SQLRow rowCli = SaisieVenteFactureSQLComponent.this.client.getTable().getRow(idCli);
                if (SaisieVenteFactureSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION || !SaisieVenteFactureSQLComponent.this.isFilling()) {
                    SQLElement sqleltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    int idModeRegl = rowCli.getInt("ID_MODE_REGLEMENT");
                    if (idModeRegl > 1) {
                        SQLRow rowModeRegl = sqleltModeRegl.getTable().getRow(idModeRegl);
                        SQLRowValues rowValsModeRegl = rowModeRegl.createUpdateRow();
                        rowValsModeRegl.clearPrimaryKeys();
                        SaisieVenteFactureSQLComponent.this.eltModeRegl.setValue(rowValsModeRegl);
                    }
                }
            }
            Where w = new Where((FieldRef)SaisieVenteFactureSQLComponent.this.tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE);
            w = SaisieVenteFactureSQLComponent.this.comboClient.isEmpty() ? w.and(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.getTable().getBase().getTable("AVOIR_CLIENT").getField("ID_CLIENT"), "=", -1)) : w.and(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.getTable().getBase().getTable("AVOIR_CLIENT").getField("ID_CLIENT"), "=", idCli));
            if (SaisieVenteFactureSQLComponent.this.getSelectedID() > 1) {
                SQLRow row = SaisieVenteFactureSQLComponent.this.getTable().getRow(SaisieVenteFactureSQLComponent.this.getSelectedID());
                w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.tableAvoir.getKey(), "=", row.getInt("ID_AVOIR_CLIENT")));
            }
            SaisieVenteFactureSQLComponent.this.selAvoir.getRequest().setWhere(w);
            SaisieVenteFactureSQLComponent.this.selAvoir.fillCombo();
        }
    };
    private PropertyChangeListener changeCompteListener;
    private PropertyChangeListener changeClientListener;
    private ISQLCompteSelector compteSelService;
    private JLabel labelCompteServ;
    private ElementComboBox comboCommercial;
    private ElementComboBox comboVerificateur = new ElementComboBox();
    private SQLTable tableBanque = this.getTable().getTable(BanqueSQLElement.TABLENAME);
    private final SQLRowAccessor defaultNum;
    private int previousClient = -1;
    private ElementComboBox comboNumAuto = null;
    private static final SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");

    public SaisieVenteFactureSQLComponent(int defaultNum) {
        super(Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE"));
        this.defaultNum = this.tableNum.getRow(defaultNum);
    }

    public SaisieVenteFactureSQLComponent() {
        this(2);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            this.addView(new JCheckBox(), "CREATE_VIRTUAL_STOCK");
        }
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (this.getTable().contains("ID_NUMEROTATION_AUTO")) {
            this.comboNumAuto = new ElementComboBox();
            this.addView(this.comboNumAuto, "ID_NUMEROTATION_AUTO");
        }
        this.checkPrevisionnelle = new JCheckBox();
        this.checkComplement = new JCheckBox();
        this.fieldTTC = new DeviseField();
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        this.textAvoirTTC = new DeviseField();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        if (this.getTable().contains("ID_POLE_PRODUIT")) {
            JLabel labelPole = new JLabel(this.getLabelFor("ID_POLE_PRODUIT"));
            labelPole.setHorizontalAlignment(4);
            this.add((Component)labelPole, c);
            ++c.gridx;
            ElementComboBox pole = new ElementComboBox();
            this.add((Component)pole, c);
            this.addSQLObject(pole, "ID_POLE_PRODUIT");
            ++c.gridy;
            c.gridwidth = 1;
            c.gridx = 0;
        }
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("DATE"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        final JDate dateSaisie = new JDate(true);
        dateSaisie.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!SaisieVenteFactureSQLComponent.this.isFilling() && dateSaisie.getValue() != null) {
                    int answer;
                    String nextNumero = NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, dateSaisie.getValue(), SaisieVenteFactureSQLComponent.this.defaultNum);
                    if (SaisieVenteFactureSQLComponent.this.textNumeroUnique.getText().trim().length() > 0 && !nextNumero.equalsIgnoreCase(SaisieVenteFactureSQLComponent.this.textNumeroUnique.getText()) && (answer = JOptionPane.showConfirmDialog(SaisieVenteFactureSQLComponent.this, "Voulez vous actualiser le num\u00e9ro de la facture?", "Changement du num\u00e9ro de facture", 0)) == 1) {
                        return;
                    }
                    SaisieVenteFactureSQLComponent.this.textNumeroUnique.setText(nextNumero);
                }
            }
        });
        this.add((Component)((Object)dateSaisie), c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        JLabel labelLibelle = new JLabel(this.getLabelFor("NOM"));
        labelLibelle.setHorizontalAlignment(4);
        this.add((Component)labelLibelle, c);
        SQLTextCombo textLibelle = new SQLTextCombo();
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)textLibelle, c);
        this.addSQLObject(textLibelle, "NOM");
        c.fill = 2;
        this.comboCommercial = new ElementComboBox(false);
        String field = "ID_COMMERCIAL";
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor(field), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)this.comboCommercial, c);
        this.addRequiredSQLObject(this.comboCommercial, field);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.comboClient = new ElementComboBox();
        this.add((Component)this.comboClient, c);
        if (this.getTable().contains("ID_ECHEANCIER_CCI")) {
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_ECHEANCIER_CCI"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 0;
            final ElementComboBox echeancier = new ElementComboBox();
            final SQLElement contactElement = Configuration.getInstance().getDirectory().getElement("ECHEANCIER_CCI");
            echeancier.init(contactElement, contactElement.getComboRequest(true));
            DefaultGridBagConstraints.lockMinimumSize(echeancier);
            this.addView(echeancier, "ID_ECHEANCIER_CCI");
            this.selAffaire.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (SaisieVenteFactureSQLComponent.this.selAffaire.getSelectedRow() != null) {
                        echeancier.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_AFFAIRE"), "=", SaisieVenteFactureSQLComponent.this.selAffaire.getSelectedRow().getID()));
                        if (!SaisieVenteFactureSQLComponent.this.isFilling()) {
                            SQLRow rowPole = SaisieVenteFactureSQLComponent.this.selAffaire.getSelectedRow().getForeignRow("ID_POLE_PRODUIT");
                            SaisieVenteFactureSQLComponent.this.comboCommercial.setValue(rowPole);
                        }
                    } else {
                        echeancier.getRequest().setWhere(null);
                    }
                }
            });
            this.add((Component)echeancier, c);
        }
        this.comboClient.addValueListener(this.changeClientListener);
        this.comboAdresse = new ElementComboBox();
        this.comboAdresse.setAddIconVisible(false);
        this.comboAdresse.setListIconVisible(false);
        JLabel labelAdresse = new JLabel(this.getLabelFor("ID_ADRESSE"), 4);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        labelAdresse.setHorizontalAlignment(4);
        this.add((Component)labelAdresse, c);
        ++c.gridx;
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.comboAdresse, c);
        this.checkAcompte = new JCheckBox(this.getLabelFor("ACOMPTE"));
        ++c.gridx;
        c.gridwidth = 0;
        c.gridwidth = 1;
        this.addView(this.checkAcompte, "ACOMPTE");
        this.checkCompteServiceAuto = new JCheckBox(this.getLabelFor("COMPTE_SERVICE_AUTO"));
        this.addSQLObject(this.checkCompteServiceAuto, "COMPTE_SERVICE_AUTO");
        this.compteSelService = new ISQLCompteSelector();
        this.labelCompteServ = new JLabel("Compte Service");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.labelCompteServ.setHorizontalAlignment(4);
        this.add((Component)this.labelCompteServ, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.compteSelService, c);
        String valServ = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServ = Boolean.valueOf(valServ);
        this.checkCompteServiceAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLComponent.this.setCompteServiceVisible(!SaisieVenteFactureSQLComponent.this.checkCompteServiceAuto.isSelected());
            }
        });
        this.setCompteServiceVisible(false);
        this.setCompteServiceVisible(bServ == null || bServ != false);
        final JPanel pAcompte = new JPanel();
        DeviseField textAcompteHT = new DeviseField();
        pAcompte.add(new JLabel("Acompte HT"));
        pAcompte.add(textAcompteHT);
        pAcompte.add(new JLabel("soit"));
        JTextField textAcompte = new JTextField(5);
        pAcompte.add(textAcompte);
        pAcompte.add(new JLabel("%"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        c.fill = 0;
        this.add((Component)pAcompte, c);
        c.anchor = 17;
        this.addView(textAcompte, "POURCENT_ACOMPTE");
        pAcompte.setVisible(false);
        this.tableFacture = new SaisieVenteFactureItemTable();
        final ElementComboBox boxTarif = new ElementComboBox();
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)new JLabel("Tarif \u00e0 appliquer", 4), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 1.0;
            DefaultGridBagConstraints.lockMinimumSize(boxTarif);
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    SaisieVenteFactureSQLComponent.this.tableFacture.setTarif(selectedRow, !SaisieVenteFactureSQLComponent.this.isFilling());
                }
            });
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        ITextArea infos = new ITextArea(4, 4);
        this.add((Component)this.tableFacture, c);
        this.addView(this.tableFacture.getRowValuesTable(), "");
        JPanel panelBottom = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cBottom = new DefaultGridBagConstraints();
        cBottom.weightx = 1.0;
        cBottom.anchor = 18;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        panelBottom.add((Component)this.eltModeRegl, cBottom);
        JPanel panelFrais = new JPanel();
        panelFrais.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        this.textPortHT = new DeviseField(5);
        DefaultGridBagConstraints.lockMinimumSize(this.textPortHT);
        this.addSQLObject(this.textPortHT, "PORT_HT");
        this.textRemiseHT = new DeviseField(5);
        DefaultGridBagConstraints.lockMinimumSize(this.textRemiseHT);
        this.addSQLObject(this.textRemiseHT, "REMISE_HT");
        cFrais.gridheight = 1;
        cFrais.gridx = 1;
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        if (this.getTable().contains("ID_TAXE_PORT")) {
            JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
            labelPortHT.setHorizontalAlignment(4);
            ++cFrais.gridy;
            panelFrais.add((Component)labelPortHT, cFrais);
            ++cFrais.gridx;
            panelFrais.add((Component)this.textPortHT, cFrais);
            JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
            labelTaxeHT.setHorizontalAlignment(4);
            cFrais.gridx = 1;
            ++cFrais.gridy;
            panelFrais.add((Component)labelTaxeHT, cFrais);
            ++cFrais.gridx;
            panelFrais.add((Component)boxTaxePort, cFrais);
            this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
            boxTaxePort.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
                }
            });
        }
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 1;
        panelFrais.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        panelFrais.add((Component)this.textRemiseHT, cFrais);
        ++cFrais.gridy;
        ++cBottom.gridx;
        cBottom.weightx = 1.0;
        cBottom.anchor = 12;
        cBottom.fill = 0;
        panelBottom.add((Component)panelFrais, cBottom);
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldTHA = new DeviseField();
        DeviseField fieldDevise = null;
        if (this.getTable().getFieldsName().contains("T_DEVISE")) {
            fieldDevise = new DeviseField();
            this.addSQLObject(fieldDevise, "T_DEVISE");
        }
        this.addSQLObject(fieldTHA, "T_HA");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(this.fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        JTextField poids = new JTextField();
        this.addSQLObject(poids, "T_POIDS");
        this.totalTTC = new TotalPanel(this.tableFacture, fieldHT, fieldTVA, this.fieldTTC, this.textPortHT, this.textRemiseHT, fieldService, fieldTHA, fieldDevise, poids, null, this.getTable().contains("ID_TAXE_PORT") ? boxTaxePort : null);
        DefaultGridBagConstraints.lockMinimumSize(this.totalTTC);
        ++cBottom.gridx;
        cBottom.weightx = 1.0;
        cBottom.anchor = 13;
        cBottom.fill = 2;
        panelBottom.add((Component)this.totalTTC, cBottom);
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)panelBottom, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 2;
        this.add((Component)this.createPanelAvoir(), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 1;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        JScrollPane comp = new JScrollPane(infos);
        infos.setBorder(null);
        DefaultGridBagConstraints.lockMinimumSize(comp);
        this.add((Component)comp, c);
        this.panelOO = new PanelOOSQLComponent(this);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 12;
        this.add((Component)this.panelOO, c);
        this.addSQLObject(this.textAvoirTTC, "T_AVOIR_TTC");
        this.addRequiredSQLObject((JComponent)((Object)dateSaisie), "DATE");
        this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
        this.addSQLObject(this.comboAdresse, "ID_ADRESSE");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        this.addSQLObject(infos, "INFOS");
        this.addSQLObject(this.checkPrevisionnelle, "PREVISIONNELLE");
        this.addSQLObject(this.checkComplement, "COMPLEMENT");
        this.addSQLObject(this.selAvoir, "ID_AVOIR_CLIENT");
        this.addSQLObject(this.compteSelService, "ID_COMPTE_PCE_SERVICE");
        ModeDeReglementSQLComponent modeReglComp = (ModeDeReglementSQLComponent)this.eltModeRegl.getSQLChild();
        this.selAvoir.getRequest().setWhere(new Where((FieldRef)this.tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE));
        this.selAvoir.fillCombo();
        int idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE");
        if (idCompteVenteService <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.compteSelService.setValue(idCompteVenteService);
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        DefaultGridBagConstraints.lockMinimumSize(this.comboCommercial);
        DefaultGridBagConstraints.lockMinimumSize(this.comboAdresse);
        this.comboClient.addValueListener(this.listenerModeReglDefaut);
        this.fieldTTC.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.refreshText();
            }
        });
        this.selAvoir.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaisieVenteFactureSQLComponent.this.refreshText();
            }
        });
        this.checkAcompte.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                pAcompte.setVisible(SaisieVenteFactureSQLComponent.this.checkAcompte.isSelected());
            }
        });
        this.changeClientListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SaisieVenteFactureSQLComponent.this.comboClient.getValue() != null) {
                    SQLRow row = SaisieVenteFactureSQLComponent.this.comboClient.getSelectedRow();
                    int id = row == null ? -1 : row.getID();
                    SaisieVenteFactureSQLComponent.this.defaultContactRowValues.putForeignID("ID_CLIENT", row);
                    if (SaisieVenteFactureSQLComponent.this.compteSelService != null && !row.isForeignEmpty("ID_COMPTE_PCE_SERVICE")) {
                        SaisieVenteFactureSQLComponent.this.compteSelService.setValue(row.getForeignID("ID_COMPTE_PCE_SERVICE"));
                    }
                    if (row != null) {
                        Where w;
                        if (SaisieVenteFactureSQLComponent.this.contact != null) {
                            w = new Where((FieldRef)SaisieVenteFactureSQLComponent.this.eltContact.getTable().getField("ID_CLIENT"), "=", -1);
                            w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.eltContact.getTable().getField("ID_CLIENT"), "=", id));
                            SaisieVenteFactureSQLComponent.this.contact.getRequest().setWhere(w);
                        }
                        if (SaisieVenteFactureSQLComponent.this.comboAdresse != null) {
                            w = new Where((FieldRef)TABLE_ADRESSE.getKey(), "=", row.getInt("ID_ADRESSE"));
                            w = w.or(new Where((FieldRef)TABLE_ADRESSE.getKey(), "=", row.getInt("ID_ADRESSE_L")));
                            w = w.or(new Where((FieldRef)TABLE_ADRESSE.getKey(), "=", row.getInt("ID_ADRESSE_F")));
                            SQLRow rowCli = row;
                            w = w.or(new Where((FieldRef)TABLE_ADRESSE.getField("ID_CLIENT"), "=", rowCli.getID()));
                            SaisieVenteFactureSQLComponent.this.comboAdresse.getRequest().setWhere(w);
                        }
                    } else if (SaisieVenteFactureSQLComponent.this.comboAdresse != null) {
                        SaisieVenteFactureSQLComponent.this.comboAdresse.getRequest().setWhere(null);
                    }
                    SaisieVenteFactureSQLComponent.this.previousClient = id;
                }
            }
        };
        this.changeCompteListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLSelect sel = new SQLSelect(SaisieVenteFactureSQLComponent.this.getTable().getBase());
                sel.addSelect(SaisieVenteFactureSQLComponent.this.client.getTable().getKey());
                Where where = new Where((FieldRef)SaisieVenteFactureSQLComponent.this.client.getTable().getField("ID_COMPTE_PCE"), "=", (Object)SaisieVenteFactureSQLComponent.this.compteSel.getValue());
                sel.setWhere(where);
                String req = sel.asString();
                List l = SaisieVenteFactureSQLComponent.this.getTable().getBase().getDataSource().execute(req);
                if (l != null && l.size() == 1) {
                    Map m = (Map)l.get(0);
                    Object o = m.get(SaisieVenteFactureSQLComponent.this.client.getTable().getKey().getName());
                    System.err.println("Only one value match :: " + o);
                    if (o != null) {
                        SaisieVenteFactureSQLComponent.this.comboClient.setValue((Integer)((Number)o).intValue());
                    }
                }
            }
        };
        this.textPortHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
            }
        });
        this.textRemiseHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
            }
        });
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SaisieVenteFactureSQLComponent.this.isFilling()) {
                    return;
                }
                SQLRow row = ((SQLRequestComboBox)evt.getSource()).getSelectedRow();
                if (row != null) {
                    Integer i;
                    int idCpt;
                    SaisieVenteFactureSQLComponent.this.defaultContactRowValues.putForeignID("ID_CLIENT", row);
                    if (SaisieVenteFactureSQLComponent.this.client.getTable().contains("ID_TARIF")) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow == null || foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID())) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(foreignRow);
                        }
                    }
                    if ((idCpt = row.getInt("ID_COMPTE_PCE")) <= 1 && (idCpt = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                        try {
                            idCpt = ComptePCESQLElement.getIdComptePceDefault("Clients");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (SaisieVenteFactureSQLComponent.this.compteSel != null && ((i = SaisieVenteFactureSQLComponent.this.compteSel.getValue()) == null || i != idCpt)) {
                        SaisieVenteFactureSQLComponent.this.compteSel.setValue(idCpt);
                    }
                }
            }
        });
    }

    private JPanel createPanelAvoir() {
        JPanel panelAvoir = new JPanel(new GridBagLayout());
        panelAvoir.setOpaque(false);
        DefaultGridBagConstraints cA = new DefaultGridBagConstraints();
        JLabel labelAvoir = new JLabel(this.getLabelFor("ID_AVOIR_CLIENT"));
        labelAvoir.setHorizontalAlignment(4);
        cA.weightx = 1.0;
        labelAvoir.setHorizontalAlignment(4);
        panelAvoir.add((Component)labelAvoir, cA);
        cA.weightx = 0.0;
        ++cA.gridx;
        this.selAvoir = new ElementComboBox();
        this.selAvoir.setAddIconVisible(false);
        panelAvoir.add((Component)this.selAvoir, cA);
        JLabel labelTotalAvoir = new JLabel("Total \u00e0 r\u00e9gler");
        this.textTotalAvoir = new DeviseField();
        this.textTotalAvoir.setEditable(false);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelAvoir.add((Component)labelTotalAvoir, cA);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelAvoir.add((Component)this.textTotalAvoir, cA);
        this.textTotalAvoir.setHorizontalAlignment(4);
        return panelAvoir;
    }

    private void setCompteServiceVisible(boolean b) {
        this.compteSelService.setVisible(b);
        this.labelCompteServ.setVisible(b);
    }

    private void refreshText() {
        Long n = this.fieldTTC.getValue();
        if (this.selAvoir.getSelectedId() > 1) {
            SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT").getTable();
            if (n != null) {
                long l;
                SQLRow row;
                int idAvoirOld;
                long ttc = n;
                SQLRow rowAvoir = tableAvoir.getRow(this.selAvoir.getSelectedId());
                long totalAvoir = ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
                totalAvoir -= ((Number)rowAvoir.getObject("MONTANT_SOLDE")).longValue();
                if (this.getSelectedID() > 1 && (idAvoirOld = (row = this.getTable().getRow(this.getSelectedID())).getInt("ID_AVOIR_CLIENT")) == rowAvoir.getID()) {
                    totalAvoir += Long.valueOf(row.getObject("T_AVOIR_TTC").toString()).longValue();
                }
                if ((l = ttc - totalAvoir) < 0L) {
                    l = 0L;
                    this.textAvoirTTC.setValue(ttc);
                } else {
                    this.textAvoirTTC.setValue(totalAvoir);
                }
                this.textTotalAvoir.setValue(l);
            } else {
                this.textTotalAvoir.setValue(0L);
            }
        } else {
            if (n != null) {
                this.textTotalAvoir.setValue((long)n);
            } else {
                this.textTotalAvoir.setValue(0L);
            }
            this.textAvoirTTC.setValue(0L);
        }
    }

    @Override
    public int insert(SQLRow order) {
        return this.commit(order);
    }

    private void createCompteServiceAuto(int id) throws SQLException {
        SQLRow rowPole = this.comboCommercial.getSelectedRow();
        SQLRow rowVerif = this.comboVerificateur.getSelectedRow();
        String verifInitiale = this.getInitialesFromVerif(rowVerif);
        int idCpt = ComptePCESQLElement.getId("706" + rowPole.getString("CODE") + verifInitiale, "Service " + rowPole.getString("NOM") + " " + rowVerif.getString("NOM"));
        SQLRowValues rowVals = this.getTable().getRow(id).createEmptyUpdateRow();
        rowVals.put("ID_COMPTE_PCE_SERVICE", idCpt);
        rowVals.update();
    }

    @Override
    public void select(SQLRowAccessor r) {
        this.panelOO.getCheckAbo().setSelected(false);
        boolean isPartial = false;
        if (r != null && r.getBoolean("PARTIAL") != null) {
            isPartial = r.getBoolean("PARTIAL");
        }
        boolean isSolde = false;
        if (r != null && r.getBoolean("SOLDE") != null) {
            isSolde = r.getBoolean("SOLDE");
        }
        if (r != null && !r.isUndefined() && (isPartial || isSolde)) {
            throw new IllegalArgumentException("Impossible de modifier une facturation interm\u00e9diaire");
        }
        if (this.compteSel != null) {
            this.compteSel.rmValueListener(this.changeCompteListener);
        }
        this.rowSelected = r;
        if (r != null && !r.isUndefined() && r.getObject("ID_MOUVEMENT") != null && !r.isForeignEmpty("ID_MOUVEMENT")) {
            SQLTable tableEcr = this.getTable().getTable("ECRITURE");
            SQLTable tableMvt = this.getTable().getTable("MOUVEMENT");
            SQLTable tablePiece = this.getTable().getTable("PIECE");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(tableEcr.getKey(), "COUNT");
            int idPiece = r.getForeign("ID_MOUVEMENT").getInt("ID_PIECE");
            Where w = new Where((FieldRef)tableMvt.getKey(), "=", tableEcr.getField("ID_MOUVEMENT"));
            w = w.and(new Where((FieldRef)tablePiece.getKey(), "=", tableMvt.getField("ID_PIECE")));
            w = w.and(new Where((FieldRef)tablePiece.getKey(), "=", idPiece));
            w = w.and(new Where((FieldRef)tableEcr.getField("POINTEE"), "!=", (Object)"").or(new Where((FieldRef)tableEcr.getField("LETTRAGE"), "!=", (Object)"")));
            sel.setWhere(w);
            Object o = Configuration.getInstance().getRoot().getBase().getDataSource().executeScalar(sel.asString());
            if (o != null && ((Number)o).longValue() > 0L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Attention cette facture est point\u00e9e ou lettr\u00e9e en comptabilit\u00e9. \nToute modification \u00e9crasera ces informations comptables.");
                    }
                });
            }
            sel = new SQLSelect();
            SQLTable tableAssoc = this.getTable().getTable("ASSOCIATION_ANALYTIQUE");
            sel.addSelect(tableAssoc.getKey(), "COUNT");
            int idPiece2 = r.getForeign("ID_MOUVEMENT").getInt("ID_PIECE");
            Where w2 = new Where((FieldRef)tableMvt.getKey(), "=", tableEcr.getField("ID_MOUVEMENT"));
            w2 = w2.and(new Where((FieldRef)tableAssoc.getField("ID_ECRITURE"), "=", tableEcr.getKey()));
            w2 = w2.and(new Where((FieldRef)tablePiece.getKey(), "=", tableMvt.getField("ID_PIECE")));
            w2 = w2.and(new Where((FieldRef)tablePiece.getKey(), "=", idPiece2));
            w2 = w2.and(new Where((FieldRef)tableAssoc.getField("GESTION_AUTO"), "=", (Object)Boolean.FALSE));
            sel.setWhere(w2);
            System.err.println(sel.asString());
            Object o2 = Configuration.getInstance().getRoot().getBase().getDataSource().executeScalar(sel.asString());
            if (o2 != null && ((Number)o2).longValue() > 0L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Attention la r\u00e9partition analytique a \u00e9t\u00e9 modifi\u00e9 manuellement sur cette facture. \nToute modification \u00e9crasera ces informations comptables.");
                    }
                });
            }
        }
        super.select(r);
        if (r != null) {
            Boolean b = (Boolean)r.getObject("ACOMPTE");
            if (b != null) {
                this.setAcompte(b);
            } else {
                this.setAcompte(false);
            }
        }
        if (this.comboClient != null) {
            this.comboClient.addValueListener(this.changeClientListener);
        }
        if (this.compteSel != null) {
            this.compteSel.addValueListener(this.changeCompteListener);
        }
    }

    private String getInitialesFromVerif(SQLRow row) {
        String s = "";
        if (row != null) {
            String nom;
            String prenom = row.getString("PRENOM");
            if (prenom != null && prenom.length() > 0) {
                s = String.valueOf(s) + prenom.toUpperCase().charAt(0);
            }
            if ((nom = row.getString("NOM")) != null && nom.length() > 0) {
                s = String.valueOf(s) + nom.toUpperCase().charAt(0);
            }
        }
        return s;
    }

    public int commit(SQLRow order) {
        int idSaisieVF = -1;
        long lFactureOld = 0L;
        SQLRow rowFactureOld = null;
        SQLRow rowFacture = null;
        SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        if (this.textNumeroUnique.checkValidation()) {
            try {
                if (this.getMode() == SQLComponent.Mode.INSERTION) {
                    SQLRow rowNum;
                    idSaisieVF = super.insert(order);
                    rowFacture = this.getTable().getRow(idSaisieVF);
                    SQLRow sQLRow = rowNum = this.comboNumAuto == null ? this.tableNum.getRow(2) : this.comboNumAuto.getSelectedRow();
                    if (NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, rowFacture.getDate("DATE").getTime(), rowNum).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                        SQLRowValues rowVals = rowNum.createEmptyUpdateRow();
                        String labelNumberFor = NumerotationAutoSQLElement.getLabelNumberFor(SaisieVenteFactureSQLElement.class);
                        int val = rowNum.getInt(labelNumberFor);
                        rowVals.put(labelNumberFor, (Object)(++val));
                        rowVals.update();
                    }
                } else if (JOptionPane.showConfirmDialog(this, "Attention en modifiant cette facture, vous supprimerez les ch\u00e9ques et les \u00e9ch\u00e9ances associ\u00e9s. Continuer?", "Modification de facture", 0) == 0) {
                    SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
                    if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
                        SQLSelect sel = new SQLSelect();
                        sel.addSelect(eltMvtStock.getTable().getField("ID"));
                        Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", this.getSelectedID());
                        Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
                        sel.setWhere(w.and(w2));
                        List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
                        if (l != null) {
                            int i = 0;
                            while (i < l.size()) {
                                Object[] tmp = (Object[])l.get(i);
                                try {
                                    eltMvtStock.archive(((Number)tmp[0]).intValue());
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                }
                                ++i;
                            }
                        }
                    }
                    rowFactureOld = this.getTable().getRow(this.getSelectedID());
                    lFactureOld = ((Number)rowFactureOld.getObject("T_HT")).longValue();
                    super.update();
                    idSaisieVF = this.getSelectedID();
                } else {
                    return idSaisieVF;
                }
                rowFacture = this.getTable().getRow(idSaisieVF);
                ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
                this.tableFacture.updateField("ID_SAISIE_VENTE_FACTURE", idSaisieVF);
                this.tableFacture.createArticle(idSaisieVF, this.getElement());
                this.createDocument(rowFacture);
                int idMvt = -1;
                if (!this.checkPrevisionnelle.isSelected()) {
                    SaisieVenteFactureSQLElement.DoWithRow doWithRow;
                    int idAvoir;
                    if (this.getMode() == SQLComponent.Mode.MODIFICATION) {
                        idMvt = rowFacture.getInt("ID_MOUVEMENT");
                        System.err.println("Archivage des fils");
                        EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                        eltEcr.archiveMouvementProfondeur(idMvt, false);
                    }
                    System.err.println("Regeneration des ecritures");
                    if (idMvt > 1) {
                        new GenerationMvtSaisieVenteFacture(idSaisieVF, idMvt);
                    } else {
                        new GenerationMvtSaisieVenteFacture(idSaisieVF);
                    }
                    System.err.println("Fin regeneration");
                    this.updateStock(idSaisieVF);
                    if (rowFactureOld != null && rowFactureOld.getInt("ID_AVOIR_CLIENT") > 1) {
                        SQLRow rowAvoir = rowFactureOld.getForeignRow("ID_AVOIR_CLIENT");
                        Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
                        Long avoirTTC = (Long)rowFactureOld.getObject("T_AVOIR_TTC");
                        long montant = montantSolde - avoirTTC;
                        if (montant < 0L) {
                            montant = 0L;
                        }
                        SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                        rowVals.put("SOLDE", Boolean.FALSE);
                        rowVals.put("MONTANT_SOLDE", montant);
                        Long restant = (Long)rowAvoir.getObject("MONTANT_TTC") - montantSolde;
                        rowVals.put("MONTANT_RESTANT", restant);
                        rowVals.update();
                    }
                    if ((idAvoir = rowFacture.getInt("ID_AVOIR_CLIENT")) > 1) {
                        SQLRow rowAvoir = rowFacture.getForeignRow("ID_AVOIR_CLIENT");
                        Long montantTTC = (Long)rowAvoir.getObject("MONTANT_TTC");
                        Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
                        Long factTTC = (Long)rowFacture.getObject("T_TTC");
                        long restant = montantTTC - montantSolde;
                        SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                        long l2 = factTTC - restant;
                        if (l2 >= 0L) {
                            rowVals.put("SOLDE", Boolean.TRUE);
                            rowVals.put("MONTANT_SOLDE", montantTTC);
                            rowVals.put("MONTANT_RESTANT", 0);
                        } else {
                            long m = montantSolde + factTTC;
                            rowVals.put("MONTANT_SOLDE", m);
                            rowVals.put("MONTANT_RESTANT", montantTTC - m);
                        }
                        rowVals.update();
                    }
                    if (this.getTable().getDBRoot().contains("ABONNEMENT") && this.panelOO.isCheckAboSelected() && (doWithRow = ((SaisieVenteFactureSQLElement)this.getElement()).getSpecialAction("subscription.autocreate")) != null) {
                        doWithRow.process(rowFacture);
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle("", e);
            }
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de facture existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idSaisieVF;
    }

    public void createDocument(SQLRow row) {
        VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(row);
        try {
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de g\u00e9n\u00e9rer la facture", e);
        }
    }

    @Override
    public void update() {
        this.commit(null);
    }

    public void loadDevis(int idDevis) {
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLInjector injector = SQLInjector.getInjector(devis.getTable(), this.getTable());
            SQLRow rowDevis = devis.getTable().getRow(idDevis);
            SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(idDevis);
            String string = rowDevis.getString("OBJET");
            createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ",") + rowDevis.getString("NUMERO"));
            this.select(createRowValuesFrom);
        }
        this.loadItem(this.tableFacture, devis, idDevis, devisElt);
    }

    public void loadFactureExistante(int idFacture) {
        Collection myListItem;
        SQLElement fact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLElement factElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        if (idFacture > 1) {
            SQLRow row = fact.getTable().getRow(idFacture);
            SQLRowValues rowVals = new SQLRowValues(fact.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            if (this.getTable().contains("ID_NUMEROTATION_AUTO")) {
                rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date(), row.getForeign("ID_NUMEROTATION_AUTO")));
            } else {
                rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
            }
            rowVals.put("NOM", row.getObject("NOM"));
            this.select(rowVals);
        }
        if ((myListItem = fact.getTable().getRow(idFacture).getReferentRows(factElt.getTable())).size() != 0) {
            this.tableFacture.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                this.tableFacture.getModel().addRow(rowVals);
                int rowIndex = this.tableFacture.getModel().getRowCount() - 1;
                this.tableFacture.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.tableFacture.getModel().clearRows();
        }
        this.tableFacture.getModel().fireTableDataChanged();
        this.tableFacture.repaint();
    }

    public List<SQLRowValues> createFactureAcompte(int idFacture, long acompte) {
        SQLElement fact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLElement factElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        if (idFacture > 1) {
            SQLRow row = fact.getTable().getRow(idFacture);
            SQLRowValues rowVals = new SQLRowValues(fact.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            rowVals.put("ID_AFFAIRE", row.getInt("ID_AFFAIRE"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
            rowVals.put("NOM", "Acompte de " + GestionDevise.currencyToString(acompte) + "\u20ac");
            this.select(rowVals);
        }
        Collection myListItem = fact.getTable().getRow(idFacture).getReferentRows(factElt.getTable());
        ArrayList<SQLRowValues> result = new ArrayList<SQLRowValues>(myListItem.size());
        if (myListItem.size() != 0) {
            this.tableFacture.getModel().clearRows();
            double acc = (double)acompte / (double)myListItem.size();
            long toAdd = 0L;
            SQLTable tablePourcentCCIP = Configuration.getInstance().getRoot().findTable("POURCENT_CCIP");
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowValsUp = rowElt.createUpdateRow();
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                long val = rowVals.getLong("T_PV_HT");
                double value = (acc + (double)toAdd) / (double)val * 100.0;
                if (value > 100.0) {
                    value = 100.0;
                    toAdd = (long)((double)toAdd + (acc - (double)val));
                } else {
                    toAdd = 0L;
                }
                BigDecimal pourcentAcompte = new BigDecimal((double)rowValsUp.getLong("POURCENT_ACOMPTE") - value);
                rowValsUp.put("POURCENT_ACOMPTE", pourcentAcompte);
                BigDecimal pourcentCurrentAcompte = new BigDecimal(value);
                rowVals.put("POURCENT_ACOMPTE", pourcentCurrentAcompte);
                Collection rowsCCIP = rowElt.getReferentRows(tablePourcentCCIP);
                if (rowsCCIP.size() > 0) {
                    SQLRowValues rowValsCCIP = ((SQLRow)rowsCCIP.get(0)).createUpdateRow();
                    rowValsCCIP.clearPrimaryKeys();
                    rowValsCCIP.put("ID_SAISIE_VENTE_FACTURE_ELEMENT", rowVals);
                    rowValsCCIP.put("NOM", "Acompte");
                    rowValsCCIP.put("POURCENT", pourcentCurrentAcompte);
                }
                System.err.println(value);
                this.tableFacture.getModel().addRow(rowVals);
                int rowIndex = this.tableFacture.getModel().getRowCount() - 1;
                this.tableFacture.getModel().fireTableModelModified(rowIndex);
            }
            if (toAdd > 0L) {
                int i = 0;
                while (i < this.tableFacture.getModel().getRowCount() && toAdd > 0L) {
                    SQLRowValues rowVals = this.tableFacture.getModel().getRowValuesAt(i);
                    if (rowVals.getFloat("POURCENT_ACOMPTE") < 100.0f) {
                        long val = rowVals.getLong("T_PV_HT");
                        double value = (acc + (double)toAdd) / (double)val * 100.0;
                        if (value > 100.0) {
                            value = 100.0;
                            toAdd = (long)((double)toAdd + (acc - (double)val));
                        } else {
                            toAdd = 0L;
                        }
                        rowVals.put("POURCENT_ACOMPTE", new BigDecimal(value));
                        this.tableFacture.getModel().fireTableModelModified(i);
                    }
                    ++i;
                }
            }
        } else {
            this.tableFacture.getModel().clearRows();
        }
        this.tableFacture.getModel().fireTableDataChanged();
        this.tableFacture.repaint();
        return result;
    }

    public void loadCommande(int idCmd) {
        SQLElement cmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        SQLElement cmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        if (idCmd > 1) {
            SQLInjector injector = SQLInjector.getInjector(cmd.getTable(), this.getTable());
            SQLRow rowCmd = cmd.getTable().getRow(idCmd);
            SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(idCmd);
            String string = rowCmd.getString("NOM");
            createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ",") + rowCmd.getString("NUMERO"));
            this.select(createRowValuesFrom);
            this.listenerModeReglDefaut.propertyChange(null);
        }
        this.loadItem(this.tableFacture, cmd, idCmd, cmdElt);
    }

    public void loadBonItems(SQLRowAccessor rowBL, boolean clear) {
        SQLElement bon = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLElement bonElt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON_ELEMENT");
        this.loadItem(this.tableFacture, bon, rowBL.getID(), bonElt, clear);
    }

    public void addRowItem(SQLRowValues row) {
        this.tableFacture.getModel().addRow(row);
    }

    @Override
    protected SQLRowValues createDefaults() {
        int idCompteVenteService;
        SQLRowValues vals = new SQLRowValues(this.getTable());
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(true);
            if (r.getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(r, null);
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        this.tableFacture.getModel().clearRows();
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            vals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        if (this.getTable().contains("ID_NUMEROTATION_AUTO")) {
            vals.put("ID_NUMEROTATION_AUTO", this.defaultNum.getID());
            vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date(), vals.getForeign("ID_NUMEROTATION_AUTO")));
        } else {
            vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
        }
        int idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT");
        if (idCompteVenteProduit <= 1) {
            try {
                idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE_VENTE", idCompteVenteProduit);
        if (this.checkCT != null) {
            vals.put("CONTROLE_TECHNIQUE", this.checkCT.isSelected());
        }
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            vals.put("CREATE_VIRTUAL_STOCK", Boolean.TRUE);
        }
        if ((idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE")) <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getTable().contains("ID_TAXE_PORT")) {
            SQLRow taxeDefault = TaxeCache.getCache().getFirstTaxe();
            vals.put("ID_TAXE_PORT", taxeDefault.getID());
        }
        vals.put("ID_COMPTE_PCE_SERVICE", idCompteVenteService);
        System.err.println("Defaults " + vals);
        return vals;
    }

    public void setDefaults() {
        this.resetValue();
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date(), this.defaultNum));
        this.tableFacture.getModel().clearRows();
    }

    public RowValuesTableModel getRowValuesTableModel() {
        return this.tableFacture.getModel();
    }

    @Deprecated
    public void setPrevisonnelle(boolean b) {
        this.checkPrevisionnelle.setSelected(b);
        if (!b) {
            this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
        }
    }

    public void setComplement(boolean b) {
        this.checkComplement.setSelected(b);
    }

    public void setAcompte(boolean b) {
        this.checkAcompte.setSelected(b);
        this.checkAcompte.firePropertyChange("ValueChanged", !b, b);
    }

    public void setTypeInterventionText(String text) {
        this.textTypeMission.setValue(text);
    }

    public void setReferenceClientText(String text) {
        this.refClient.setText(text);
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Saisie vente facture N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            SQLRow row = this.getTable().getRow(id);
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return SaisieVenteFactureSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT")), this.getTable().contains("CREATE_VIRTUAL_STOCK") && row.getBoolean("CREATE_VIRTUAL_STOCK") != false ? StockItemsUpdater.TypeStockUpdate.REAL_VIRTUAL_DELIVER : StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
            stockUpdater.update();
        }
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.tableFacture.getRowValuesTable();
    }
}

