/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;

public class ValidationEcriturePanel
extends JPanel {
    private final JDate dateValid;
    private final JLabel labelNbValid;
    private JButton buttonValid;
    private final JCheckBox checkCloture = new JCheckBox("Cl\u00f4turer cette p\u00e9riode");
    private final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();

    public ValidationEcriturePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        JLabel labelDate = new JLabel("Validation jusqu'au", 4);
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.dateValid = new JDate();
        this.add((Component)((Object)this.dateValid), c);
        this.dateValid.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValidationEcriturePanel.this.dateChanged();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.labelNbValid = new JLabel();
        this.labelNbValid.setText("S\u00e9lectionnez une date.");
        this.add((Component)this.labelNbValid, c);
        ++c.gridy;
        this.add((Component)this.checkCloture, c);
        ++c.gridy;
        c.fill = 0;
        c.anchor = 14;
        this.add((Component)this.createActions(), c);
    }

    private JPanel createActions() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1, 4, 0));
        this.buttonValid = new JButton("Valider");
        p.add(this.buttonValid);
        JButton buttonClose = new JButton("Annuler");
        p.add(buttonClose);
        this.buttonValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationEcriturePanel.this.validActionned();
            }
        });
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = (Window)SwingUtilities.getRoot(ValidationEcriturePanel.this);
                window.dispose();
            }
        });
        return p;
    }

    protected final void dateChanged() {
        if (this.dateValid.getDate() != null) {
            this.nbValidationEcriture(this.dateValid.getDate());
            this.buttonValid.setEnabled(true);
        } else {
            this.labelNbValid.setText("S\u00e9lectionnez une date.");
            this.buttonValid.setEnabled(false);
        }
    }

    protected final void validActionned() {
        EcritureSQLElement.validationEcrituresBefore(this.dateValid.getDate(), this.checkCloture.isSelected());
        JFrame f = (JFrame)SwingUtilities.getRoot(this);
        f.dispose();
    }

    private void nbValidationEcriture(Date d) {
        SQLTable tableEcriture = this.base.getTable("ECRITURE");
        SQLSelect selEcriture = new SQLSelect(this.base);
        selEcriture.addSelectFunctionStar("count");
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)d);
        Where w2 = new Where((FieldRef)tableEcriture.getField("VALIDE"), "!=", (Object)Boolean.TRUE);
        selEcriture.setWhere(w.and(w2));
        int nbEcritures = ((Number)this.base.getDataSource().executeScalar(selEcriture.asString())).intValue();
        if (nbEcritures != 0) {
            this.labelNbValid.setText("Validation de " + nbEcritures + " \u00e9critures.");
        } else {
            this.labelNbValid.setText("Aucune \u00e9critures \u00e0 valider.");
        }
    }
}

