/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.BalanceSheet;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorCompta;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorListener;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;

public class ImpressionBalancePanel
extends JPanel
implements SpreadSheetGeneratorListener {
    private final JDate dateEnd;
    private JButton valid;
    private JButton annul;
    private JCheckBox checkImpr;
    private JCheckBox checkVisu;
    private JCheckBox checkClientCentral;
    private JCheckBox checkFournCentral;
    private JProgressBar bar = new JProgressBar(0, 3);
    private JTextField compteDeb;
    private JTextField compteEnd;

    public ImpressionBalancePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        this.dateEnd = new JDate();
        this.add((Component)new JLabel("Balance au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)((Object)this.dateEnd), c);
        String valueDateEnd = DefaultNXProps.getInstance().getStringProperty("BalanceDateEnd");
        if (valueDateEnd.trim().length() > 0) {
            Long l = new Long(valueDateEnd);
            this.dateEnd.setValue(new Date(l));
        } else {
            this.dateEnd.setValue((Date)rowExercice.getObject("DATE_FIN"));
        }
        this.compteDeb = new JTextField();
        this.compteEnd = new JTextField();
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Du compte "), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.compteDeb, c);
        this.compteDeb.setText("1");
        this.compteEnd.setText("9");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.compteEnd, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.gridx = 0;
        this.checkClientCentral = new JCheckBox("Centralisation des comptes clients");
        this.add((Component)this.checkClientCentral, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.gridx = 0;
        this.checkFournCentral = new JCheckBox("Centralisation des comptes fournisseurs");
        this.add((Component)this.checkFournCentral, c);
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.bar.setStringPainted(true);
        this.add((Component)this.bar, c);
        this.valid = new JButton("Valider");
        this.annul = new JButton("Fermer");
        this.checkImpr = new JCheckBox("Impression");
        this.checkVisu = new JCheckBox("Visualisation");
        c.gridwidth = 2;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)this.checkImpr, c);
        this.checkImpr.setSelected(true);
        c.gridx += 2;
        this.add((Component)this.checkVisu, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 10;
        this.add((Component)this.valid, c);
        c.gridx += 2;
        this.add((Component)this.annul, c);
        this.checkValidity();
        this.valid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionBalancePanel.this.valid.setEnabled(false);
                ImpressionBalancePanel.this.bar.setString(null);
                ImpressionBalancePanel.this.bar.setValue(1);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BalanceSheet bSheet = new BalanceSheet(ImpressionBalancePanel.this.dateEnd.getDate(), ImpressionBalancePanel.this.compteDeb.getText(), ImpressionBalancePanel.this.compteEnd.getText(), ImpressionBalancePanel.this.checkClientCentral.isSelected(), ImpressionBalancePanel.this.checkFournCentral.isSelected());
                        final SpreadSheetGeneratorCompta generator = new SpreadSheetGeneratorCompta(bSheet, "Balance" + new Date().getTime(), ImpressionBalancePanel.this.checkImpr.isSelected(), ImpressionBalancePanel.this.checkVisu.isSelected());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImpressionBalancePanel.this.bar.setValue(2);
                                generator.addGenerateListener(ImpressionBalancePanel.this);
                            }
                        });
                    }
                }).start();
            }
        });
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ImpressionBalancePanel.this)).dispose();
            }
        });
        this.dateEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionBalancePanel.this.checkValidity();
                ImpressionBalancePanel.this.storeValue();
            }
        });
    }

    private void checkValidity() {
        Date endDate = this.dateEnd.getDate();
        if (endDate == null) {
            this.valid.setEnabled(false);
        } else {
            this.valid.setEnabled(true);
        }
    }

    private void storeValue() {
        Date dFin = this.dateEnd.getDate();
        if (dFin != null) {
            DefaultNXProps.getInstance().setProperty("BalanceDateEnd", String.valueOf(dFin.getTime()));
        }
        DefaultNXProps.getInstance().store();
    }

    @Override
    public void taskEnd() {
        this.bar.setValue(3);
        this.bar.setString("Termin\u00e9e");
        this.valid.setEnabled(true);
    }
}

