/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.TitleLabel;
import org.openconcerto.erp.core.finance.accounting.report.Map2033A;
import org.openconcerto.erp.core.finance.accounting.report.Map2033B;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.Tuple2;

public class CompteResultatBilanPanel
extends JPanel {
    private JTextField textFieldResultat = new JTextField();
    private JTextField textFieldBilan = new JTextField();
    private final JDate dateDebutPeriode = new JDate();
    private final JDate dateFinPeriode = new JDate();
    private JButton buttonRemplirBilan = new JButton("Remplir la d\u00e9claration");
    private JButton buttonRemplirResultat = new JButton("Remplir la d\u00e9claration");

    public CompteResultatBilanPanel() {
        this.setLayout(new GridBagLayout());
        TitleLabel labelBilan = new TitleLabel("Compte de Bilan");
        TitleLabel labelResultat = new TitleLabel("Compte de R\u00e9sultat");
        labelBilan.setOpaque(true);
        labelResultat.setOpaque(true);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textFieldResultat.setEditable(false);
        this.textFieldBilan.setEditable(false);
        JPanel panelPeriode = new JPanel();
        panelPeriode.add(new JLabel("P\u00e9riode du "));
        panelPeriode.add((Component)((Object)this.dateDebutPeriode));
        panelPeriode.add(new JLabel(" au "));
        panelPeriode.add((Component)((Object)this.dateFinPeriode));
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelPeriode, c);
        this.setUpDatePeriode();
        c.gridwidth = 0;
        c.weightx = 1.0;
        ++c.gridy;
        this.add((Component)labelBilan, c);
        ++c.gridy;
        this.add((Component)new JSeparator(), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("G\u00e9n\u00e9ration du bilan (Cerfa DGI N\u00b02033A)"), c);
        final JProgressBar progressBarBilan = new JProgressBar();
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)progressBarBilan, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.buttonRemplirBilan, c);
        this.buttonRemplirBilan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map2033A map2033A = new Map2033A(progressBarBilan, CompteResultatBilanPanel.this.dateDebutPeriode.getDate(), CompteResultatBilanPanel.this.dateFinPeriode.getDate());
                map2033A.generateMap2033A();
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Le document se trouvera dans le dossier :"), c);
        ++c.gridy;
        c.gridx = 0;
        JButton buttonOpenLocationBilan = new JButton(new ImageIcon(ElementComboBox.class.getResource("loupe.png")));
        this.setIconJButton(buttonOpenLocationBilan);
        buttonOpenLocationBilan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompteResultatBilanPanel.this.openFolder("Location2033APDF");
            }
        });
        JPanel panelLocationBilan = new JPanel();
        panelLocationBilan.setLayout(new GridBagLayout());
        GridBagConstraints cp = new GridBagConstraints();
        cp.fill = 2;
        cp.gridheight = 1;
        cp.gridwidth = 1;
        cp.gridx = 0;
        cp.gridy = 0;
        cp.anchor = 17;
        cp.weighty = 0.0;
        cp.insets = new Insets(2, 2, 1, 2);
        cp.weightx = 1.0;
        panelLocationBilan.add((Component)this.textFieldBilan, cp);
        cp.weightx = 0.0;
        ++cp.gridx;
        cp.fill = 0;
        panelLocationBilan.add((Component)buttonOpenLocationBilan, cp);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)panelLocationBilan, c);
        c.fill = 2;
        c.weightx = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)new JSeparator(), c);
        ++c.gridy;
        this.add((Component)labelResultat, c);
        ++c.gridy;
        this.add((Component)new JSeparator(), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("G\u00e9n\u00e9ration du r\u00e9sultat (Cerfa DGI N\u00b02033B)"), c);
        final JProgressBar progressBarResultat = new JProgressBar();
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)progressBarResultat, c);
        ++c.gridx;
        progressBarResultat.setMaximum(100);
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.buttonRemplirResultat, c);
        this.buttonRemplirResultat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Map2033B map2033B = new Map2033B(progressBarResultat, CompteResultatBilanPanel.this.dateDebutPeriode.getDate(), CompteResultatBilanPanel.this.dateFinPeriode.getDate());
                        map2033B.generateMap();
                    }
                });
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.add((Component)new JLabel("Le document se trouvera dans le dossier :"), c);
        ++c.gridy;
        JButton buttonOpenLocationResultat = new JButton(new ImageIcon(ElementComboBox.class.getResource("loupe.png")));
        this.setIconJButton(buttonOpenLocationResultat);
        buttonOpenLocationResultat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompteResultatBilanPanel.this.openFolder("Location2033BPDF");
            }
        });
        JPanel panelLocationResultat = new JPanel();
        panelLocationResultat.setLayout(new GridBagLayout());
        GridBagConstraints cp2 = new GridBagConstraints();
        cp2.fill = 2;
        cp2.gridheight = 1;
        cp2.gridwidth = 1;
        cp2.gridx = 0;
        cp2.gridy = 0;
        cp2.anchor = 17;
        cp2.weighty = 0.0;
        cp2.insets = new Insets(2, 2, 1, 2);
        cp2.weightx = 1.0;
        panelLocationResultat.add((Component)this.textFieldResultat, cp2);
        cp2.weightx = 0.0;
        ++cp2.gridx;
        cp2.fill = 0;
        panelLocationResultat.add((Component)buttonOpenLocationResultat, cp2);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)panelLocationResultat, c);
        JButton buttonClose = new JButton("Fermer");
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(CompteResultatBilanPanel.this)).dispose();
            }
        });
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 14;
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        this.add((Component)buttonClose, c);
        this.setTextLocation();
        this.dateDebutPeriode.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CompteResultatBilanPanel.this.isDateValid();
            }
        });
        this.dateFinPeriode.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CompteResultatBilanPanel.this.isDateValid();
            }
        });
    }

    private void setIconJButton(JButton res) {
        res.setMargin(new Insets(1, 1, 1, 1));
    }

    private void setTextLocation() {
        File f2033APDF = new File(String.valueOf(TemplateNXProps.getInstance().getStringProperty("Location2033APDF")) + "\\" + String.valueOf(Calendar.getInstance().get(1)));
        File f2033BPDF = new File(String.valueOf(TemplateNXProps.getInstance().getStringProperty("Location2033BPDF")) + "\\" + String.valueOf(Calendar.getInstance().get(1)));
        try {
            this.textFieldBilan.setText(f2033APDF.getCanonicalPath());
            this.textFieldResultat.setText(f2033BPDF.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void openFolder(String locationProperty) {
        String file = String.valueOf(TemplateNXProps.getInstance().getStringProperty(locationProperty)) + File.separator + String.valueOf(Calendar.getInstance().get(1));
        System.err.println(file);
        File f = new File(file);
        f.mkdirs();
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.BROWSE)) {
                try {
                    d.browse(f.getCanonicalFile().toURI());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(null, "Cette action n'est pas support\u00e9e par votre syst\u00e8me d'exploitation.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Votre syst\u00e8me d'exploitation n'est pas support\u00e9.");
        }
    }

    private void setUpDatePeriode() {
        new SwingWorker<Tuple2<Date, Date>, Object>(){

            @Override
            protected Tuple2<Date, Date> doInBackground() throws Exception {
                SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
                SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
                Date dateFin = (Date)rowExercice.getObject("DATE_FIN");
                Date dateDeb = (Date)rowExercice.getObject("DATE_DEB");
                return new Tuple2<Date, Date>(dateDeb, dateFin);
            }

            @Override
            protected void done() {
                try {
                    Tuple2 t = (Tuple2)this.get();
                    CompteResultatBilanPanel.this.dateDebutPeriode.setValue((Date)t.get0());
                    CompteResultatBilanPanel.this.dateFinPeriode.setValue((Date)t.get1());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }

    private void isDateValid() {
        System.err.println("Check date");
        Date dDeb = this.dateDebutPeriode.getDate();
        Date dEnd = this.dateFinPeriode.getDate();
        if (dDeb != null && dEnd != null) {
            boolean b = dDeb.before(dEnd);
            this.buttonRemplirBilan.setEnabled(b);
            this.buttonRemplirResultat.setEnabled(b);
        }
    }
}

