/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.common.ui.RowValuesMultiLineEditTable;
import org.openconcerto.erp.core.finance.accounting.ui.AssociationAnalytiqueItemKDModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class AssociationAnalytiqueKDTable
extends JPanel {
    private final RowValuesMultiLineEditTable table;
    private static final SQLElement ELEMENT = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE");

    public AssociationAnalytiqueKDTable(SQLRowValues defaultRow) {
        this(defaultRow, false);
    }

    public AssociationAnalytiqueKDTable(SQLRowValues defaultRow, boolean readOnly) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        ArrayList list = new ArrayList();
        RowValuesTableModel model = new AssociationAnalytiqueItemKDModel().getModel();
        this.table = new RowValuesMultiLineEditTable(model, null, "ANALYTIQUE"){

            @Override
            public String getStringValue(SQLRowValues rowVals) {
                return AssociationAnalytiqueKDTable.getStringAssocs(rowVals);
            }
        };
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        RowValuesTableControlPanel panelControl = new RowValuesTableControlPanel(this.table);
        panelControl.setVisibleButtonHaut(false);
        panelControl.setVisibleButtonBas(false);
        panelControl.setVisibleButtonClone(false);
        panelControl.setVisibleButtonInserer(false);
        this.add((Component)panelControl, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
        JButton buttonValider = new JButton("Valider les modifications");
        JButton buttonFermer = new JButton("Fermer");
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 0;
        JPanel panelButton = new JPanel();
        panelButton.add(buttonValider);
        panelButton.add(buttonFermer);
        this.add((Component)panelButton, c);
        buttonValider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AssociationAnalytiqueKDTable.this.updateField(AssociationAnalytiqueKDTable.this.table.getForeignField());
                AssociationAnalytiqueKDTable.this.table.closeTable();
            }
        });
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AssociationAnalytiqueKDTable.this.table.closeTable();
            }
        });
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, 200));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
    }

    public void updateField(String field) {
        this.updateField(field, this.table.getRowValuesRoot());
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void updateField(String field, SQLRowValues rowVals) {
        this.table.updateField(field, rowVals);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public void insertFrom(String field, SQLRowValues rowVals) {
        this.table.insertFrom(field, rowVals);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public RowValuesMultiLineEditTable getTable() {
        return this.table;
    }

    public static String getStringAssocs(SQLRowValues rowVals) {
        StringBuffer buf = new StringBuffer();
        SQLTable tableElement = ELEMENT.getTable();
        if (rowVals.getID() > 1) {
            SQLRow row = rowVals.getTable().getRow(rowVals.getID());
            Collection rowSet = row.getReferentRows(tableElement);
            for (SQLRow row2 : rowSet) {
                buf.append(String.valueOf(AssociationAnalytiqueKDTable.getStringAssoc(row2)) + ", ");
            }
        } else {
            Collection<SQLRowValues> colRows = rowVals.getReferentRows();
            for (SQLRowValues rowValues : colRows) {
                if (!rowValues.getTable().getName().equalsIgnoreCase(tableElement.getName())) continue;
                buf.append(String.valueOf(AssociationAnalytiqueKDTable.getStringAssoc(rowValues)) + ", ");
            }
        }
        String string = buf.toString();
        if (string.length() > 2) {
            string = string.substring(0, string.length() - 2);
        }
        return string.trim();
    }

    private static String getStringAssoc(SQLRowAccessor row) {
        StringBuffer buf = new StringBuffer();
        SQLRowAccessor rowVerif = row.getForeign("ID_POSTE_ANALYTIQUE");
        if (rowVerif != null) {
            buf.append(rowVerif.getString("NOM"));
        }
        return buf.toString();
    }
}

