/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.JournauxSheet;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.GestionDevise;

public class JournauxMoisSheet
extends JournauxSheet {
    private static DateFormat dateFormatMonth = new SimpleDateFormat("MMMM");
    private static DateFormat dateFormatYear = new SimpleDateFormat("yyyy");
    private static DateFormat dateFormatPG = new SimpleDateFormat("yyyy-MM-dd");

    public JournauxMoisSheet(int[] id, Date du, Date au, int lettrage) {
        super(id, du, au, lettrage, "1", "8");
        this.modele = "JournauxMois.ods";
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        String schema = ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName();
        String select = "SELECT SUM(\"DEBIT\"), SUM(\"CREDIT\"), EXTRACT(MONTH FROM \"DATE\"), EXTRACT(YEAR FROM \"DATE\"),\"JOURNAL\".\"ID\" FROM \"" + schema + "\".\"ECRITURE\" , \"" + schema + "\".\"JOURNAL\" ";
        String groupBy = " GROUP BY EXTRACT(YEAR FROM \"DATE\"), EXTRACT(MONTH FROM \"DATE\"),\"JOURNAL\".\"ID\"";
        String orderBy = " ORDER BY \"JOURNAL\".\"ID\",EXTRACT(YEAR FROM \"DATE\"), EXTRACT(MONTH FROM \"DATE\")";
        if (this.idS != null && this.idS.length > 0) {
            select = String.valueOf(select) + " WHERE";
            int i = 0;
            while (i < this.idS.length) {
                select = i == 0 ? String.valueOf(select) + "( \"" + schema + "\".\"JOURNAL\".\"ID\" = " + this.idS[i] : String.valueOf(select) + " OR \"" + schema + "\".\"JOURNAL\".\"ID\" = " + this.idS[i];
                ++i;
            }
            select = String.valueOf(select) + ")";
        }
        if (this.lettrage == 2) {
            if (this.idS != null && this.idS.length > 0) {
                select = String.valueOf(select) + " AND  \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" <> NULL";
                select = String.valueOf(select) + " AND  \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" != ''";
            } else {
                select = String.valueOf(select) + " WHERE  \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" <> NULL";
                select = String.valueOf(select) + " AND  \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" != ''";
            }
        } else if (this.lettrage == 3) {
            if (this.idS != null && this.idS.length > 0) {
                select = String.valueOf(select) + " AND  (\"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" = NULL";
                select = String.valueOf(select) + " OR \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" = '')";
            } else {
                select = String.valueOf(select) + " WHERE  \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" = NULL";
                select = String.valueOf(select) + " OR  \"" + schema + "\".\"ECRITURE\".\"LETTRAGE\" = ''";
            }
        }
        select = String.valueOf(select) + " AND \"" + schema + "\".\"JOURNAL\".\"ID\"!=1";
        select = String.valueOf(select) + " AND \"" + schema + "\".\"ECRITURE\".\"ID\"!=1";
        select = String.valueOf(select) + " AND \"" + schema + "\".\"JOURNAL\".\"ARCHIVE\"!=1";
        select = String.valueOf(select) + " AND \"" + schema + "\".\"ECRITURE\".\"ARCHIVE\"!=1";
        if (!UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            select = String.valueOf(select) + " AND \"" + schema + "\".\"ECRITURE\".\"COMPTE_NUMERO\" LIKE '411%'";
        }
        select = String.valueOf(select) + " AND \"" + schema + "\".\"ECRITURE\".\"DATE\" BETWEEN '" + dateFormatPG.format(this.dateDu) + "' AND '" + dateFormatPG.format(this.dateAu) + "'";
        select = String.valueOf(select) + " AND \"" + schema + "\".\"JOURNAL\".\"ID\"=\"" + schema + "\".\"ECRITURE\".\"ID_JOURNAL\"" + groupBy + orderBy;
        System.err.println(select);
        List l = (List)base.getDataSource().execute(select, new ArrayListHandler());
        int posLine = 1;
        int firstLine = 1;
        System.err.println("START CREATE JOURNAUX, NB ecritures  " + l.size());
        this.nbPage = 0;
        long totalDebit = 0L;
        long totalCredit = 0L;
        SQLRow rowFirstJournal = null;
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            int idJrnl = Integer.valueOf(tmp[4].toString());
            int year = Double.valueOf(tmp[3].toString()).intValue();
            int month = Double.valueOf(tmp[2].toString()).intValue();
            long credit = Integer.valueOf(tmp[1].toString()).intValue();
            long debit = Integer.valueOf(tmp[0].toString()).intValue();
            if (rowFirstJournal == null || rowFirstJournal.getID() != idJrnl) {
                totalDebit = 0L;
                totalCredit = 0L;
            }
            rowFirstJournal = tableJournal.getRow(idJrnl);
            System.err.println("START NEW PAGE --> Journal : " + rowFirstJournal.getString("NOM") + "; POS : " + posLine);
            this.makeEntete(posLine, rowFirstJournal.getString("NOM"));
            posLine += debutFill - 1;
            Calendar cal = Calendar.getInstance();
            int j = 0;
            while (j < endFill - debutFill + 1 && i < l.size()) {
                tmp = (Object[])l.get(i);
                idJrnl = Integer.valueOf(tmp[4].toString());
                year = Double.valueOf(tmp[3].toString()).intValue();
                month = Double.valueOf(tmp[2].toString()).intValue();
                credit = Integer.valueOf(tmp[1].toString()).intValue();
                debit = Integer.valueOf(tmp[0].toString()).intValue();
                SQLRow rowJournal = tableJournal.getRow(idJrnl);
                if (rowJournal.getID() != rowFirstJournal.getID()) break;
                this.mapStyleRow.put(new Integer(posLine), "Titre 1");
                cal.set(2, month - 1);
                cal.set(1, year);
                this.mCell.put("A" + posLine, dateFormatMonth.format(cal.getTime()));
                this.mCell.put("B" + posLine, dateFormatYear.format(cal.getTime()));
                this.mCell.put("C" + posLine, "");
                this.mCell.put("D" + posLine, "");
                long solde = debit - credit;
                totalCredit += credit;
                totalDebit += debit;
                this.mCell.put("E" + posLine, debit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(debit, false)));
                this.mCell.put("F" + posLine, credit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(credit, false)));
                this.mCell.put("G" + posLine, solde == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(solde, false)));
                ++i;
                ++posLine;
                ++j;
            }
            posLine = firstLine + endFill;
            this.mCell.put("E" + posLine, totalDebit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit, false)));
            this.mCell.put("F" + posLine, totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalCredit, false)));
            this.mCell.put("G" + posLine, totalDebit - totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
            this.makeBasPage(posLine += 2, rowFirstJournal.getString("NOM"));
            firstLine = ++posLine;
            ++this.nbPage;
        }
        if (this.nbPage > 0) {
            --this.nbPage;
        }
    }
}

