/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.common.ui.ITextComboVilleTableCellEditor;
import org.openconcerto.erp.core.common.ui.VilleTableCellRenderer;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.XTableColumnModel;

public class AdresseClientItemTable
extends JPanel {
    private RowValuesTable table;
    private SQLTableElement type;
    private SQLTableElement dest;
    private SQLTableElement rue;
    private SQLTableElement cedex;
    private SQLTableElement ville;
    private SQLTableElement province;
    private SQLTableElement pays;
    private SQLTableElement email;
    private RowValuesTableModel model;
    private SQLRowValues defaultRowVals;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();

    public AdresseClientItemTable() {
        this.init();
        this.uiInit();
        this.defaultRowVals = new SQLRowValues(this.getSQLElement().getTable());
        this.defaultRowVals.put("PAYS", "France");
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        this.type = new SQLTableElement(e.getTable().getField("TYPE"));
        list.add(this.type);
        this.dest = new SQLTableElement(e.getTable().getField("DEST"));
        list.add(this.dest);
        this.rue = new SQLTableElement(e.getTable().getField("RUE"));
        list.add(this.rue);
        this.ville = new SQLTableElement(e.getTable().getField("VILLE"), Ville.class, new ITextComboVilleTableCellEditor()){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                if (value != null) {
                    Ville v = (Ville)value;
                    row.put("CODE_POSTAL", v.getCodepostal());
                    row.put("VILLE", v.getName());
                } else {
                    row.put("CODE_POSTAL", "");
                    row.put("VILLE", "");
                }
                this.fireModification(row);
            }
        };
        this.ville.setRenderer(new VilleTableCellRenderer());
        list.add(this.ville);
        this.cedex = new SQLTableElement(e.getTable().getField("CEDEX"));
        list.add(this.cedex);
        this.province = new SQLTableElement(e.getTable().getField("PROVINCE"));
        list.add(this.province);
        this.pays = new SQLTableElement(e.getTable().getField("PAYS"));
        list.add(this.pays);
        this.email = new SQLTableElement(e.getTable().getField("EMAIL_CONTACT"));
        list.add(this.email);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("VILLE"));
        this.table = new RowValuesTable(this.model, null, true);
        this.setColumnVisible(this.model.getColumnForField("DEST"), false);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(this.model.getColumnForField(string), visibilityMap.get(string));
        }
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
    }

    protected void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }

    public static Map<String, Boolean> getVisibilityMap() {
        return visibilityMap;
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        RowValuesTableControlPanel control = new RowValuesTableControlPanel(this.table);
        this.add((Component)control, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ADRESSE");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public void refreshTable() {
        this.table.repaint();
    }

    public SQLRowValues getDefaultRowValues() {
        return this.defaultRowVals;
    }
}

