/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ClientNormalSQLComponent;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.ql.LabelCreator;
import org.openconcerto.ql.QLPrinter;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.utils.ExceptionHandler;

public class ClientNormalSQLElement
extends ComptaSQLConfElement {
    protected boolean showMdr = true;

    public ClientNormalSQLElement() {
        super("CLIENT", "un client", "clients");
        final String property = PrinterNXProps.getInstance().getProperty("QLPrinter");
        if (property != null && property.trim().length() > 0) {
            RowAction.PredicateRowAction actionPrintLabel = new RowAction.PredicateRowAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] s;
                    SQLRow row = IListe.get(e).fetchSelectedRow();
                    LabelCreator c = new LabelCreator(720);
                    c.setLeftMargin(10);
                    c.setTopMargin(10);
                    c.setDefaultFont(new Font("Verdana", 0, 50));
                    c.addLineBold(row.getString("NOM"));
                    SQLRowAccessor foreignRow = ((SQLRowAccessor)row).getForeign("ID_ADRESSE");
                    String string = foreignRow.getString("RUE");
                    String[] stringArray = s = string.split("\n");
                    int n = s.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray[n2];
                        c.addLineNormal(string2);
                        ++n2;
                    }
                    c.addLineNormal(String.valueOf(foreignRow.getString("CODE_POSTAL")) + " " + foreignRow.getString("VILLE"));
                    QLPrinter prt = new QLPrinter(property);
                    try {
                        prt.print(c.getImage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }, false, "customerrelationship.customer.label.print");
            actionPrintLabel.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionPrintLabel);
        }
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientNormalSQLElement.this.sendMail(IListe.get(e).getSelectedRows());
            }
        }, true, "customerrelationship.customer.email.send");
        action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(action);
    }

    protected void sendMail(List<SQLRowValues> l) {
        String mail = "";
        for (SQLRowAccessor sQLRowAccessor : l) {
            String string = sQLRowAccessor.getString("MAIL");
            if (string == null || string.trim().length() <= 0) continue;
            mail = String.valueOf(mail) + string + ";";
        }
        try {
            EmailComposer.getInstance().compose(mail, "", "", new File[0]);
        }
        catch (Exception exception) {
            ExceptionHandler.handle(null, "Impossible de cr\u00e9er le courriel", exception);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("RESPONSABLE");
        l.add("ID_ADRESSE");
        l.add("TEL");
        l.add("TEL_P");
        l.add("FAX");
        l.add("MAIL");
        l.add("NUMERO_TVA");
        l.add("SIRET");
        l.add("ID_COMPTE_PCE");
        l.add("ID_MODE_REGLEMENT");
        l.add("INFOS");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.grow("ID_MODE_REGLEMENT").put("AJOURS", null).put("LENJOUR", null);
            }
        };
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        if (this.getTable().getFieldsName().contains("LOCALISATION")) {
            l.add("LOCALISATION");
        } else {
            l.add("CODE");
        }
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_ADRESSE");
        Set<SQLField> fields = this.getTable().getForeignKeys("ADRESSE");
        for (SQLField sqlField : fields) {
            if (!sqlField.getName().startsWith("ID_ADRESSE_L")) continue;
            l.add(sqlField.getName());
        }
        l.add("ID_ADRESSE_F");
        l.add("ID_MODE_REGLEMENT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new ClientNormalSQLComponent(this);
    }
}

