/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class DeviseTableCellRenderer
extends DefaultTableCellRenderer {
    private final DecimalFormat decimalFormat = new DecimalFormat("##,##0.00#");
    private final DecimalFormat decimalFormat2 = new DecimalFormat("##,##0.00#######");
    private BigDecimal oneCents = new BigDecimal(0.01f);

    public DeviseTableCellRenderer() {
        DecimalFormatSymbols symbol = DecimalFormatSymbols.getInstance();
        symbol.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(symbol);
        this.decimalFormat2.setDecimalFormatSymbols(symbol);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(this, table, isSelected);
        this.setHorizontalAlignment(4);
        if (table.getColumnClass(column) != BigDecimal.class) {
            throw new IllegalStateException("Value is not a BigDecimal :" + table.getColumnClass(column));
        }
        if (value != null) {
            if (((BigDecimal)value).compareTo(this.oneCents) < 0) {
                this.setText(this.decimalFormat2.format(value));
            } else {
                this.setText(this.decimalFormat.format(value));
            }
        } else {
            this.setText("");
        }
        return this;
    }
}

