/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;

public class AcompteCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private AcompteField acompteField = new AcompteField();
    private String fieldNamePercent;
    private String fieldNameMontant;

    public AcompteCellEditor(String fieldNamePercent, String fieldNameMontant) {
        this.fieldNamePercent = fieldNamePercent;
        this.fieldNameMontant = fieldNameMontant;
    }

    public void addKeyListener(KeyListener l) {
        this.acompteField.addKeyListener(l);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        return this.acompteField.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        RowValuesTable rowValuesTable = (RowValuesTable)table;
        SQLRowValues rowVals = rowValuesTable.getRowValuesTableModel().getRowValuesAt(row);
        BigDecimal montant = rowVals.getBigDecimal(this.fieldNameMontant);
        BigDecimal percent = rowVals.getBigDecimal(this.fieldNamePercent);
        Acompte a = new Acompte(percent, montant);
        this.acompteField.setValue(a);
        this.acompteField.grabFocus();
        return this.acompteField;
    }
}

