/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.ExceptionHandler;

public abstract class AbstractArticleItemTable
extends JPanel {
    protected RowValuesTable table;
    protected SQLTableElement totalHT;
    protected SQLTableElement totalHA;
    protected SQLTableElement tableElementTVA;
    protected SQLTableElement tableElementTotalTTC;
    protected SQLTableElement tableElementTotalDevise;
    protected SQLTableElement service;
    protected SQLTableElement qte;
    protected SQLTableElement ha;
    protected SQLTableElement tableElementPoidsTotal;
    protected SQLTableElement prebilan;
    private RowValuesTableModel model;
    protected SQLRowValues defaultRowVals;
    private List<JButton> buttons = null;
    protected RowValuesTableControlPanel control = null;
    private SQLRowAccessor tarif = null;

    public AbstractArticleItemTable() {
        this.init();
        this.uiInit();
    }

    public AbstractArticleItemTable(List<JButton> buttons) {
        this.buttons = buttons;
        this.init();
        this.uiInit();
    }

    protected abstract void init();

    protected void setModel(RowValuesTableModel model) {
        this.model = model;
    }

    protected File getConfigurationFile() {
        return new File(Configuration.getInstance().getConfDir(), "Table/" + this.getConfigurationFileName());
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        this.control = new RowValuesTableControlPanel(this.table, this.buttons);
        this.control.setOpaque(false);
        this.add((Component)this.control, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setVerticalScrollBarPolicy(22);
        this.add((Component)comp, c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    protected abstract String getConfigurationFileName();

    public abstract SQLElement getSQLElement();

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getPrebilanElement() {
        return this.prebilan;
    }

    public SQLTableElement getPrixTotalHTElement() {
        return this.totalHT;
    }

    public SQLTableElement getPoidsTotalElement() {
        return this.tableElementPoidsTotal;
    }

    public SQLTableElement getPrixTotalTTCElement() {
        return this.tableElementTotalTTC;
    }

    public SQLTableElement getPrixServiceElement() {
        return this.service;
    }

    public SQLTableElement getQteElement() {
        return this.qte;
    }

    public SQLTableElement getHaElement() {
        return this.ha;
    }

    public SQLTableElement getTotalHaElement() {
        return this.totalHA;
    }

    public SQLTableElement getTVAElement() {
        return this.tableElementTVA;
    }

    public SQLTableElement getTableElementTotalDevise() {
        return this.tableElementTotalDevise;
    }

    public void deplacerDe(int inc) {
        int rowIndex = this.table.getSelectedRow();
        int dest = this.model.moveBy(rowIndex, inc);
        this.table.getSelectionModel().setSelectionInterval(dest, dest);
    }

    public float getPoidsTotal() {
        float poids = 0.0f;
        int poidsTColIndex = this.model.getColumnIndexForElement(this.tableElementPoidsTotal);
        if (poidsTColIndex >= 0) {
            int i = 0;
            while (i < this.table.getRowCount()) {
                Number tmp = (Number)this.model.getValueAt(i, poidsTColIndex);
                int level = 1;
                if (this.model.getRowValuesAt(i).getObject("NIVEAU") != null) {
                    level = this.model.getRowValuesAt(i).getInt("NIVEAU");
                }
                if (tmp != null && level == 1) {
                    poids += tmp.floatValue();
                }
                ++i;
            }
        }
        return poids;
    }

    public void refreshTable() {
        this.table.repaint();
    }

    public void createArticle(int id, SQLElement eltSource) {
        SQLElement eltArticleTable = this.getSQLElement();
        SQLTable tableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        SQLPreferences prefs = SQLPreferences.getMemCached(tableArticle.getDBRoot());
        boolean createArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        Collection listElts = eltSource.getTable().getRow(id).getReferentRows(eltArticleTable.getTable());
        SQLRowValues rowArticle = new SQLRowValues(tableArticle);
        Set<SQLField> fields = tableArticle.getFields();
        for (SQLRow rowElt : listElts) {
            Set<String> fieldsName = rowElt.getTable().getFieldsName();
            for (SQLField field : fields) {
                String name = field.getName();
                if (!fieldsName.contains(name) || field.isPrimaryKey()) continue;
                rowArticle.put(name, rowElt.getObject(name));
            }
            int idArt = -1;
            idArt = modeAvance ? ReferenceArticleSQLElement.getIdForCNM(rowArticle, createArticle) : ReferenceArticleSQLElement.getIdForCN(rowArticle, createArticle);
            if (!createArticle || idArt <= 1 || !rowElt.isForeignEmpty("ID_ARTICLE")) continue;
            try {
                rowElt.createEmptyUpdateRow().put("ID_ARTICLE", idArt).update();
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de l'affectation de l'article cr\u00e9e!", e);
            }
        }
    }

    public SQLRowValues getDefaultRowValues() {
        return this.defaultRowVals;
    }

    public SQLRowAccessor getTarif() {
        return this.tarif;
    }

    public void setTarif(SQLRowAccessor idTarif, boolean ask) {
        this.tarif = idTarif;
    }

    protected void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }

    protected void calculTarifNomenclature() {
        if (this.model.getRowCount() == 0) {
            return;
        }
        int columnForField = this.model.getColumnForField("NIVEAU");
        if (columnForField >= 0) {
            this.checkNiveau();
            int rowCount = this.model.getRowCount();
            int niveau = 4;
            while (niveau > 1) {
                int index = rowCount - 1;
                while (index > 0) {
                    BigDecimal prixUnitHT = BigDecimal.ZERO;
                    BigDecimal prixUnitHA = BigDecimal.ZERO;
                    boolean update = false;
                    int indexToUpdate = index;
                    int i = index;
                    while (i >= 0) {
                        indexToUpdate = i;
                        SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                        int niveauCourant = niveau;
                        if (rowVals.getObject("NIVEAU") != null) {
                            niveauCourant = rowVals.getInt("NIVEAU");
                        }
                        if (niveauCourant < niveau || niveauCourant == 1) break;
                        if (niveauCourant == niveau) {
                            update = true;
                            prixUnitHT = prixUnitHT.add(rowVals.getBigDecimal("PV_HT").multiply(new BigDecimal(rowVals.getInt("QTE"))).multiply(rowVals.getBigDecimal("QTE_UNITAIRE")));
                            prixUnitHA = prixUnitHA.add(rowVals.getBigDecimal("PA_HT").multiply(new BigDecimal(rowVals.getInt("QTE"))).multiply(rowVals.getBigDecimal("QTE_UNITAIRE")));
                        }
                        --i;
                    }
                    if (update) {
                        int columnForDeviseField;
                        int columnForFieldHA = this.model.getColumnForField("PRIX_METRIQUE_HA_1");
                        if (columnForFieldHA >= 0) {
                            this.model.setValueAt(prixUnitHA, indexToUpdate, columnForFieldHA);
                        }
                        if ((columnForDeviseField = this.model.getColumnForField("ID_DEVISE")) >= 0) {
                            this.model.setValueAt(ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getForeignID("ID_DEVISE"), indexToUpdate, columnForDeviseField);
                        }
                        this.model.setValueAt(prixUnitHT, indexToUpdate, this.model.getColumnForField("PRIX_METRIQUE_VT_1"));
                    }
                    index = indexToUpdate - 1;
                }
                --niveau;
            }
        }
    }

    private void checkNiveau() {
        int n = this.model.getRowCount();
        int columnForField = this.model.getColumnForField("NIVEAU");
        if (n > 0 && columnForField >= 0) {
            SQLRowValues rowValsFirst = this.model.getRowValuesAt(0);
            if (rowValsFirst.getObject("NIVEAU") == null || rowValsFirst.getInt("NIVEAU") != 1) {
                this.model.setValueAt(1, 0, columnForField);
            }
            int i = 1;
            while (i < n) {
                SQLRowValues rowValsPrev = this.model.getRowValuesAt(i - 1);
                SQLRowValues rowVals = this.model.getRowValuesAt(i);
                if (rowVals.getObject("NIVEAU") == null) {
                    this.model.setValueAt(1, i, columnForField);
                }
                int niveauPrev = rowValsPrev.getInt("NIVEAU");
                int niveau = rowVals.getInt("NIVEAU");
                if (niveau - niveauPrev > 1) {
                    this.model.setValueAt(niveauPrev, i, columnForField);
                }
                ++i;
            }
        }
    }

    public List<SQLRowValues> getRowValuesAtLevel(int level) {
        int rowCount = this.model.getRowCount();
        ArrayList<SQLRowValues> result = new ArrayList<SQLRowValues>(rowCount);
        int i = 0;
        while (i < rowCount) {
            SQLRowValues row = this.model.getRowValuesAt(i);
            if (row.getObject("NIVEAU") == null || row.getInt("NIVEAU") == level) {
                result.add(row);
            }
            ++i;
        }
        return result;
    }
}

