/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.panel.ChargementCreationSocietePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.CollectionMap;

public class SocieteCommonSQLElement
extends ConfSQLElement {
    private static final String TABLE_NAME = "SOCIETE_COMMON";

    public static final DBRoot getRoot(SQLRow company) {
        try {
            return SocieteCommonSQLElement.getRoot(company, false);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final DBRoot getRoot(SQLRow company, boolean allowRefresh) throws SQLException {
        String rootName = company.getString("DATABASE_NAME");
        DBSystemRoot sysRoot = company.getTable().getDBSystemRoot();
        if (allowRefresh && !sysRoot.contains(rootName)) {
            sysRoot.addRootToMap(rootName);
            sysRoot.refresh(TablesMap.createFromTables(rootName, Collections.singleton(TABLE_NAME)), true);
        }
        return sysRoot.getRoot(rootName);
    }

    public SocieteCommonSQLElement() {
        super(TABLE_NAME, "une soci\u00e9t\u00e9", "soci\u00e9t\u00e9s");
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        return CollectionMap.singleton(null, this.getListFields());
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_EXERCICE_COMMON");
        l.add("ID_ADRESSE_COMMON");
        return l;
    }

    public static final Date getDateDebutExercice() {
        SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
        SQLRow societeRow = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        return (Date)tableExercice.getRow(societeRow.getInt("ID_EXERCICE_COMMON")).getObject("DATE_DEB");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private JTextField textNom;
            private JTextField textNumSiret;
            private JTextField textNumNII;
            private JTextField textNumAPE;
            private JTextField textNumTel;
            private JTextField textNumFax;
            private JTextField textEmail;
            private JTextField textNumUrssaff;
            private JComboBox combo;
            private JLabel labelPlan;
            private ElementSQLObject eltExercice;
            private TitledSeparator sep;
            private TitledSeparator sepPlan;
            private SQLTextCombo textType;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.textNom = new JTextField();
                this.textNumAPE = new JTextField();
                this.textNumNII = new JTextField();
                this.textNumSiret = new JTextField();
                this.textNumTel = new JTextField();
                this.textNumFax = new JTextField();
                this.textEmail = new JTextField();
                this.textType = new SQLTextCombo();
                this.textNumUrssaff = new JTextField();
                TitledSeparator sepInfos = new TitledSeparator("Informations g\u00e9n\u00e9rales");
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)sepInfos, c);
                ++c.gridy;
                c.gridwidth = 1;
                JLabel labelType = new JLabel(this.getLabelFor("TYPE"));
                labelType.setHorizontalAlignment(4);
                this.add((Component)labelType, c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 1.0;
                this.add((Component)this.textType, c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.0;
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                labelNom.setHorizontalAlignment(4);
                this.add((Component)labelNom, c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 1.0;
                this.add((Component)this.textNom, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelNumSiret = new JLabel(this.getLabelFor("NUM_SIRET"));
                labelNumSiret.setHorizontalAlignment(4);
                this.add((Component)labelNumSiret, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textNumSiret, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelNumNII = new JLabel(this.getLabelFor("NUM_NII"));
                labelNumNII.setHorizontalAlignment(4);
                this.add((Component)labelNumNII, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textNumNII, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelNumUrs = new JLabel(this.getLabelFor("NUMERO_URSSAF"));
                labelNumUrs.setHorizontalAlignment(4);
                this.add((Component)labelNumUrs, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textNumUrssaff, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelNumAPE = new JLabel(this.getLabelFor("NUM_APE"));
                labelNumAPE.setHorizontalAlignment(4);
                this.add((Component)labelNumAPE, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textNumAPE, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelRCS = new JLabel(this.getLabelFor("RCS"));
                labelRCS.setHorizontalAlignment(4);
                this.add((Component)labelRCS, c);
                ++c.gridx;
                c.weightx = 1.0;
                JTextField fieldRCS = new JTextField();
                this.add((Component)fieldRCS, c);
                this.addView(fieldRCS, "RCS");
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelCapital = new JLabel(this.getLabelFor("CAPITAL"));
                labelCapital.setHorizontalAlignment(4);
                this.add((Component)labelCapital, c);
                ++c.gridx;
                c.weightx = 1.0;
                JTextField fieldCapital = new JTextField();
                this.add((Component)fieldCapital, c);
                this.addView(fieldCapital, "CAPITAL");
                if (this.getTable().contains("NUMERO_POLICE")) {
                    ++c.gridy;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    JLabel labelPolice = new JLabel(this.getLabelFor("NUMERO_POLICE"));
                    labelPolice.setHorizontalAlignment(4);
                    this.add((Component)labelPolice, c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    JTextField fieldPolice = new JTextField();
                    this.add((Component)fieldPolice, c);
                    this.addView(fieldPolice, "NUMERO_POLICE");
                }
                TitledSeparator sepAdresse = new TitledSeparator(this.getLabelFor("ID_ADRESSE_COMMON"));
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 4;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.fill = 1;
                this.add((Component)sepAdresse, c);
                this.addView("ID_ADRESSE_COMMON", "required;notdecorated;noseparator");
                ElementSQLObject eltAdr = (ElementSQLObject)this.getView("ID_ADRESSE_COMMON");
                ++c.gridy;
                this.add((Component)eltAdr, c);
                JPanel panelContact = new JPanel();
                panelContact.setLayout(new GridBagLayout());
                panelContact.setBorder(BorderFactory.createTitledBorder("Contacts"));
                DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
                JLabel labelNumTel = new JLabel(this.getLabelFor("NUM_TEL"));
                labelNumTel.setHorizontalAlignment(4);
                cc.weightx = 0.0;
                panelContact.add((Component)labelNumTel, cc);
                ++cc.gridx;
                cc.weightx = 1.0;
                panelContact.add((Component)this.textNumTel, cc);
                ++cc.gridy;
                cc.gridx = 0;
                cc.weightx = 0.0;
                JLabel labelNumFax = new JLabel(this.getLabelFor("NUM_FAX"));
                labelNumFax.setHorizontalAlignment(4);
                panelContact.add((Component)labelNumFax, cc);
                ++cc.gridx;
                cc.weightx = 1.0;
                panelContact.add((Component)this.textNumFax, cc);
                cc.gridx = 0;
                ++cc.gridy;
                cc.weightx = 0.0;
                JLabel labelEMail = new JLabel(this.getLabelFor("MAIL"));
                labelEMail.setHorizontalAlignment(4);
                panelContact.add((Component)labelEMail, cc);
                ++cc.gridx;
                cc.weightx = 1.0;
                panelContact.add((Component)this.textEmail, cc);
                ++c.gridy;
                c.gridwidth = 0;
                c.fill = 1;
                this.add((Component)panelContact, c);
                c.fill = 2;
                c.gridwidth = 1;
                if (this.getTable().contains("ID_DEVISE")) {
                    ++c.gridy;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    JLabel labelDevise = new JLabel(this.getLabelFor("ID_DEVISE"));
                    labelDevise.setHorizontalAlignment(4);
                    this.add((Component)labelDevise, c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    ElementComboBox boxDevise = new ElementComboBox();
                    this.add((Component)boxDevise, c);
                    this.addView(boxDevise, "ID_DEVISE");
                }
                this.sep = new TitledSeparator("Date de l'exercice");
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                c.insets = new Insets(10, 2, 1, 2);
                this.add((Component)this.sep, c);
                c.gridwidth = 1;
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.weighty = 1.0;
                c.anchor = 18;
                c.insets = new Insets(2, 2, 1, 2);
                this.addView("ID_EXERCICE_COMMON", "required;notdecorated;noseparator");
                this.eltExercice = (ElementSQLObject)this.getView("ID_EXERCICE_COMMON");
                c.gridwidth = 0;
                this.add((Component)this.eltExercice, c);
                this.sepPlan = new TitledSeparator("Plan comptable de l'entreprise");
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                c.insets = new Insets(10, 2, 1, 2);
                this.add((Component)this.sepPlan, c);
                JPanel panelPlan = new JPanel();
                this.labelPlan = new JLabel("Choix du plan comptable", 4);
                this.combo = new JComboBox();
                this.combo.addItem("Base");
                this.combo.addItem("Abr\u00e9g\u00e9");
                this.combo.addItem("D\u00e9velopp\u00e9");
                panelPlan.add(this.labelPlan);
                panelPlan.add(this.combo);
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                c.insets = new Insets(2, 2, 1, 2);
                c.fill = 0;
                this.add((Component)panelPlan, c);
                ++c.gridy;
                JPanel additionalPanel = new JPanel();
                this.add((Component)additionalPanel, c);
                this.setAdditionalFieldsPanel(new FormLayouter(additionalPanel, 2, 1));
                this.addRequiredSQLObject(this.textNom, "NOM");
                this.addRequiredSQLObject(this.textNumAPE, "NUM_APE");
                this.addRequiredSQLObject(this.textNumNII, "NUM_NII");
                this.addRequiredSQLObject(this.textNumSiret, "NUM_SIRET");
                this.addSQLObject(this.textEmail, "MAIL");
                this.addSQLObject(this.textNumTel, "NUM_TEL");
                this.addSQLObject(this.textNumFax, "NUM_FAX");
                this.addSQLObject(this.textNumUrssaff, "NUMERO_URSSAF");
                this.addSQLObject(this.textType, "TYPE");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                SQLRow row = this.getTable().getRow(id);
                SQLRowValues rowVals = row.getForeignRow("ID_EXERCICE_COMMON").createEmptyUpdateRow();
                rowVals.put("ID_SOCIETE_COMMON", id);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.creationBase(id, this.combo.getSelectedIndex());
                return id;
            }

            private void creationBase(int id, int typePCG) {
                System.err.println("display chargement societe panel");
                PanelFrame frameChargement = new PanelFrame(new ChargementCreationSocietePanel(id, typePCG), "Cr\u00e9ation d'une soci\u00e9t\u00e9");
                frameChargement.setVisible(true);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.disableEdition();
                }
            }

            public void disableEdition() {
                this.combo.setVisible(false);
                this.labelPlan.setVisible(false);
                this.eltExercice.setEditable(false);
                this.sepPlan.setVisible(false);
            }
        };
    }
}

