/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.action.NouvelleConnexionAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.panel.PostgreSQLFrame;
import org.openconcerto.erp.panel.UserExitConf;
import org.openconcerto.erp.panel.UserExitPanel;
import org.openconcerto.erp.preferences.UIPreferencePanel;
import org.openconcerto.erp.rights.ComptaTotalUserRight;
import org.openconcerto.ftp.updater.UpdateManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.RemoteShell;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.ui.SoftwareInfoPanel;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.component.WaitIndeterminatePanel;
import org.openconcerto.ui.preferences.EmailProps;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.protocol.Helper;

public class Gestion {
    public static final File MODULES_DIR = new File("Modules");
    public static final String MINIMAL_PROP = "org.openconcerto.erp.minimal";
    private static List<Image> frameIcon;
    static final boolean MAC_OS_X;
    private static final PermissionCollection ALL_PERMS;
    public static PostgreSQLFrame pgFrameStart;
    private static JDialog frameExit;

    static {
        MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        AllPermission allPermission = new AllPermission();
        ALL_PERMS = allPermission.newPermissionCollection();
        ALL_PERMS.add(allPermission);
        ALL_PERMS.setReadOnly();
        pgFrameStart = null;
        frameExit = null;
    }

    static boolean inWebStart() {
        try {
            String[] names = (String[])Class.forName("javax.jnlp.ServiceManager").getMethod("getServiceNames", new Class[0]).invoke(null, new Object[0]);
            return names != null && names.length > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void openPDF(File f) {
        try {
            FileUtils.openFile(f);
        }
        catch (IOException e) {
            ExceptionHandler.handle("Impossible d'ouvrir le fichier " + f + ".\nV\u00e9rifiez qu'un logiciel pour lire les fichiers PDF est install\u00e9 sur votre ordinateur (http://get.adobe.com/fr/reader).");
        }
    }

    public static final boolean isMinimalMode() {
        return Boolean.getBoolean(MINIMAL_PROP);
    }

    private static void initSecurity() {
        String[] extDirs = System.getProperty("java.ext.dirs").split(File.pathSeparator);
        final ArrayList<String> canonExtDirs = new ArrayList<String>(extDirs.length);
        String[] stringArray = extDirs;
        int n = extDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String extDir = stringArray[n2];
            try {
                canonExtDirs.add(new File(extDir).getCanonicalPath());
            }
            catch (IOException e) {
                System.err.println("Couldn't add extension dir : " + extDir);
                e.printStackTrace();
            }
            ++n2;
        }
        final ClassLoader mainLoader = Gestion.class.getClassLoader();
        Policy.setPolicy(new Policy(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean isExt(ProtectionDomain domain) {
                URL location = domain.getCodeSource().getLocation();
                if (!"file".equals(location.getProtocol())) return false;
                try {
                    String canonExtDir;
                    String canonPath = new File(location.toURI()).getCanonicalPath();
                    Iterator iterator = canonExtDirs.iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return false;
                    } while (!canonPath.startsWith(canonExtDir = (String)iterator.next()));
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain domain) {
                if (domain != null && (domain.getClassLoader() == mainLoader || this.isExt(domain))) {
                    return ALL_PERMS;
                }
                return super.getPermissions(domain);
            }

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                if (domain != null && domain.getClassLoader() == mainLoader) {
                    return true;
                }
                return super.implies(domain, permission);
            }
        });
        System.setSecurityManager(new SecurityManager());
    }

    public static void main(String[] args) {
        File f;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ExceptionHandler.handle("UncaughtException on thread " + t, e);
            }
        });
        System.out.println(String.valueOf(System.getProperty("java.vendor", "??")) + " - " + System.getProperty("java.version", "??"));
        System.out.println(String.valueOf(System.getProperty("java.runtime.version", "??")) + " - " + System.getProperty("os.name", "??"));
        ExceptionHandler.setForceUI(true);
        ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
        ExceptionHandler.setSoftwareInformations(SoftwareInfoPanel.FACTORY);
        System.setProperty("redirectToFile", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("sun.java2d.pmoffscreen", "false");
        System.setProperty("org.openconcerto.editpanel.noborder", "true");
        System.setProperty("org.openconcerto.sql.editPanel.endAdd", "true");
        System.setProperty("org.openconcerto.sql.listPanel.deafEditPanel", "true");
        System.setProperty("org.openconcerto.ui.addComboButton", "true");
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        System.setProperty("org.openconcerto.sql.requiredSuffix", "");
        System.setProperty("org.openconcerto.sql.comboCanModify", "true");
        System.setProperty("org.openconcerto.ui.removeSwapSearchCheckBox", "true");
        if (System.getProperty("org.openconcerto.oo.useODSViewer") == null) {
            System.setProperty("org.openconcerto.oo.useODSViewer", "true");
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("org.openconcerto.ui.simpleTraversal", "true");
        RemoteShell.startDefaultInstance();
        ComboSQLRequest.setDefaultItemsOrder(CompareUtils.naturalOrder());
        SplashScreen.getSplashScreen();
        long t1 = System.currentTimeMillis();
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
        if (conf == null) {
            ServerFinderPanel.main(new String[0]);
            return;
        }
        if (Gestion.inWebStart()) {
            Helper.setURLStreamHandlerFactory();
            System.setSecurityManager(null);
        }
        Configuration.setInstance(conf);
        final boolean logRequests = Boolean.valueOf(conf.getProperty("logRequests", "false"));
        if (logRequests) {
            SQLRequestLog.setEnabled(true);
        }
        if (Boolean.valueOf(conf.getProperty("minimal", "false")).booleanValue()) {
            System.setProperty(MINIMAL_PROP, Boolean.TRUE.toString());
        }
        if (Boolean.valueOf(conf.getProperty("statelessTable", "false")).booleanValue()) {
            System.setProperty("org.openconcerto.sql.list.statelessTable", Boolean.TRUE.toString());
        }
        System.setProperty("org.openconcerto.oo.useODSViewer", Boolean.TRUE.toString());
        if (conf.getProperty("odsViewer") != null) {
            System.setProperty("org.openconcerto.oo.useODSViewer", Boolean.valueOf(conf.getProperty("odsViewer")).toString());
        }
        UIPreferencePanel.initUIFromPreferences();
        UpdateManager.start();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        ComboSQLRequest.setDefaultFieldSeparator(" ");
        UserRightsManager.DEFAULT_MACRO_RIGHTS.add(new ComptaTotalUserRight());
        long t4 = System.currentTimeMillis();
        System.out.println("Ip:" + conf.getServerIp());
        if (conf.getServerIp().startsWith("127.0.0.1:6543") && !(f = new File("PostgreSQL/data/postmaster.pid")).exists()) {
            Gestion.startDB(conf);
        }
        try {
            conf.getSystemRoot();
            conf.getRoot().getTables().iterator().next().getUndefinedID();
        }
        catch (Exception e) {
            SQLException sqlExn;
            String msg;
            System.out.println("Init phase 1 error:" + (System.currentTimeMillis() - t4) + "ms");
            if (conf.getSystem() == SQLSystem.H2 && e.getCause() instanceof SQLException && (msg = (sqlExn = (SQLException)e.getCause()).getErrorCode() == 90020 ? "Base de donn\u00e9e d\u00e9j\u00e0 ouverte." : (sqlExn.getSQLState().equals("08000") ? "Impossible d'ouvrir la base de donn\u00e9e. V\u00e9rifier les permissions.\n" + conf.getServerIp() : null)) != null) {
                try {
                    e.printStackTrace();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, msg, "Erreur fatale", 0);
                        }
                    });
                }
                catch (Exception e1) {
                    ExceptionHandler.die("Erreur fatale", e1);
                }
                System.exit(1);
            }
            ExceptionHandler.die("Erreur de connexion \u00e0 la base de donn\u00e9es", e);
        }
        System.out.println("Init phase 1:" + (System.currentTimeMillis() - t1) + "ms");
        File fMail2 = new File(Configuration.getInstance().getConfDir(), "Email.properties");
        EmailProps.getInstance().setPropsFileName(fMail2.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long t1 = System.currentTimeMillis();
                IListe.setForceAlternateCellRenderer(true);
                AWTEventListener awtListener = new AWTEventListener(){

                    @Override
                    public final void eventDispatched(AWTEvent event) {
                        HierarchyEvent hevent;
                        Component changed;
                        if (!$assertionsDisabled && event == null) {
                            throw new AssertionError();
                        }
                        if (event instanceof HierarchyEvent && event.getID() == 1400 && (changed = (hevent = (HierarchyEvent)event).getChanged()) instanceof JFrame && (hevent.getChangeFlags() & 2L) != 0L && changed.isDisplayable()) {
                            JFrame frame = (JFrame)changed;
                            frame.setIconImages(Gestion.getFrameIcon());
                        }
                    }
                };
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (!$assertionsDisabled && toolkit == null) {
                    throw new AssertionError();
                }
                toolkit.addAWTEventListener(awtListener, 32768L);
                if (logRequests) {
                    SQLRequestLog.showFrame();
                }
                JFrame f = null;
                try {
                    try {
                        f = new NouvelleConnexionAction().createFrame();
                        if (f != null) {
                            f.pack();
                            f.setResizable(false);
                            f.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    Gestion.askForExit();
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Thread.dumpStack();
                        e.printStackTrace();
                        ExceptionHandler.handle("Erreur lors de la tentative de connexion \u00e0 la base.", e);
                        if (f != null) {
                            FrameUtil.show(f);
                        }
                        System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                    }
                }
                finally {
                    if (f != null) {
                        FrameUtil.show(f);
                    }
                    System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                }
            }
        });
        System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
        try {
            ModuleManager.getInstance().addFactories(MODULES_DIR);
        }
        catch (Throwable e) {
            ExceptionHandler.handle("Erreur d'acc\u00e8s aux modules", e);
        }
    }

    private static void startDB(PropsConfiguration conf) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Lancement de la base de donn\u00e9es");
        PostgreSQLFrame pgFrame = null;
        try {
            pgFrame = new PostgreSQLFrame("D\u00e9marrage en cours");
            pgFrame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("start DB");
        WaitIndeterminatePanel panel = new WaitIndeterminatePanel(l);
        PanelFrame f = new PanelFrame(panel, "Gestion NX");
        f.setResizable(false);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        String serverAdr = conf.getProperty("server.ip");
        if (serverAdr.startsWith("127.0.0.1") || serverAdr.startsWith("localhost")) {
            Runtime runtime = Runtime.getRuntime();
            try {
                File file = new File(".\\PostgreSQL\\bin\\");
                if (!file.canWrite()) {
                    ExceptionHandler.die("Vous n'avez pas le droit en \u00e9criture sur la base de donn\u00e9es.\nImpossible de lancer le logiciel!");
                }
                final Process p = runtime.exec(new String[]{"cmd.exe", "/C", "launchPostGres.bat"}, null, file);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                            String line = "";
                            try {
                                while ((line = reader.readLine()) != null) {
                                    System.out.println(line);
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                            String line = "";
                            try {
                                while ((line = reader.readLine()) != null) {
                                    System.err.println(line);
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            System.err.println("L'adresse du serveur n'est pas en local (" + serverAdr + ").");
        }
        panel.taskEnded(0);
        if (pgFrame != null) {
            pgFrame.dispose();
        }
        f.dispose();
        String realIp = "127.0.0.1";
        realIp = Gestion.getIp();
        try {
            pgFrameStart = new PostgreSQLFrame(String.valueOf(realIp) + " port " + "6543");
            pgFrameStart.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getIp() {
        String realIp = "127.0.0.1";
        try {
            InetAddress Ip = InetAddress.getLocalHost();
            realIp = Ip.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ip = e2.nextElement();
                    String iip = ip.toString().replace('/', ' ').trim();
                    if (!iip.startsWith("192")) continue;
                    return iip;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realIp;
    }

    public static void askForExit() {
        Gestion.askForExit(UserExitConf.DEFAULT);
    }

    public static void askForExit(UserExitConf conf) {
        JDialog exitDialog = new JDialog();
        exitDialog.setModal(true);
        if (frameExit == null) {
            frameExit = new JDialog();
            frameExit.setTitle("Quitter");
            frameExit.setModal(true);
            frameExit.setIconImages(Gestion.getFrameIcon());
            frameExit.setDefaultCloseOperation(1);
        }
        frameExit.setContentPane(new UserExitPanel(conf));
        frameExit.pack();
        frameExit.setResizable(false);
        frameExit.setLocationRelativeTo(null);
        frameExit.setAlwaysOnTop(true);
        frameExit.setVisible(true);
    }

    public static List<Image> getFrameIcon() {
        if (frameIcon == null) {
            frameIcon = new ArrayList<Image>();
            int[] sizes = new int[]{16, 32, 48, 96};
            int i = 0;
            while (i < sizes.length) {
                int v = sizes[i];
                try {
                    frameIcon.add(new ImageIcon(Gestion.class.getResource(String.valueOf(v) + ".png")).getImage());
                }
                catch (Exception e) {
                    ExceptionHandler.die("Impossible de charger l'icone de fenetre " + v + ".png");
                }
                ++i;
            }
        }
        return frameIcon;
    }
}

