/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.ParallelPort;
import gnu.io.ParallelPortEventListener;
import gnu.io.PortInUseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class LPRPort
extends ParallelPort {
    private int fd;
    private final ParallelOutputStream out = new ParallelOutputStream();
    private final ParallelInputStream in = new ParallelInputStream();
    private int lprmode = 0;
    private int timeout = 0;
    private int threshold = 1;
    private ParallelPortEventListener PPEventListener;
    private MonitorThread monThread;

    private static native void Initialize();

    public LPRPort(String string) throws PortInUseException {
        this.fd = this.open(string);
        this.name = string;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private native void nativeClose();

    public synchronized void close() {
        if (this.fd < 0) {
            return;
        }
        this.nativeClose();
        super.close();
        this.removeEventListener();
        this.fd = 0;
        Runtime.getRuntime().gc();
    }

    protected native void writeByte(int var1) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public synchronized void removeEventListener() {
        this.PPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
    }

    static {
        System.loadLibrary("rxtxParallel");
        LPRPort.Initialize();
    }

    class MonitorThread
    extends Thread {
        private final /* synthetic */ LPRPort this$0;

        public void run() {
            this.this$0.eventLoop();
            MonitorThread.yield();
        }
    }

    class ParallelInputStream
    extends InputStream {
        ParallelInputStream() {
        }

        public int read() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readByte();
        }

        public int read(byte[] byArray) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readArray(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.readArray(byArray, n, n2);
        }

        public int available() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            return LPRPort.this.nativeavailable();
        }
    }

    class ParallelOutputStream
    extends OutputStream {
        ParallelOutputStream() {
        }

        public synchronized void write(int n) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeByte(n);
        }

        public synchronized void write(byte[] byArray) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeArray(byArray, 0, byArray.length);
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
            LPRPort.this.writeArray(byArray, n, n2);
        }

        public synchronized void flush() throws IOException {
            if (LPRPort.this.fd == 0) {
                throw new IOException();
            }
        }
    }
}

