/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openconcerto.utils.CompareUtils;

public class ValidState {
    private static final ValidState TRUE = new ValidState(true, null);
    private static final ValidState FALSE = new ValidState(false, null);
    private static final Map<String, ValidState> cache = new LinkedHashMap<String, ValidState>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ValidState> eldest) {
            return this.size() > 50;
        }
    };
    private final boolean valid;
    private final String reason;

    public static final ValidState getTrueInstance() {
        return TRUE;
    }

    public ValidState(boolean valid, String invalidityReason) {
        this.valid = valid;
        this.reason = valid ? null : invalidityReason;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getValidationText() {
        return this.reason;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.valid ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidState other = (ValidState)obj;
        return this.valid == other.valid && CompareUtils.equals(this.reason, other.reason);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.isValid() ? " valid" : " not valid : '" + this.getValidationText() + "'");
    }
}

