/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.Tuple2;

public class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset ISO8859_15 = Charset.forName("ISO-8859-15");
    public static final Charset Cp1252 = Charset.forName("Cp1252");
    public static final Charset Cp850 = Charset.forName("Cp850");
    private static final Pattern quotePatrn = Pattern.compile("\"", 16);
    private static final Pattern slashPatrn = Pattern.compile("(\\\\+)");

    public static String firstUp(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static int firstIndexOf(String s, int offset, char[] chars) {
        int res = -1;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int index = s.indexOf(c, offset);
            if (index >= 0 && (res == -1 || index < res)) {
                res = index;
            }
            ++n2;
        }
        return res;
    }

    public static String doubleQuote(String s) {
        if (s.length() > 0) {
            s = slashPatrn.matcher(s).replaceAll("$1$1");
            s = quotePatrn.matcher(s).replaceAll("\\\\\"");
        }
        return String.valueOf('\"') + s + '\"';
    }

    public static String unDoubleQuote(String s) {
        Tuple2<String, Integer> res = StringUtils.unDoubleQuote(s, 0);
        if (res.get1().intValue() != s.length()) {
            throw new IllegalArgumentException("Extra content at the end : " + s.substring(res.get1()));
        }
        return res.get0();
    }

    public static Tuple2<String, Integer> unDoubleQuote(String s, int offset) {
        if (s.charAt(offset) != '\"') {
            throw new IllegalArgumentException("Expected quote but got : " + s.charAt(offset));
        }
        int l = s.length();
        if (offset + 1 < l && s.charAt(offset + 1) == '\"') {
            return Tuple2.create("", offset + 2);
        }
        ++offset;
        char[] chars = new char[]{'\"', '\\'};
        StringBuilder sb = new StringBuilder(512);
        boolean foundEnd = false;
        while (offset < l && !foundEnd) {
            int index = StringUtils.firstIndexOf(s, offset, chars);
            if (index < 0) {
                throw new IllegalArgumentException("End quote not found after " + offset);
            }
            sb.append(s.substring(offset, index));
            if (s.charAt(index) == '\"') {
                offset = index + 1;
                foundEnd = true;
                continue;
            }
            assert (s.charAt(index) == '\\');
            sb.append(s.charAt(index + 1));
            offset = index + 2;
        }
        if (!foundEnd) {
            throw new IllegalArgumentException("End quote not found after " + offset);
        }
        return Tuple2.create(sb.toString(), offset);
    }

    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char esc, char name) {
            this.esc = esc;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(esc, name);
        }

        public Escaper add(char toRemove, char escapedName) {
            if (this.inv.containsKey(Character.valueOf(escapedName))) {
                throw new IllegalArgumentException(String.valueOf(escapedName) + " already replaces " + this.inv.get(Character.valueOf(escapedName)));
            }
            this.substitution.put(Character.valueOf(toRemove), Character.valueOf(escapedName));
            this.inv.put(Character.valueOf(escapedName), Character.valueOf(toRemove));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> res = new HashSet<Character>(this.substitution.keySet());
            res.remove(Character.valueOf(this.esc));
            return res;
        }

        public final String escape(String s) {
            String res = s;
            for (Character toEsc : this.substitution.keySet()) {
                res = res.replace("" + toEsc, this.getEscaped(toEsc));
            }
            return res;
        }

        private String getEscaped(Character toEsc) {
            return String.valueOf(this.esc) + this.substitution.get(toEsc);
        }

        public final String unescape(String escaped) {
            String res = escaped;
            ArrayList<Character> toEscs = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(toEscs);
            for (Character toEsc : toEscs) {
                res = res.replaceAll(this.getEscaped(toEsc), "" + toEsc);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Escaper) {
                Escaper o = (Escaper)obj;
                return this.esc == o.esc && this.substitution.equals(o.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + this.substitution.hashCode();
        }
    }
}

