/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.util.Properties;
import org.openconcerto.utils.PropertiesUtils;

public class ProductInfo {
    private static ProductInfo INSTANCE;
    private final Properties props;

    public static final synchronized ProductInfo getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = ProductInfo.createDefault();
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load default product properties", e);
            }
        }
        return INSTANCE;
    }

    public static final ProductInfo createDefault() throws IOException {
        Properties p = PropertiesUtils.createFromResource(ProductInfo.class, "/product.properties");
        return p == null ? null : new ProductInfo(p);
    }

    public ProductInfo(Properties props) {
        if (props == null) {
            throw new NullPointerException("Null properties");
        }
        if (props.getProperty("NAME") == null) {
            throw new IllegalArgumentException("Missing NAME");
        }
        this.props = props;
    }

    private final Properties getProps() {
        return this.props;
    }

    public final String getProperty(String name) {
        return this.getProps().getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.getProps().getProperty(name, def);
    }

    public final String getName() {
        return this.getProperty("NAME", "unnamed product");
    }

    public final String getVersion() {
        return this.getProperty("VERSION");
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getName() + " " + this.getVersion();
    }
}

