/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ProcessStreams {
    private final ExecutorService exec = Executors.newFixedThreadPool(2);
    private final CountDownLatch latch = new CountDownLatch(2);
    private final Future<?> out;
    private final Future<?> err;

    public static final Process handle(Process p, Action action) throws IOException {
        if (action == Action.CLOSE) {
            p.getInputStream().close();
            p.getErrorStream().close();
        } else if (action == Action.REDIRECT) {
            new ProcessStreams(p);
        }
        return p;
    }

    public ProcessStreams(Process p) {
        this.out = this.writeToAsync(p.getInputStream(), System.out);
        this.err = this.writeToAsync(p.getErrorStream(), System.err);
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ProcessStreams.this.latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        ProcessStreams.this.exec.shutdown();
                    }
                }
                finally {
                    ProcessStreams.this.exec.shutdown();
                }
            }
        });
    }

    private final Future<?> writeToAsync(final InputStream ins, final PrintStream outs) {
        return this.exec.submit(new Callable<Object>(){

            @Override
            public Object call() throws InterruptedException, IOException {
                try {
                    ProcessStreams.writeTo(ins, outs);
                    return null;
                }
                finally {
                    ProcessStreams.this.latch.countDown();
                }
            }
        });
    }

    public static final void writeTo(InputStream ins, PrintStream outs) throws InterruptedException, IOException {
        String encodedName;
        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
        while ((encodedName = r.readLine()) != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            outs.println(encodedName);
        }
    }

    public static enum Action {
        REDIRECT,
        CLOSE,
        DO_NOTHING;

    }
}

