/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.i18n.TM;

public class JImage
extends JComponent {
    private Image image;
    private ImageIcon icon;
    private boolean centered;
    private String hyperlink;

    public JImage(ImageIcon img) {
        this(img.getImage());
        this.icon = img;
    }

    public JImage(Image img) {
        this.image = img;
        this.icon = null;
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JImage.this.hyperlink != null) {
                    try {
                        URI uri = new URI(JImage.this.hyperlink);
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle(e.getComponent(), TM.tr("linkOpenError", JImage.this.hyperlink), ex);
                    }
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JImage.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JImage.this.setCursor(new Cursor(0));
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        int dx;
        int dy;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (!this.centered) {
            dy = 0;
            dx = 0;
        } else {
            dx = (this.getWidth() - this.image.getWidth(null)) / 2;
            dy = (this.getHeight() - this.image.getHeight(null)) / 2;
        }
        g.drawImage(this.image, dx, dy, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }
}

