/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.SystemInfo;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.io.PercentEncoder;

public class ExceptionHandler
extends RuntimeException {
    private static final Pattern NL_PATTERN = Pattern.compile("\r?\n");
    private static String ForumURL = null;
    private static IFactory<String> SOFTWARE_INFOS = null;
    private final Component comp;
    private final Future<?> future;
    private static boolean forceUI;

    public static void setForumURL(String url) {
        ForumURL = url;
    }

    public static synchronized String computeSoftwareInformations() {
        if (SOFTWARE_INFOS == null) {
            return "";
        }
        return SOFTWARE_INFOS.createChecked();
    }

    private static void copyToClipboard(String s) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(s);
        clipboard.setContents(data, data);
    }

    public static ExceptionHandler handle(Component comp, String msg, Throwable originalExn) {
        return new ExceptionHandler(comp, msg, originalExn, false);
    }

    public static RuntimeException handle(String msg, Throwable originalExn) {
        return ExceptionHandler.handle(null, msg, originalExn);
    }

    public static RuntimeException handle(String msg) {
        return ExceptionHandler.handle(msg, null);
    }

    public static RuntimeException die(String msg, Throwable originalExn) {
        return new ExceptionHandler(null, msg, originalExn);
    }

    public static RuntimeException die(String msg) {
        return ExceptionHandler.die(msg, null);
    }

    private static Logger getLogger() {
        return Logger.getLogger("global");
    }

    public static void setForceUI(boolean forceUI) {
        ExceptionHandler.forceUI = forceUI;
    }

    private Future<?> display(final boolean error) {
        final String msg = this.getMessage();
        ExceptionHandler.getLogger().log(error ? Level.SEVERE : Level.INFO, null, this);
        if (!GraphicsEnvironment.isHeadless() || forceUI) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showMsgHardened(msg, error);
            } else {
                FutureTask<Object> run = new FutureTask<Object>(new Runnable(){

                    @Override
                    public void run() {
                        ExceptionHandler.this.showMsgHardened(msg, error);
                    }
                }, null);
                if (error) {
                    try {
                        SwingUtilities.invokeAndWait(run);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                } else {
                    SwingUtilities.invokeLater(run);
                }
                return run;
            }
        }
        return null;
    }

    protected final void showMsgHardened(String msg, boolean error) {
        try {
            this.showMsg(msg, error);
        }
        catch (Throwable e2) {
            Exception e2 = new Exception("Couldn't display message", e2);
            e2.printStackTrace();
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(e2.getMessage()) + " : " + msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected final void showMsg(String msg, final boolean quit) {
        boolean browseSupported;
        final JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        JImage im = new JImage(new ImageIcon(ExceptionHandler.class.getResource("error.png")));
        JLabel l = new JLabel("Une erreur est survenue");
        l.setFont(l.getFont().deriveFont(1));
        final JTextArea textArea = new JTextArea();
        textArea.setFont(textArea.getFont().deriveFont(11.0f));
        c.gridheight = 3;
        p.add((Component)im, c);
        c.insets = new Insets(2, 4, 2, 4);
        c.gridheight = 1;
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        p.add((Component)l, c);
        ++c.gridy;
        JLabel lError = new JLabel("<html>" + NL_PATTERN.matcher(msg).replaceAll("<br>") + "</html>");
        p.add((Component)lError, c);
        ++c.gridy;
        p.add((Component)new JLabel("Il s'agit probablement d'une mauvaise configuration ou installation du logiciel."), c);
        c.gridx = 0;
        c.gridwidth = 4;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 1;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        boolean bl = browseSupported = desktop != null && desktop.isSupported(Desktop.Action.BROWSE);
        if (ForumURL != null) {
            AbstractAction communityAction = browseSupported ? new AbstractAction("Consulter le forum"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (desktop != null) {
                        try {
                            desktop.browse(new URI(ForumURL));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            } : new AbstractAction("Copier l'adresse du forum"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionHandler.copyToClipboard(ForumURL);
                }
            };
            p.add((Component)new JButton(communityAction), c);
        }
        c.weightx = 0.0;
        ++c.gridx;
        AbstractAction supportAction = browseSupported ? new AbstractAction("Contacter l'assistance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (desktop != null) {
                    try {
                        desktop.browse(URI.create("http://www.ilm-informatique.fr/contact"));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        } : new AbstractAction("Copier l'adresse de l'assistance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionHandler.copyToClipboard("http://www.ilm-informatique.fr/contact");
            }
        };
        p.add((Component)new JButton(supportAction), c);
        ++c.gridx;
        AbstractAction submitAction = new AbstractAction("Soumettre l'erreur"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.submitError(p, textArea);
            }

            private void submitError(JPanel p2, JTextComponent textArea2) {
                Charset cs = StringUtils.UTF8;
                try {
                    String line;
                    ProductInfo productInfo = ProductInfo.getInstance();
                    String name = "";
                    String version = "";
                    if (productInfo != null) {
                        name = productInfo.getName();
                        version = productInfo.getProperty("VERSION", version);
                    }
                    Map<SystemInfo.Info, String> systemInfos = SystemInfo.get(false);
                    String os = systemInfos.remove((Object)SystemInfo.Info.OS);
                    String java = systemInfos.toString();
                    String encodedData = "java=" + PercentEncoder.encode(java, cs) + "&os=" + PercentEncoder.encode(os, cs) + "&software=" + PercentEncoder.encode(String.valueOf(name) + version, cs) + "&stack=" + PercentEncoder.encode(String.valueOf(ExceptionHandler.computeSoftwareInformations()) + "\n\n" + textArea2.getText(), cs);
                    String request = "http://bugreport.ilm-informatique.fr:5000/bugreport";
                    URL url = new URL("http://bugreport.ilm-informatique.fr:5000/bugreport");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setRequestProperty("charset", cs.name());
                    byte[] bytes = encodedData.getBytes(cs);
                    connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
                    OutputStream outputStream = connection.getOutputStream();
                    outputStream.write(bytes);
                    outputStream.flush();
                    StringBuffer answer = new StringBuffer();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        answer.append(line);
                    }
                    outputStream.close();
                    reader.close();
                    connection.disconnect();
                    JOptionPane.showMessageDialog(p2, "Merci d'avoir envoy\u00e9 le rapport d'erreur au service technique.\nIl sera analys\u00e9 prochainement.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        p.add((Component)new JButton(submitAction), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)new JSeparator(), c);
        c.gridx = 0;
        c.gridwidth = 3;
        ++c.gridy;
        c.insets = new Insets(2, 4, 2, 4);
        p.add((Component)new JLabel("D\u00e9tails de l'erreur:"), c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        String message = this.getCause() == null ? null : this.getCause().getMessage();
        message = message == null ? msg : String.valueOf(msg) + "\n\n" + message;
        message = String.valueOf(message) + "\n";
        message = String.valueOf(message) + this.getTrace();
        textArea.setText(message);
        textArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.getViewport().setMinimumSize(new Dimension(200, 300));
        c.weighty = 1.0;
        c.gridwidth = 4;
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)scroll, c);
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 4, 2, 4);
        JButton buttonClose = new JButton("Fermer");
        p.add((Component)buttonClose, c);
        Window window = this.comp == null ? null : SwingUtilities.getWindowAncestor(this.comp);
        final JDialog f = window instanceof Frame ? new JDialog((Frame)window, "Erreur", true) : new JDialog((Dialog)window, "Erreur", true);
        f.setContentPane(p);
        f.pack();
        f.setSize(580, 680);
        f.setMinimumSize(new Dimension(380, 380));
        f.setLocationRelativeTo(this.comp);
        final ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (quit) {
                    System.exit(1);
                } else {
                    f.dispose();
                }
            }
        };
        buttonClose.addActionListener(al);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                al.actionPerformed(null);
            }
        });
        f.setVisible(true);
    }

    private String getTrace() {
        return ExceptionUtils.getStackTrace(this);
    }

    private ExceptionHandler(Component comp, String msg, Throwable cause) {
        this(comp, msg, cause, true);
    }

    private ExceptionHandler(Component comp, String msg, Throwable cause, boolean quit) {
        super(msg, cause);
        this.comp = comp;
        this.future = this.display(quit);
    }
}

