/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.cc.IdentitySet;
import org.openconcerto.utils.cc.Transformer;

public class CollectionUtils {
    private static final Pattern COMMA = Pattern.compile("\\p{Space}*,\\p{Space}*");
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private static final IdentitySet EMPTY_SET = new EmptyIdentitySet();

    public static final <E> String join(Collection<E> c, String sep, ITransformer<? super E, ?> tf) {
        int size = c.size();
        if (size == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer(size * 4);
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int i = 0;
            while (i < size) {
                res.append(tf.transformChecked(list.get(i)));
                if (i < size - 1) {
                    res.append(sep);
                }
                ++i;
            }
        } else {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                E elem = iter.next();
                res.append(tf.transformChecked(elem));
                if (!iter.hasNext()) continue;
                res.append(sep);
            }
        }
        return res.toString();
    }

    public static <T> String join(Collection<T> c, String sep) {
        return CollectionUtils.join(c, sep, Transformer.nopTransformer());
    }

    public static int getValidIndex(List<?> l, int i) {
        return CollectionUtils.getValidIndex(l, i, false);
    }

    public static int getValidIndex(List<?> l, int i, boolean strict) {
        int size = l.size();
        if (i > size) {
            if (strict) {
                throw new IndexOutOfBoundsException("Too high : " + i + " > " + size);
            }
            return size;
        }
        if (i < -size) {
            if (strict) {
                throw new IndexOutOfBoundsException("Too low : " + i + " < " + -size);
            }
            return 0;
        }
        if (i >= 0) {
            return i;
        }
        return size + i;
    }

    public static <K, V> Tuple2<List<K>, List<V>> mapToLists(Map<K, V> map) {
        ArrayList<K> keys = new ArrayList<K>(map.size());
        ArrayList<V> vals = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keys.add(e.getKey());
            vals.add(e.getValue());
        }
        return Tuple2.create(keys, vals);
    }

    public static <K, V> Map<K, V> addIfNotPresent(Map<K, V> map, Map<? extends K, ? extends V> toAdd) {
        for (Map.Entry<K, V> e : toAdd.entrySet()) {
            if (map.containsKey(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <T> Set<T> contains(Set<T> col1, Set<T> col2) {
        if (col1.containsAll(col2)) {
            return null;
        }
        HashSet<T> names = new HashSet<T>(col2);
        names.removeAll(col1);
        return names;
    }

    public static <C extends Collection<?>> boolean containsAny(C coll1, C coll2) {
        return org.apache.commons.collections.CollectionUtils.containsAny(coll1, coll2);
    }

    public static <T> Collection<T> intersection(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections.CollectionUtils.intersection(a, b);
    }

    public static <T> Set<T> inter(Set<T> a, Set<T> b) {
        return CollectionUtils.interSubtype(a, b);
    }

    public static <T> Set<? extends T> interSubtype(Set<? extends T> a, Set<? extends T> b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.size() > b.size()) {
            return CollectionUtils.interSubtype(b, a);
        }
        HashSet<T> res = new HashSet<T>();
        for (T item : a) {
            if (!b.contains(item)) continue;
            res.add(item);
        }
        return res;
    }

    public static <T> Set<T> union(Set<? extends T> a, Set<? extends T> b) {
        HashSet<T> res = new HashSet<T>(a);
        if (a != b) {
            res.addAll(b);
        }
        return res;
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> Collection<T> substract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> T getSole(List<T> l) {
        return l.size() == 1 ? (T)l.get(0) : null;
    }

    public static <T> T getSole(Collection<T> l) {
        return l.size() == 1 ? (T)l.iterator().next() : null;
    }

    public static <T> T getFirst(List<T> l) {
        return CollectionUtils.getNoExn(l, 0);
    }

    public static <T> T getLast(List<T> l) {
        return CollectionUtils.getNoExn(l, l.size() - 1);
    }

    public static <T> T getNoExn(List<T> l, int index) {
        return index >= 0 && index < l.size() ? (T)l.get(index) : null;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> getListIterator(List<T> l, boolean reversed) {
        if (!reversed) {
            return l.listIterator();
        }
        return CollectionUtils.reverseListIterator(l.listIterator(l.size()));
    }

    public static <T> ListIterator<T> reverseListIterator(ListIterator<T> listIter) {
        if (listIter instanceof ReverseListIter) {
            return ((ReverseListIter)listIter).listIter;
        }
        return new ReverseListIter(listIter);
    }

    public static <T> Set<T> createSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> IdentitySet<T> createIdentitySet(T ... items) {
        return new IdentityHashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> toIdentitySet(Collection<T> items) {
        if (items instanceof IdentitySet) {
            return (Set)items;
        }
        return new IdentityHashSet<T>(items);
    }

    public static <K, V> Map<K, V> createMap(Collection<? extends K> keys) {
        return CollectionUtils.fillMap(keys instanceof List ? new LinkedHashMap(keys.size()) : new HashMap(keys.size()), keys);
    }

    public static <K, V, M extends Map<K, V>> M fillMap(M m, Collection<? extends K> keys) {
        return CollectionUtils.fillMap(m, keys, null);
    }

    public static <K, V, M extends Map<K, V>> M fillMap(M m, Collection<? extends K> keys, V val) {
        for (K key : keys) {
            m.put(key, val);
        }
        return m;
    }

    private static final class EmptyIdentitySet
    extends AbstractSet<Object>
    implements Serializable,
    IdentitySet<Object> {
        private EmptyIdentitySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return CollectionUtils.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }
    }

    private static final class ReverseListIter<T>
    implements ListIterator<T> {
        private final ListIterator<T> listIter;

        private ReverseListIter(ListIterator<T> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasPrevious();
        }

        @Override
        public T next() {
            return this.listIter.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.listIter.hasNext();
        }

        @Override
        public T previous() {
            return this.listIter.next();
        }

        @Override
        public int nextIndex() {
            return this.listIter.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.listIter.nextIndex();
        }

        @Override
        public void remove() {
            this.listIter.remove();
        }

        @Override
        public void set(T e) {
            this.listIter.set(e);
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

