/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import com.jcraft.jsch.Session;
import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.users.CompanyAccessSQLElement;
import org.openconcerto.sql.users.UserCommonSQLElement;
import org.openconcerto.sql.users.rights.RightSQLElement;
import org.openconcerto.sql.users.rights.UserRightSQLElement;
import org.openconcerto.task.element.TaskRightSQLElement;
import org.openconcerto.task.element.TaskSQLElement;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.ProductInfo;

public abstract class ComptaBasePropsConfiguration
extends PropsConfiguration {
    private int idSociete = -1;
    private SQLRow rowSociete = null;
    private DBRoot baseSociete;
    private Thread sslThread = null;

    public static File getConfFile(String appName) {
        return ComptaBasePropsConfiguration.getConfFile(appName, new File("."));
    }

    public static File getConfFile(String appName, File wd) {
        String confFilePath = System.getProperty("gestion.confFile");
        File wdFile = new File(wd + "/Configuration", "main.properties");
        File confFile = confFilePath != null ? new File(confFilePath) : (wdFile.isFile() ? wdFile : new File(DesktopEnvironment.getDE().getPreferencesFolder(appName), "main.properties"));
        return confFile;
    }

    public ComptaBasePropsConfiguration(Properties props, ProductInfo productInfo) {
        super(props);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        this.setLoggersLevel();
        this.setProductInfo(productInfo);
        String name = "ilm";
        if (this.getProperty("systemRoot.rootsToMap") == null) {
            this.setProperty("systemRoot.rootsToMap", String.valueOf(name) + "_Common");
            this.setProperty("systemRoot.rootPath", String.valueOf(name) + "_Common");
        }
    }

    @Override
    protected void afterSSLConnect(final Session conn) {
        if (conn.isConnected()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        do {
                            Thread.sleep(1000L);
                        } while (conn.isConnected());
                        ExceptionHandler.die("Liaison s\u00e9curis\u00e9e d\u00e9connect\u00e9e!\nV\u00e9rifiez votre connexion internet et relancez le logiciel.");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.setDaemon(true);
            t.setName("SSL connection watcher");
            t.start();
            assert (this.sslThread == null);
            this.sslThread = t;
        } else {
            ExceptionHandler.die("Impossible d'\u00e9tablir la liaison s\u00e9curis\u00e9e!\nV\u00e9rifiez votre connexion internet et relancez le logiciel.");
        }
    }

    @Override
    public void destroy() {
        if (this.sslThread != null) {
            this.sslThread.interrupt();
            this.sslThread = null;
        }
        super.destroy();
    }

    @Override
    protected PropsConfiguration.FileMode getFileMode() {
        return PropsConfiguration.FileMode.NORMAL_FILE;
    }

    @Override
    protected SQLElementDirectory createDirectory() {
        SQLElementDirectory dir = super.createDirectory();
        dir.addSQLElement(new ConfSQLElement("SOCIETE_COMMON", "une soci\u00e9t\u00e9", "soci\u00e9t\u00e9s"));
        dir.addSQLElement(new ConfSQLElement("EXERCICE_COMMON", "un exercice", "exercices"));
        dir.addSQLElement(new ConfSQLElement("ADRESSE_COMMON", "une adresse", "adresses"));
        dir.addSQLElement(new TaskRightSQLElement());
        dir.addSQLElement(new TaskSQLElement());
        dir.addSQLElement(new UserCommonSQLElement());
        dir.addSQLElement(new CompanyAccessSQLElement());
        dir.addSQLElement(UserRightSQLElement.class);
        dir.addSQLElement(RightSQLElement.class);
        return dir;
    }

    public final String getSocieteBaseName() {
        return this.getRowSociete().getString("DATABASE_NAME");
    }

    public final SQLRow getRowSociete() {
        return this.rowSociete;
    }

    public final int getSocieteID() {
        return this.idSociete;
    }

    protected final void setRowSociete(int id) {
        this.idSociete = id;
        this.rowSociete = this.getSystemRoot().findTable("SOCIETE_COMMON").getValidRow(this.getSocieteID());
    }

    public final DBRoot getRootSociete() {
        if (this.baseSociete == null && this.rowSociete != null) {
            this.baseSociete = this.createSQLBaseSociete();
        }
        return this.baseSociete;
    }

    private DBRoot createSQLBaseSociete() {
        DBSystemRoot b = this.getSystemRoot();
        String societeBaseName = this.getSocieteBaseName();
        b.addRootToMap(societeBaseName);
        try {
            b.reload(Collections.singleton(societeBaseName));
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not access societe base", e);
        }
        b.prependToRootPath(societeBaseName);
        return b.getRoot(societeBaseName);
    }
}

