/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;

public class SQLFieldTranslator {
    public static final RowItemDesc NULL_DESC = new RowItemDesc(null, null);
    private final Map<SQLTable, Map<List<String>, RowItemDesc>> translation = new HashMap<SQLTable, Map<List<String>, RowItemDesc>>();
    private final SQLTable table;
    private final SQLElementDirectory dir;
    private final Set<String> unknownCodes = new HashSet<String>();

    public static SQLTable getMetaTable(DBRoot root) throws SQLException {
        if (!root.contains("FWK_RIV_METADATA")) {
            SQLCreateTable createValueT = new SQLCreateTable(root, "FWK_RIV_METADATA");
            createValueT.setPlain(true);
            createValueT.addColumn("ID", createValueT.getSyntax().getPrimaryIDDefinition());
            String nullableVarChar = "varchar(80)";
            createValueT.addColumn("ELEMENT_CODE", "varchar(80)");
            createValueT.addColumn("COMPONENT_CODE", "varchar(80)");
            createValueT.addColumn("ITEM", "varchar(80) NOT NULL");
            createValueT.addUniqueConstraint("uniq", Arrays.asList("ELEMENT_CODE", "COMPONENT_CODE", "ITEM"));
            createValueT.addVarCharColumn("LABEL", 256);
            createValueT.addVarCharColumn("COLUMN_TITLE", 256);
            createValueT.addVarCharColumn("DOCUMENTATION", 8192, true);
            root.createTable(createValueT);
        }
        return root.getTable("FWK_RIV_METADATA");
    }

    public SQLFieldTranslator(DBRoot root, InputStream inputStream, SQLElementDirectory dir) {
        try {
            this.table = SQLFieldTranslator.getMetaTable(root);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't get the meta table", e);
        }
        this.dir = dir;
        this.dir.addListener(new SQLElementDirectory.DirectoryListener(){

            @Override
            public void elementRemoved(SQLElement elem) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void elementAdded(SQLElement elem) {
                boolean isUnknown;
                SQLFieldTranslator sQLFieldTranslator = SQLFieldTranslator.this;
                synchronized (sQLFieldTranslator) {
                    isUnknown = SQLFieldTranslator.this.unknownCodes.contains(elem.getCode());
                }
                if (isUnknown) {
                    SQLFieldTranslator.this.fetch(Collections.singleton(elem.getCode()));
                }
            }
        });
        if (inputStream != null) {
            this.load(root, inputStream);
        }
        this.fetchAndPut(this.table, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(SQLFieldTranslator o) {
        SQLFieldTranslator o2;
        SQLFieldTranslator o1;
        int oHash;
        if (o == this) {
            return;
        }
        int thisHash = System.identityHashCode(this);
        if (thisHash < (oHash = System.identityHashCode(o))) {
            o1 = this;
            o2 = o;
        } else if (thisHash > oHash) {
            o1 = o;
            o2 = this;
        } else {
            throw new IllegalStateException("Hash equal");
        }
        SQLFieldTranslator sQLFieldTranslator = o1;
        synchronized (sQLFieldTranslator) {
            SQLFieldTranslator sQLFieldTranslator2 = o2;
            synchronized (sQLFieldTranslator2) {
                CollectionUtils.addIfNotPresent(this.translation, o.translation);
            }
        }
    }

    private static List<Element> getChildren(Element elem) {
        return elem.getChildren();
    }

    public void load(DBRoot b, InputStream inputStream) {
        this.load(b, "CORE", inputStream);
    }

    public Tuple2<Set<SQLTable>, Set<String>> load(DBRoot b, String variant, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        HashSet<String> notFound = new HashSet<String>();
        try {
            Document doc = new SAXBuilder().build(inputStream);
            for (Element elem : SQLFieldTranslator.getChildren(doc.getRootElement())) {
                List<Element> tableElems;
                DBRoot root;
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("table")) {
                    root = b;
                    tableElems = Collections.singletonList(elem);
                } else if (elemName.equals("root")) {
                    root = b.getDBSystemRoot().getRoot(elem.getAttributeValue("name"));
                    tableElems = SQLFieldTranslator.getChildren(elem);
                } else {
                    root = null;
                    tableElems = null;
                }
                if (tableElems == null) continue;
                for (Element tableElem : tableElems) {
                    Tuple2<String, SQLTable> t = this.load(root, variant, tableElem, true);
                    if (t.get1() == null) {
                        notFound.add(t.get0());
                        continue;
                    }
                    res.add(t.get1());
                }
            }
            assert (!res.contains(null));
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Tuple2.create(res, notFound);
    }

    private Tuple2<String, SQLTable> load(DBRoot b, String variant, Element tableElem, boolean lenient) {
        String tableName = tableElem.getAttributeValue("name");
        SQLTable table = b.getTable(tableName);
        if (table == null && this.dir != null && this.dir.getElement(tableName) != null) {
            table = this.dir.getElement(tableName).getTable();
        }
        if (table != null) {
            for (Element elem : SQLFieldTranslator.getChildren(tableElem)) {
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("field")) {
                    this.load(table, "default component code", variant, elem);
                    continue;
                }
                if (!elemName.equals("component")) continue;
                String compCode = elem.getAttributeValue("code");
                for (Element fieldElem : SQLFieldTranslator.getChildren(elem)) {
                    this.load(table, compCode, variant, fieldElem);
                }
            }
        } else if (lenient) {
            Log.get().config("Ignore loading of inexistent table " + tableName);
        } else {
            throw new IllegalStateException("Table not found : " + tableName);
        }
        return Tuple2.create(tableName, table);
    }

    private void load(SQLTable table, String compCode, String variant, Element fieldElem) {
        String name = fieldElem.getAttributeValue("name");
        String label = fieldElem.getAttributeValue("label");
        String title = fieldElem.getAttributeValue("titlelabel", label);
        String documentation = fieldElem.getText();
        this.setDescFor(table, compCode, variant, name, new RowItemDesc(label, title, documentation));
    }

    public final void fetch(Set<String> codes) {
        this.fetchAndPut(this.table, codes);
    }

    private List<SQLRow> fetchOnly(SQLTable table, Where w) {
        return SQLRowListRSH.execute(new SQLSelect().addSelectStar(table).setWhere(w));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndPut(SQLTable table, Set<String> codes) {
        Where w;
        if (codes == null) {
            w = null;
            this.removeTranslation((SQLTable)null, (String)null, "DB", (String)null);
        } else {
            w = new Where(table.getField("ELEMENT_CODE"), codes);
            for (String elementCode : codes) {
                this.removeTranslation(this.dir.getElementForCode(elementCode).getTable(), null, "DB", null);
            }
        }
        for (SQLRow r : this.fetchOnly(table, w)) {
            String elementCode = r.getString("ELEMENT_CODE");
            SQLElement elem = this.dir.getElementForCode(elementCode);
            if (elem != null) {
                String componentCode = r.getString("COMPONENT_CODE");
                String item = r.getString("ITEM");
                RowItemDesc desc = new RowItemDesc(r.getString("LABEL"), r.getString("COLUMN_TITLE"), r.getString("DOCUMENTATION"));
                SQLFieldTranslator sQLFieldTranslator = this;
                synchronized (sQLFieldTranslator) {
                    this.putTranslation(elem.getTable(), componentCode, "DB", item, desc);
                    this.unknownCodes.remove(elementCode);
                    continue;
                }
            }
            SQLFieldTranslator sQLFieldTranslator = this;
            synchronized (sQLFieldTranslator) {
                this.unknownCodes.add(elementCode);
            }
        }
    }

    private final synchronized Map<List<String>, RowItemDesc> getMap(SQLTable t) {
        Map<List<String>, RowItemDesc> elemMap = this.translation.get(t);
        if (elemMap == null) {
            elemMap = new HashMap<List<String>, RowItemDesc>();
            this.translation.put(t, elemMap);
        }
        return elemMap;
    }

    private final synchronized void putTranslation(SQLTable t, String compCode, String variant, String item, RowItemDesc desc) {
        if (t == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (compCode == null || variant == null || item == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        this.getMap(t).put(Arrays.asList(compCode, variant, item), desc);
    }

    private final synchronized void removeTranslation(SQLTable t, String compCode, String variant, String name) {
        if (t == null) {
            for (Map<List<String>, RowItemDesc> m : this.translation.values()) {
                this.removeTranslation(m, compCode, variant, name);
            }
        } else {
            this.removeTranslation(this.translation.get(t), compCode, variant, name);
        }
    }

    private synchronized void removeTranslation(Map<List<String>, RowItemDesc> m, String compCode, String variant, String name) {
        if (m == null) {
            return;
        }
        if (compCode == null && variant == null && name == null) {
            m.clear();
        } else if (compCode != null && variant != null && name != null) {
            m.remove(Arrays.asList(compCode, variant, name));
        } else {
            Iterator<List<String>> iter = m.keySet().iterator();
            while (iter.hasNext()) {
                List<String> l = iter.next();
                if (compCode != null && !compCode.equals(l.get(0)) || variant != null && !variant.equals(l.get(1)) || name != null && !name.equals(l.get(2))) continue;
                iter.remove();
            }
        }
    }

    public final void setDescFor(SQLTable table, String componentCode, String variant, String name, RowItemDesc desc) {
        if ("DB".equals(variant)) {
            throw new IllegalArgumentException("Use storeDescFor()");
        }
        this.putTranslation(table, componentCode, variant, name, desc);
    }
}

