/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;

public class Step {
    private final SQLTable from;
    private final SQLTable to;
    private final Map<Link, Link.Direction> fields;
    private final SQLField singleField;
    private Set<SQLField> singleFields;
    private boolean singleFieldsComputed;

    public static final Step create(SQLTable start, SQLField fField, Link.Direction direction) throws IllegalArgumentException {
        Link l = fField.getDBSystemRoot().getGraph().getForeignLink(fField);
        if (l == null) {
            throw new IllegalArgumentException(fField + " is not a foreign field.");
        }
        return Step.create(start, l, direction);
    }

    public static final Step create(SQLTable start, Link l, Link.Direction direction) throws IllegalArgumentException {
        Link.Direction nonNullDir;
        if (l == null) {
            throw new NullPointerException("null link");
        }
        SQLTable end = l.oppositeVertex(start);
        Link.Direction computedDirection = start == end ? Link.Direction.ANY : Link.Direction.fromForeign(l.getSource() == start);
        if (computedDirection == Link.Direction.ANY && direction == Link.Direction.ANY) {
            throw new IllegalArgumentException("self reference : " + l + ", you must specify the direction");
        }
        if (direction != Link.Direction.ANY && computedDirection != Link.Direction.ANY && direction != computedDirection) {
            throw new IllegalArgumentException("wrong direction: " + (Object)((Object)direction) + ", real is : " + (Object)((Object)computedDirection));
        }
        Link.Direction direction2 = nonNullDir = direction == Link.Direction.ANY ? computedDirection : direction;
        assert (nonNullDir != Link.Direction.ANY);
        return new Step(start, l, nonNullDir, end);
    }

    private Step(SQLTable start, Map<Link, Link.Direction> fields, SQLField singleField, SQLTable end) {
        assert (start != null && end != null);
        assert (fields.size() > 0);
        assert (!new HashSet<Link.Direction>(fields.values()).contains((Object)Link.Direction.ANY)) : "some directions are unknown : " + fields;
        assert (fields instanceof AbstractMap) : "Fields might not be thread-safe";
        this.from = start;
        this.to = end;
        this.fields = Collections.unmodifiableMap(fields);
        this.singleField = singleField;
        if (singleField == null) {
            this.singleFields = null;
            this.singleFieldsComputed = false;
        } else {
            this.singleFields = Collections.singleton(singleField);
            this.singleFieldsComputed = true;
        }
    }

    private Step(SQLTable start, Link field, Link.Direction foreign, SQLTable end) {
        this(start, Collections.singletonMap(field, foreign), field.getSingleField(), end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Step reverse() {
        HashMap<Link, Link.Direction> reverseFields = new HashMap<Link, Link.Direction>(this.fields.size());
        for (Map.Entry<Link, Link.Direction> e : this.fields.entrySet()) {
            reverseFields.put(e.getKey(), e.getValue().reverse());
        }
        Step res = new Step(this.to, reverseFields, this.singleField, this.from);
        Step step = this;
        synchronized (step) {
            res.singleFields = this.singleFields;
            res.singleFieldsComputed = this.singleFieldsComputed;
        }
        return res;
    }

    public final SQLTable getFrom() {
        return this.from;
    }

    public final SQLTable getTo() {
        return this.to;
    }

    public final Set<Link> getLinks() {
        return this.fields.keySet();
    }

    public final SQLField getSingleField() {
        return this.singleField;
    }

    public final boolean isForeign(Link f) {
        return this.getDirection(f) == Link.Direction.FOREIGN;
    }

    public final Link.Direction getDirection(Link f) {
        return this.fields.get(f);
    }

    public final Boolean isForeign() {
        Link.Direction soleDir = this.getDirection();
        return soleDir == Link.Direction.ANY ? null : Boolean.valueOf(soleDir == Link.Direction.FOREIGN);
    }

    public final Link.Direction getDirection() {
        Link.Direction soleDir = CollectionUtils.getSole(new HashSet<Link.Direction>(this.fields.values()));
        return soleDir == null ? Link.Direction.ANY : soleDir;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName());
        sb.append(" from: ");
        sb.append(this.getFrom());
        sb.append(" through: ");
        this.linksToString(sb);
        sb.append(" to: ");
        sb.append(this.getTo());
        return sb.toString();
    }

    public StringBuilder linksToString(StringBuilder sb) {
        boolean moreThan1;
        assert (this.fields.size() > 0);
        String sep = " ; ";
        boolean bl = moreThan1 = this.fields.size() > 1;
        if (moreThan1) {
            sb.append("{ ");
        }
        for (Map.Entry<Link, Link.Direction> e : this.fields.entrySet()) {
            Link.Direction dir = e.getValue();
            assert (dir != Link.Direction.ANY);
            boolean foreign = dir == Link.Direction.FOREIGN;
            sb.append(foreign ? "--" : "<--");
            sb.append(e.getKey().getCols());
            sb.append(foreign ? "-->" : "--");
            sb.append(" ; ");
        }
        sb.setLength(sb.length() - " ; ".length());
        if (moreThan1) {
            sb.append(" }");
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Step) {
            Step o = (Step)obj;
            return this.from.equals(o.from) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }
}

