/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;

abstract class AbstractPath<T extends AbstractPath<T>> {
    AbstractPath() {
    }

    public final SQLTable getFirst() {
        return this.getTable(0);
    }

    public final SQLTable getLast() {
        return this.getTable(this.getTables().size() - 1);
    }

    public final SQLTable getTable(int i) {
        return this.getTables().get(i);
    }

    public abstract List<SQLTable> getTables();

    public final int length() {
        return this.getSteps().size();
    }

    public final T append(Path p) {
        if (this.getLast() != p.getFirst()) {
            throw new IllegalArgumentException("this ends at " + this.getLast() + " while the other begins at " + p.getFirst());
        }
        return this._append(p);
    }

    protected abstract T _append(Path var1);

    abstract T add(Step var1);

    public final T add(SQLField fField, Link.Direction direction) {
        return this.add(Step.create(this.getLast(), fField, direction));
    }

    public abstract List<Step> getSteps();
}

