/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Matrix;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.cc.Closure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.cc.IdentitySet;

public class SQLRowValuesCluster {
    private static final Comparator<SQLField> FIELD_COMPARATOR = new Comparator<SQLField>(){

        @Override
        public int compare(SQLField o1, SQLField o2) {
            return o1.getSQLName().quote().compareTo(o2.getSQLName().quote());
        }
    };
    private final List<Link> links = new ArrayList<Link>();
    private final IdentitySet<SQLRowValues> items = new IdentityHashSet<SQLRowValues>();
    private Map<SQLRowValues, List<ValueChangeListener>> listeners = null;
    private boolean frozen = false;

    private SQLRowValuesCluster() {
    }

    SQLRowValuesCluster(SQLRowValues vals) {
        this();
        this.addVals(-1, vals);
    }

    private final void addVals(int index, SQLRowValues vals) {
        assert (vals.getGraph(false) == null);
        if (index < 0) {
            this.links.add(new Link(vals));
        } else {
            this.links.add(index, new Link(vals));
        }
        this.items.add(vals);
    }

    private final SQLRowValues getHead() {
        return this.links.get(0).getSrc();
    }

    private final DBSystemRoot getSystemRoot() {
        return this.getHead().getTable().getDBSystemRoot();
    }

    public final Set<SQLRowValues> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public final int size() {
        return this.items.size();
    }

    public final boolean contains(SQLRowValues start) {
        return this.items.contains(start);
    }

    private final void containsCheck(SQLRowValues vals) {
        if (!this.contains(vals)) {
            throw new IllegalArgumentException(vals + " not in " + this);
        }
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final boolean freeze() {
        if (this.frozen) {
            return false;
        }
        this.frozen = true;
        return true;
    }

    void remove(SQLRowValues src, SQLField f, SQLRowValues dest) {
        assert (dest != null);
        assert (src.getGraph() == this);
        assert (src.getTable() == f.getTable());
        assert (!this.isFrozen()) : "Should already be checked by SQLRowValues";
        Link toRm = new Link(src, f, dest);
        this.links.remove(toRm);
        IdentitySet<SQLRowValues> reachable = this.getReachable(src);
        if (reachable.size() < this.size()) {
            SQLRowValuesCluster newCluster = new SQLRowValuesCluster();
            Iterator<Link> iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = iter.next();
                assert (l.getDest() == null || reachable.contains(l.getSrc()) == reachable.contains(l.getDest()));
                if (reachable.contains(l.getSrc())) continue;
                iter.remove();
                newCluster.links.add(l);
            }
            assert (newCluster.items.isEmpty());
            Iterator itemIter = this.items.iterator();
            while (itemIter.hasNext()) {
                SQLRowValues key = (SQLRowValues)itemIter.next();
                if (reachable.contains(key)) continue;
                itemIter.remove();
                newCluster.items.add(key);
                if (this.listeners == null || !this.listeners.containsKey(key)) continue;
                newCluster.getListeners().put(key, this.listeners.remove(key));
            }
            assert (!this.items.isEmpty()) : "Empty items while removing " + f + " -> " + dest + " from " + src;
            assert (!newCluster.items.isEmpty()) : "New graph is empty while removing " + f + " -> " + dest + " from " + src;
            assert (!CollectionUtils.containsAny(this.items, newCluster.items)) : "Shared items while removing " + f + " -> " + dest + " from " + src;
            for (SQLRowValues vals : newCluster.getItems()) {
                vals.setGraph(newCluster);
            }
        }
    }

    void add(SQLRowValues src, SQLField f, SQLRowValues dest) {
        assert (dest != null);
        assert (src.getTable() == f.getTable());
        assert (!this.isFrozen()) : "Should already be checked by SQLRowValues";
        boolean containsSrc = this.contains(src);
        boolean containsDest = this.contains(dest);
        if (!containsSrc && !containsDest) {
            throw new IllegalArgumentException("Neither source nor destination are contained in this :\n" + src + "\n" + dest);
        }
        Link toAdd = new Link(src, f, dest);
        if (containsSrc && containsDest) {
            this.links.add(toAdd);
        } else {
            int index;
            SQLRowValues rowToAdd;
            assert (src.getGraph(false) != dest.getGraph(false));
            if (containsSrc) {
                rowToAdd = dest;
                int srcIndex = this.links.indexOf(new Link(src));
                if (srcIndex < 0) {
                    throw new IllegalStateException("Source link not found for " + src);
                }
                index = srcIndex;
            } else {
                assert (containsDest);
                rowToAdd = src;
                index = -1;
            }
            SQLRowValuesCluster graphToAdd = rowToAdd.getGraph(false);
            if (index >= 0) {
                this.links.add(index, toAdd);
            }
            if (graphToAdd == null) {
                this.addVals(index, rowToAdd);
                rowToAdd.setGraph(this);
            } else {
                if (index < 0) {
                    this.links.addAll(graphToAdd.links);
                } else {
                    this.links.addAll(index, graphToAdd.links);
                }
                graphToAdd.links.clear();
                this.items.addAll(graphToAdd.items);
                for (SQLRowValues newlyAdded : graphToAdd.items) {
                    newlyAdded.setGraph(this);
                }
                graphToAdd.items.clear();
                if (graphToAdd.listeners != null) {
                    this.getListeners().putAll(graphToAdd.listeners);
                    graphToAdd.listeners = null;
                }
            }
            if (index < 0) {
                this.links.add(toAdd);
            }
        }
        assert (src.getGraph() == dest.getGraph());
    }

    private IdentitySet<SQLRowValues> getReachable(SQLRowValues from) {
        IdentityHashSet<SQLRowValues> res = new IdentityHashSet<SQLRowValues>();
        this.getReachableRec(from, res);
        return res;
    }

    private void getReachableRec(SQLRowValues from, IdentitySet<SQLRowValues> acc) {
        if (!acc.add(from)) {
            return;
        }
        for (SQLRowValues fVals : from.getForeigns().values()) {
            this.getReachableRec(fVals, acc);
        }
        for (SQLRowValues fVals : from.getReferentRows()) {
            this.getReachableRec(fVals, acc);
        }
    }

    final SQLRowValues deepCopy(SQLRowValues v) {
        return this.deepCopy(v, false);
    }

    final SQLRowValues deepCopy(SQLRowValues v, boolean freeze) {
        IdentityHashMap<SQLRowValues, SQLRowValues> noLinkCopy = new IdentityHashMap<SQLRowValues, SQLRowValues>();
        SQLRowValues.ForeignCopyMode copyMode = SQLRowValues.ForeignCopyMode.COPY_NULL;
        for (SQLRowValues n : this.getItems()) {
            SQLRowValues copy;
            if (freeze) {
                copy = new SQLRowValues(n.getTable(), n.size(), n.getForeignsSize(), n.getReferents().size());
                copy.setAll(n.getAllValues(copyMode));
            } else {
                copy = new SQLRowValues(n, copyMode);
            }
            noLinkCopy.put(n, copy);
        }
        for (Link l : this.links) {
            if (l.getField() != null) {
                ((SQLRowValues)noLinkCopy.get(l.getSrc())).put(l.getField().getName(), noLinkCopy.get(l.getDest()));
                continue;
            }
            assert (noLinkCopy.containsKey(l.getSrc()));
        }
        SQLRowValues res = (SQLRowValues)noLinkCopy.get(v);
        if (freeze) {
            res.getGraph().freeze();
        }
        assert (res.isFrozen() == freeze);
        return res;
    }

    public final StoreResult store(StoreMode mode) throws SQLException {
        return this.store(mode, true);
    }

    public final StoreResult store(final StoreMode mode, boolean checkValidity) throws SQLException {
        final IdentityHashMap<SQLRowValues, Node> nodes = new IdentityHashMap<SQLRowValues, Node>(this.size());
        for (SQLRowValues vals : this.getItems()) {
            nodes.put(vals, new Node(vals));
        }
        if (checkValidity) {
            for (Node n : nodes.values()) {
                n.noLink.checkValidity();
            }
        }
        final ArrayList<StoringLink> storingLinks = new ArrayList<StoringLink>(this.links.size());
        for (Link l : this.links) {
            storingLinks.add(new StoringLink(l));
        }
        List<SQLTableEvent> events = SQLUtils.executeAtomic(this.getSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<List<SQLTableEvent>, SQLException>(){

            @Override
            public List<SQLTableEvent> handle(SQLDataSource ds) throws SQLException {
                ArrayList<SQLTableEvent> res = new ArrayList<SQLTableEvent>();
                while (storingLinks.size() > 0) {
                    StoringLink toStore = (StoringLink)storingLinks.remove(0);
                    if (!toStore.canStore()) {
                        throw new IllegalStateException();
                    }
                    Node n = (Node)nodes.get(toStore.getSrc());
                    boolean lastDBAccess = true;
                    Iterator iter = storingLinks.iterator();
                    while (iter.hasNext()) {
                        StoringLink sl = (StoringLink)iter.next();
                        if (sl.getSrc() != toStore.getSrc()) continue;
                        if (sl.canStore()) {
                            iter.remove();
                            if (sl.destID == null) continue;
                            n.noLink.put(sl.getField().getName(), sl.destID);
                            continue;
                        }
                        lastDBAccess = false;
                    }
                    if (n.isStored()) {
                        res.add(n.update());
                    } else {
                        res.add(n.store(mode));
                        SQLRow r = n.getStoredRow();
                        for (StoringLink sl : storingLinks) {
                            if (sl.getDest() != toStore.getSrc()) continue;
                            sl.destID = r.getIDNumber();
                            ((Node)nodes.get(sl.getSrc())).noLink.put(sl.getField().getName(), r.getIDNumber());
                        }
                    }
                    if (!lastDBAccess) continue;
                    for (Map.Entry<String, SQLRowValues> e : toStore.getSrc().getForeigns().entrySet()) {
                        SQLRowValues foreign = ((Node)nodes.get(e.getValue())).getStoredValues();
                        if (!$assertionsDisabled && foreign == null) {
                            throw new AssertionError((Object)"since this the last db access for this row, all foreigns should have been inserted");
                        }
                        if (n.getStoredValues().getLong(e.getKey()) != foreign.getIDNumber().longValue()) {
                            throw new IllegalStateException("stored " + n.getStoredValues().getObject(e.getKey()) + " but foreign is " + SQLRowValues.trim(foreign));
                        }
                        n.getStoredValues().put(e.getKey(), foreign);
                    }
                }
                return res;
            }
        });
        for (SQLTableEvent n : events) {
            n.getTable().fire(n);
        }
        return new StoreResult(nodes);
    }

    public final <T> void walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure) {
        this.walk(start, acc, closure, RecursionType.BREADTH_FIRST);
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType) {
        return this.walk(start, acc, closure, recType, Link.Direction.FOREIGN);
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType, Link.Direction foreign) {
        return this.walk(start, acc, closure, new WalkOptions(foreign).setRecursionType(recType));
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, WalkOptions options) {
        this.containsCheck(start);
        return this.walk(new State<T>(Collections.singletonList(start), Path.get(start.getTable()), acc, closure), options, options.isStartIncluded());
    }

    private final <T> StopRecurseException walk(State<T> state, WalkOptions options, boolean computeThisState) {
        StopRecurseException e;
        StopRecurseException e2;
        if (computeThisState && options.getRecursionType() == RecursionType.BREADTH_FIRST && (e2 = state.compute()) != null) {
            return e2;
        }
        StopRecurseException res = null;
        if (options.getDirection() != Link.Direction.REFERENT) {
            res = this.rec(state, options, Link.Direction.FOREIGN);
        }
        if (res != null) {
            return res;
        }
        if (options.getDirection() != Link.Direction.FOREIGN) {
            res = this.rec(state, options, Link.Direction.REFERENT);
        }
        if (res != null) {
            return res;
        }
        if (computeThisState && options.getRecursionType() == RecursionType.DEPTH_FIRST && (e = state.compute()) != null) {
            return e;
        }
        return null;
    }

    private <T> StopRecurseException rec(State<T> state, WalkOptions options, Link.Direction actualDirection) {
        SetMap<SQLField, SQLRowValues> nextVals;
        SQLRowValues current = state.getCurrent();
        List<SQLRowValues> currentValsPath = state.getValsPath();
        if (actualDirection == Link.Direction.FOREIGN) {
            Map<SQLField, SQLRowValues> foreigns = current.getForeignsBySQLField();
            nextVals = new SetMap(new LinkedHashMap(foreigns.size()), CollectionMap2.Mode.NULL_FORBIDDEN);
            nextVals.mergeScalarMap(foreigns);
        } else {
            assert (actualDirection == Link.Direction.REFERENT);
            nextVals = current.getReferents();
        }
        ArrayList keys = new ArrayList(nextVals.keySet());
        if (actualDirection == Link.Direction.REFERENT || options.isForeignsOrderIgnored()) {
            Collections.sort(keys, FIELD_COMPARATOR);
        }
        for (SQLField f : keys) {
            for (SQLRowValues v : (Set)nextVals.getNonNull(f)) {
                if (!options.isCycleAllowed() && state.identityContains(v)) continue;
                Path path = (Path)state.getPath().add(f, actualDirection);
                ArrayList<SQLRowValues> valsPath = new ArrayList<SQLRowValues>(currentValsPath);
                valsPath.add(v);
                StopRecurseException e = this.walk(new State<T>(valsPath, path, state.getAcc(), ((State)state).closure), options, true);
                if (e == null || !e.isCompletely()) continue;
                return e;
            }
        }
        return null;
    }

    public final String printTree(SQLRowValues root, int cellLength) {
        this.containsCheck(root);
        final IdentityHashMap ys = new IdentityHashMap();
        final AtomicInteger currentY = new AtomicInteger(0);
        final Matrix<SQLRowValues> matrix = new Matrix<SQLRowValues>();
        this.walk(root, null, new Closure<State<Object>>(){

            public void executeChecked(State<Object> input) {
                SQLRowValues r = input.getCurrent();
                final int y = ys.containsKey(r) ? ((Integer)ys.get(r)).intValue() : currentY.getAndIncrement();
                matrix.put(input.getPath().length(), y, input.getCurrent());
                SQLRowValues ancestor = input.getPrevious();
                if (ancestor != null) {
                    ancestor.walkGraph(null, new Closure<State<Object>>(){

                        public void executeChecked(State<Object> input) {
                            SQLRowValues ancestorRow = input.getCurrent();
                            if (ys.containsKey(ancestorRow)) {
                                throw new StopRecurseException();
                            }
                            ys.put(ancestorRow, y);
                        }
                    });
                }
            }
        }, RecursionType.DEPTH_FIRST, Link.Direction.REFERENT);
        return matrix.print(cellLength, new ITransformer<SQLRowValues, String>(){

            public String transformChecked(SQLRowValues input) {
                if (input == null) {
                    return "";
                }
                if (input.hasID()) {
                    return input.asRow().simpleToString();
                }
                return input.getTable().toString();
            }
        });
    }

    public final String printNodes() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getClass().getSimpleName()) + " of " + this.size() + " nodes:\n");
        for (SQLRowValues n : this.getItems()) {
            sb.append(System.identityHashCode(n));
            sb.append(" ");
            sb.append(n.getTable());
            sb.append("\t");
            for (Map.Entry<String, SQLRowValues> e : n.getForeigns().entrySet()) {
                sb.append(e.getKey());
                sb.append(" -> ");
                sb.append(System.identityHashCode(e.getValue()));
                sb.append(" ; ");
            }
            sb.append(new SQLRowValues(n, SQLRowValues.ForeignCopyMode.NO_COPY));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.links;
    }

    private final Map<SQLRowValues, List<ValueChangeListener>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new IdentityHashMap<SQLRowValues, List<ValueChangeListener>>(4);
        }
        return this.listeners;
    }

    final void fireModification(SQLRowValues vals, String fieldName, Object newValue) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, fieldName, newValue));
        }
    }

    final void fireModification(SQLRowValues vals, Map<String, ?> m) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, m));
        }
    }

    final void fireModification(SQLRowValues vals, Set<String> removed) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, removed));
        }
    }

    private final void fireModification(ValueChangeEvent evt) {
        for (List<ValueChangeListener> list : this.listeners.values()) {
            for (ValueChangeListener l : list) {
                l.valueChange(evt);
            }
        }
    }

    final void fireModification(SQLRowValues.ReferentChangeEvent evt) {
        if (this.referentFireNeeded(evt.isAddition())) {
            for (List<ValueChangeListener> list : this.listeners.values()) {
                for (ValueChangeListener l : list) {
                    l.referentChange(evt);
                }
            }
        }
    }

    final boolean referentFireNeeded(boolean put) {
        return this.hasListeners() && !put;
    }

    final boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public static class Commit
    extends StoreMode {
        @Override
        SQLTableEvent execOn(SQLRowValues vals) throws SQLException {
            return vals.commitJustThis();
        }
    }

    public static class Insert
    extends StoreMode {
        private final boolean insertPK;
        private final boolean insertOrder;

        public Insert(boolean insertPK, boolean insertOrder) {
            this.insertPK = insertPK;
            this.insertOrder = insertOrder;
        }

        @Override
        SQLTableEvent execOn(SQLRowValues vals) throws SQLException {
            HashSet<SQLField> autoFields = new HashSet<SQLField>();
            if (!this.insertPK) {
                autoFields.addAll(vals.getTable().getPrimaryKeys());
            }
            if (!this.insertOrder) {
                autoFields.add(vals.getTable().getOrderField());
            }
            return vals.insertJustThis(autoFields);
        }
    }

    private static class Link {
        private final SQLRowValues src;
        private final SQLField f;
        private final SQLRowValues dest;

        public Link(SQLRowValues src) {
            this(src, null, null);
        }

        public Link(SQLRowValues src, SQLField f, SQLRowValues dest) {
            if (src == null) {
                throw new NullPointerException("src is null");
            }
            assert (f == null && dest == null || dest != null && f.getTable() == src.getTable());
            this.src = src;
            this.f = f;
            this.dest = dest;
        }

        public final SQLRowValues getSrc() {
            return this.src;
        }

        public final SQLRowValues getDest() {
            return this.dest;
        }

        public final SQLField getField() {
            return this.f;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.src);
            result = 31 * result + System.identityHashCode(this.dest);
            result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return this.src == other.src && this.dest == other.dest && CompareUtils.equals(this.f, other.f);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + System.identityHashCode(this.src) + (this.f == null ? "" : " " + this.f.getName() + " " + System.identityHashCode(this.dest));
        }
    }

    private static final class Node {
        private final SQLRowValues noLink;
        private final List<SQLTableEvent> modif = new ArrayList<SQLTableEvent>();

        private Node(SQLRowValues vals) {
            this.noLink = new SQLRowValues(vals, SQLRowValues.ForeignCopyMode.NO_COPY);
        }

        private SQLTableEvent store(StoreMode mode) throws SQLException {
            assert (!this.isStored());
            return this.addEvent(mode.execOn(this.noLink));
        }

        private SQLTableEvent update() throws SQLException {
            assert (this.isStored());
            HashSet<String> fieldsToUpdate = new HashSet<String>(this.noLink.getFields());
            fieldsToUpdate.removeAll(this.getEvent().getFieldNames());
            assert (fieldsToUpdate.size() > 0);
            SQLRowValues updatingVals = this.getStoredRow().createEmptyUpdateRow();
            updatingVals.load(this.noLink, fieldsToUpdate);
            SQLTableEvent evt = new Node(updatingVals).store(StoreMode.COMMIT);
            this.getStoredValues().load(evt.getRow(), null);
            evt.setRowValues(this.getStoredValues());
            return this.addEvent(evt);
        }

        public final boolean isStored() {
            return this.modif.size() > 0;
        }

        public final SQLRow getStoredRow() {
            return this.getEvent() == null ? null : this.getEvent().getRow();
        }

        public final SQLRowValues getStoredValues() {
            return this.getEvent() == null ? null : this.getEvent().getRowValues();
        }

        private final SQLTableEvent getEvent() {
            return CollectionUtils.getLast(this.modif);
        }

        private final SQLTableEvent addEvent(SQLTableEvent evt) {
            assert (evt != null);
            this.modif.add(evt);
            return evt;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.noLink;
        }
    }

    public static final class State<T> {
        private final List<SQLRowValues> valsPath;
        private final Path path;
        private T acc;
        private final ITransformer<State<T>, T> closure;

        State(List<SQLRowValues> valsPath, Path path, T acc, ITransformer<State<T>, T> closure) {
            this.valsPath = valsPath;
            this.path = path;
            this.acc = acc;
            this.closure = closure;
        }

        public SQLField getFrom() {
            return this.path.length() == 0 ? null : this.path.getSingleStep(this.path.length() - 1);
        }

        public final boolean isBackwards() {
            if (this.path.length() == 0) {
                throw new IllegalStateException("empty path");
            }
            return this.path.isBackwards(this.path.length() - 1);
        }

        StopRecurseException compute() {
            try {
                this.acc = this.closure.transformChecked(this);
                return null;
            }
            catch (StopRecurseException e) {
                return e;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " path: " + this.path + " current node: " + this.getCurrent() + " current acc: " + this.getAcc();
        }

        public final SQLRowValues getCurrent() {
            return CollectionUtils.getLast(this.valsPath);
        }

        public final SQLRowValues getPrevious() {
            return CollectionUtils.getNoExn(this.valsPath, this.valsPath.size() - 2);
        }

        public final List<SQLRowValues> getValsPath() {
            return this.valsPath;
        }

        final boolean identityContains(SQLRowValues vals) {
            for (SQLRowValues v : this.valsPath) {
                if (vals != v) continue;
                return true;
            }
            return false;
        }

        public Path getPath() {
            return this.path;
        }

        public T getAcc() {
            return this.acc;
        }
    }

    public static final class StopRecurseException
    extends RuntimeException {
        private boolean completely = true;

        public final StopRecurseException setCompletely(boolean completely) {
            this.completely = completely;
            return this;
        }

        public final boolean isCompletely() {
            return this.completely;
        }
    }

    public static abstract class StoreMode {
        public static final StoreMode COMMIT = new Commit();

        abstract SQLTableEvent execOn(SQLRowValues var1) throws SQLException;
    }

    public static final class StoreResult {
        private final Map<SQLRowValues, Node> nodes;

        public StoreResult(Map<SQLRowValues, Node> nodes) {
            this.nodes = nodes;
        }

        public final SQLRow getStoredRow(SQLRowValues vals) {
            return this.nodes.get(vals).getStoredRow();
        }
    }

    private static final class StoringLink
    extends Link {
        private Number destID = null;

        private StoringLink(Link l) {
            super(l.getSrc(), l.getField(), l.getDest());
        }

        public final boolean canStore() {
            return this.getDest() == null || this.destID != null;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " destID: " + this.destID;
        }
    }

    public static class ValueChangeEvent
    extends EventObject {
        private final Map<String, ?> added;
        private final Set<String> removed;

        private ValueChangeEvent(SQLRowValues vals, Map<String, ?> m) {
            super(vals);
            this.added = Collections.unmodifiableMap(m);
            this.removed = Collections.emptySet();
        }

        public ValueChangeEvent(SQLRowValues vals, String fieldName, Object newValue) {
            super(vals);
            this.added = Collections.singletonMap(fieldName, newValue);
            this.removed = Collections.emptySet();
        }

        public ValueChangeEvent(SQLRowValues vals, Set<String> removed) {
            super(vals);
            this.added = Collections.emptyMap();
            this.removed = Collections.unmodifiableSet(removed);
        }

        @Override
        public SQLRowValues getSource() {
            return (SQLRowValues)super.getSource();
        }

        public final Set<String> getAddedFields() {
            return this.added.keySet();
        }

        public final Set<String> getRemovedFields() {
            return this.removed;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " added : " + this.getAddedFields() + " removed: " + this.getRemovedFields();
        }
    }

    public static interface ValueChangeListener
    extends SQLRowValues.ReferentChangeListener {
        public void valueChange(ValueChangeEvent var1);
    }

    public static final class WalkOptions {
        private final Link.Direction direction;
        private RecursionType recType;
        private boolean allowCycle;
        private boolean includeStart;
        private boolean ignoreForeignsOrder;

        public WalkOptions(Link.Direction dir) {
            if (dir == null) {
                throw new NullPointerException("No direction");
            }
            this.direction = dir;
            this.recType = RecursionType.BREADTH_FIRST;
            this.allowCycle = false;
            this.includeStart = true;
            this.ignoreForeignsOrder = true;
        }

        public Link.Direction getDirection() {
            return this.direction;
        }

        public RecursionType getRecursionType() {
            return this.recType;
        }

        public WalkOptions setRecursionType(RecursionType recType) {
            if (recType == null) {
                throw new NullPointerException("No type");
            }
            this.recType = recType;
            return this;
        }

        public boolean isCycleAllowed() {
            return this.allowCycle;
        }

        public boolean isStartIncluded() {
            return this.includeStart;
        }

        public WalkOptions setStartIncluded(boolean includeStart) {
            this.includeStart = includeStart;
            return this;
        }

        public boolean isForeignsOrderIgnored() {
            return this.ignoreForeignsOrder;
        }
    }
}

