/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Clob;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.convertor.StringClobConvertor;

public abstract class SQLRowAccessor
implements SQLData {
    private final SQLTable table;

    protected SQLRowAccessor(SQLTable table) {
        if (table == null) {
            throw new NullPointerException("null SQLTable");
        }
        this.table = table;
    }

    @Override
    public final SQLTable getTable() {
        return this.table;
    }

    public final boolean hasID() throws ClassCastException {
        return this.getIDNumber() != null;
    }

    public abstract int getID();

    public abstract Number getIDNumber();

    public boolean isArchived() {
        if (!this.getTable().isArchivable()) {
            return false;
        }
        if (this.getTable().getArchiveField().getType().getJavaType().equals(Boolean.class)) {
            return this.getBoolean(this.getTable().getArchiveField().getName()) == Boolean.TRUE;
        }
        return this.getInt(this.getTable().getArchiveField().getName()) == 1;
    }

    public abstract Object getObject(String var1);

    public abstract Map<String, Object> getAbsolutelyAll();

    public final String getString(String field) {
        String result = null;
        Object obj = this.getObject(field);
        if (obj == null) {
            result = null;
        } else if (obj instanceof Date) {
            DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
            result = df.format((Date)obj);
        } else if (obj instanceof Clob) {
            try {
                result = (String)StringClobConvertor.INSTANCE.unconvert((Clob)obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = obj.toString();
            }
        } else {
            result = obj.toString();
        }
        return result;
    }

    public final int getInt(String field) {
        return this.getObjectAs(field, Number.class).intValue();
    }

    public final long getLong(String field) {
        return this.getObjectAs(field, Number.class).longValue();
    }

    public final Boolean getBoolean(String field) {
        return this.getObjectAs(field, Boolean.class);
    }

    public final <T> T getObjectAs(String field, Class<T> clazz) {
        T res = null;
        try {
            res = clazz.cast(this.getObject(field));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Impossible d'acc\u00e9der au champ " + field + " de la ligne " + this + " en tant que " + clazz.getSimpleName(), e);
        }
        return res;
    }

    public final boolean equalsAsRow(SQLRowAccessor o) {
        return this.getTable() == o.getTable() && this.getID() == o.getID();
    }

    public final int hashCodeAsRow() {
        return this.getTable().hashCode() + this.getID();
    }
}

