/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;

public class SQLInjector {
    private final SQLTable tableSrc;
    private final SQLTable tableDest;
    private final ArrayList<SQLField> from = new ArrayList();
    private final ArrayList<SQLField> to = new ArrayList();
    private final Map<SQLField, Object> values = new HashMap<SQLField, Object>();
    private static final Map<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>> allRegisteredInjectors = new HashMap<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>>();
    private boolean storeTransfer;
    private static Map<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>> injectors = new HashMap<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>>();

    public SQLInjector(DBRoot r, String src, String dest, boolean storeTransfer) {
        this(r.findTable(src), r.findTable(dest), storeTransfer);
    }

    public SQLInjector(SQLTable src, SQLTable dest, boolean storeTransfer) {
        Map<SQLTable, SQLInjector> srcs;
        this.tableDest = dest;
        this.tableSrc = src;
        this.storeTransfer = storeTransfer;
        DBRoot dbRoot = src.getDBRoot();
        Map<SQLTable, Map<SQLTable, SQLInjector>> inj = allRegisteredInjectors.get(dbRoot);
        if (inj == null) {
            inj = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
            allRegisteredInjectors.put(dbRoot, inj);
        }
        if ((srcs = inj.get(src)) == null) {
            srcs = new HashMap<SQLTable, SQLInjector>();
            inj.put(src, srcs);
        }
        srcs.put(dest, this);
        if (storeTransfer) {
            inj = injectors.get(dbRoot);
            if (inj == null) {
                inj = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
                injectors.put(dbRoot, inj);
            }
            if ((srcs = inj.get(src)) == null) {
                srcs = new HashMap<SQLTable, SQLInjector>();
                inj.put(src, srcs);
            }
            srcs.put(dest, this);
        }
    }

    private String getTableTranferName() {
        return "TR_" + this.getSource().getName();
    }

    protected final synchronized void mapDefaultValues(SQLField fieldDest, Object defaultValue) {
        if (!fieldDest.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + fieldDest + " is not a field of table " + this.tableDest);
        }
        this.values.put(fieldDest, defaultValue);
    }

    protected final synchronized void map(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (index > 0) {
            this.to.set(index, to);
        } else {
            this.from.add(from);
            this.to.add(to);
        }
    }

    protected final synchronized void remove(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (this.to.get(index).getName().equalsIgnoreCase(to.getName())) {
            this.to.remove(to);
            this.from.remove(from);
        }
    }

    public synchronized void createDefaultMap() {
        for (SQLField field : this.tableSrc.getContentFields()) {
            if (!this.tableDest.contains(field.getName())) continue;
            this.map(field, this.tableDest.getField(field.getName()));
        }
    }

    public static synchronized SQLInjector getInjector(SQLTable src, SQLTable dest) {
        SQLInjector injector = SQLInjector.getRegistrereddInjector(src, dest);
        if (injector == null) {
            injector = SQLInjector.createDefaultInjector(src, dest);
        }
        return injector;
    }

    public static synchronized SQLInjector getRegistrereddInjector(SQLTable src, SQLTable dest) {
        Map<SQLTable, Map<SQLTable, SQLInjector>> map = allRegisteredInjectors.get(src.getDBRoot());
        if (map == null) {
            return null;
        }
        Map<SQLTable, SQLInjector> m = map.get(src);
        if (m != null) {
            return m.get(dest);
        }
        return null;
    }

    private static synchronized SQLInjector createDefaultInjector(SQLTable src, SQLTable dest) {
        System.err.println("No SQLInjector defined for " + src + " , " + dest + ". SQLInjector created automatically.");
        SQLInjector injector = new SQLInjector(src, dest, false);
        injector.createDefaultMap();
        return injector;
    }

    public synchronized SQLTable getDestination() {
        return this.tableDest;
    }

    public synchronized SQLTable getSource() {
        return this.tableSrc;
    }

    public static synchronized void createTransferTables(DBRoot root) throws SQLException {
        Map<SQLTable, Map<SQLTable, SQLInjector>> map = injectors.get(root);
        if (root == null) {
            System.err.println("No SQLInjector for root " + root);
            return;
        }
        Set<SQLTable> srcTables = map.keySet();
        if (srcTables.isEmpty()) {
            System.err.println("No SQLInjector for root " + root);
            return;
        }
        ArrayList<SQLCreateTable> createTablesQueries = new ArrayList<SQLCreateTable>();
        for (SQLTable sqlTable : srcTables) {
            String trTableName = "TR_" + sqlTable.getName();
            if (root.getTable(trTableName) != null) continue;
            SQLCreateTable createTable = new SQLCreateTable(root, trTableName);
            createTable.setPlain(false);
            createTable.addForeignColumn("ID_" + sqlTable.getName(), sqlTable);
            createTablesQueries.add(createTable);
        }
        if (createTablesQueries.size() > 0) {
            root.createTables(createTablesQueries);
        }
        ArrayList<AlterTable> alterTablesQueries = new ArrayList<AlterTable>();
        TablesMap toRefresh = new TablesMap();
        for (SQLTable srcTable : srcTables) {
            String trTableName = "TR_" + srcTable.getName();
            SQLTable transfertTable = root.getTable(trTableName);
            AlterTable alter = new AlterTable(transfertTable);
            Set<SQLTable> destTables = map.get(srcTable).keySet();
            for (SQLTable destTable : destTables) {
                String fk = "ID_" + destTable.getName();
                if (transfertTable.contains(fk)) continue;
                alter.addForeignColumn(fk, destTable);
            }
            if (alter.isEmpty()) continue;
            alterTablesQueries.add(alter);
            toRefresh.add(alter.getRootName(), alter.getName());
        }
        for (String q : ChangeTable.cat(alterTablesQueries)) {
            root.getDBSystemRoot().getDataSource().execute(q);
        }
        root.getSchema().updateVersion();
        root.getDBSystemRoot().refresh(toRefresh, false);
    }

    public void addTransfert(int idFrom, int idTo) throws SQLException {
        SQLTable tableTransfert = this.getSource().getTable(this.getTableTranferName());
        SQLRowValues rowTransfer = new SQLRowValues(tableTransfert);
        Set<SQLField> foreignKeysSrc = tableTransfert.getForeignKeys(this.getSource());
        Set<SQLField> foreignKeysDest = tableTransfert.getForeignKeys(this.getDestination());
        rowTransfer.put(foreignKeysSrc.iterator().next().getName(), idFrom);
        rowTransfer.put(foreignKeysDest.iterator().next().getName(), idTo);
        rowTransfer.commit();
    }
}

