/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Arrays;
import java.util.List;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.PGSQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.cc.IClosure;

public class MySQLBase
extends SQLBase {
    private List<String> modes = null;

    MySQLBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        super(server, name, systemRootInit, login, pass, dsInit);
    }

    public final synchronized List<String> getModes() {
        if (this.modes == null) {
            String modes = (String)this.getDataSource().executeScalar("SELECT @@global.sql_mode;");
            this.modes = Arrays.asList(modes.split(","));
        }
        return this.modes;
    }

    private final boolean shouldEscape() {
        return !this.getModes().contains("NO_BACKSLASH_ESCAPES");
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        if (s == null) {
            return res;
        }
        return this.shouldEscape() ? PGSQLBase.BACKSLASH_PATTERN.matcher(res).replaceAll(PGSQLBase.TWO_BACKSLASH_REPLACEMENT) : res;
    }
}

