/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLItem;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

class FromClause
implements SQLItem {
    private static final SQLItem COMMA = new SQLItem(){

        @Override
        public String getSQL() {
            return ", ";
        }
    };
    private static final SQLItem NEWLINE = new SQLItem(){

        @Override
        public String getSQL() {
            return "\n";
        }
    };
    private final Set<TableRef> tables;
    private final List<SQLItem> sql = new ArrayList<SQLItem>();

    public FromClause() {
        this.tables = new HashSet<TableRef>();
    }

    public FromClause(FromClause f) {
        this();
        this.sql.addAll(f.sql);
        this.tables.addAll(f.tables);
    }

    void add(TableRef res) {
        if (this.tables.add(res)) {
            if (!this.sql.isEmpty()) {
                this.sql.add(COMMA);
            }
            this.sql.add(res);
        }
    }

    void add(SQLSelectJoin j) {
        if (this.tables.add(j.getJoinedTable())) {
            if (this.sql.isEmpty()) {
                throw new IllegalArgumentException("nothing to join with " + j);
            }
        } else {
            throw new IllegalArgumentException(j.getJoinedTable() + ": the joined table is already in this from: " + this);
        }
        this.sql.add(NEWLINE);
        this.sql.add(j);
    }

    @Override
    public String getSQL() {
        return "FROM " + CollectionUtils.join(this.sql, "", new ITransformer<SQLItem, String>(){

            public String transformChecked(SQLItem input) {
                return input.getSQL();
            }
        });
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.getSQL() + ">";
    }
}

