/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.utils.EnumOrderedSet;
import org.openconcerto.utils.change.AddAllCreator;
import org.openconcerto.utils.change.CollectionChangeEvent;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public abstract class DBStructureItemJDBC
extends DBStructureItem<DBStructureItemJDBC> {
    private DBStructureItemDB alterEgo = null;
    private boolean alterEgoCreated = false;
    private boolean dropped = false;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    protected DBStructureItemJDBC(DBStructureItemJDBC parent, String name) {
        super(parent, name);
    }

    final void dropped() {
        assert (this.getParent() == null || ((DBStructureItemJDBC)this.getParent()).getChild(this.getName()) != this) : "Dropped child still in its parent : " + this;
        this.droppedRec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void droppedRec() {
        DBStructureItemDB alterEgo;
        for (DBStructureItemJDBC child : this.getChildren()) {
            if (child == null) continue;
            child.droppedRec();
        }
        DBStructureItemJDBC dBStructureItemJDBC = this;
        synchronized (dBStructureItemJDBC) {
            if (this.dropped) {
                throw new IllegalStateException("Already dropped : " + this);
            }
            this.dropped = true;
            alterEgo = this.alterEgo;
        }
        if (alterEgo != null) {
            alterEgo.onDrop();
        }
        this.onDrop();
    }

    public final synchronized boolean isDropped() {
        return this.dropped;
    }

    protected final synchronized void checkDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Already dropped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChildrenListener(PropertyChangeListener l) {
        PropertyChangeSupport propertyChangeSupport = this.supp;
        synchronized (propertyChangeSupport) {
            this.supp.addPropertyChangeListener("children", l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rmChildrenListener(PropertyChangeListener l) {
        PropertyChangeSupport propertyChangeSupport = this.supp;
        synchronized (propertyChangeSupport) {
            this.supp.removePropertyChangeListener("children", l);
        }
    }

    protected final CollectionChangeEventCreator createChildrenCreator() {
        return new AddAllCreator(this, "children", this.getChildrenNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenChanged(CollectionChangeEventCreator cc) {
        assert (this.getDBSystemRoot() == null || Thread.holdsLock(this.getDBSystemRoot().getTreeMutex())) : "State might have already changed by the time Listeners are notified";
        if (!cc.getName().equals("children")) {
            throw new IllegalArgumentException("wrong name: " + cc.getName() + " ; should use createChildrenCreator()");
        }
        CollectionChangeEvent event = cc.create(this.getChildrenNames());
        PropertyChangeSupport propertyChangeSupport = this.supp;
        synchronized (propertyChangeSupport) {
            this.supp.firePropertyChange(event);
        }
    }

    private final HierarchyLevel getNextLevel() {
        return this.getLevels().getNext(this.getLevel());
    }

    final DBStructureItemJDBC getNonNullDBParent() {
        HierarchyLevel nextLevel = this.getNextLevel();
        if (nextLevel == null || this.getDB().getLevels().contains(nextLevel)) {
            return this;
        }
        DBStructureItemJDBC child = (DBStructureItemJDBC)this.getChild(null);
        return child != null ? child.getNonNullDBParent() : null;
    }

    @Override
    protected final EnumOrderedSet<HierarchyLevel> getLevels() {
        return HierarchyLevel.getAll();
    }

    final synchronized DBStructureItemDB getRawAlterEgo() {
        if (!this.alterEgoCreated) {
            this.checkDropped();
            this.alterEgo = DBStructureItemDB.create(this);
            this.alterEgoCreated = true;
        }
        return this.alterEgo;
    }

    @Override
    public final DBStructureItemDB getDB() {
        if (this.getRawAlterEgo() != null) {
            return this.getRawAlterEgo();
        }
        return ((DBStructureItemJDBC)this.getParent()).getDB();
    }

    @Override
    protected DBStructureItemJDBC getJDBC() {
        return this;
    }
}

