/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.LinkedListMap;
import org.openconcerto.utils.change.ListChangeRecorder;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;

public abstract class SQLElement {
    private static final Set<String> computingFF = Collections.unmodifiableSet(new HashSet());
    private static final Set<SQLField> computingRF = Collections.unmodifiableSet(new HashSet());
    public static final String DEFERRED_CODE = new String("deferred code");
    private SQLElementDirectory directory;
    private String l18nPkgName;
    private Class<?> l18nClass;
    private Phrase name;
    private final SQLTable primaryTable;
    private String code;
    private ComboSQLRequest combo;
    private ListSQLRequest list;
    private final ListChangeRecorder rowActions;
    private final LinkedListMap components;
    private Set<String> normalFF;
    private String parentFF;
    private Set<String> sharedFF;
    private Map<String, SQLElement> privateFF;
    private final Map actions;
    private Set<SQLField> childRF;
    private Set<SQLField> privateParentRF;
    private Set<SQLField> otherRF;
    private SQLCache<SQLRowAccessor, Object> modelCache;
    private final Map<String, JComponent> additionalFields;
    private final List additionalListCols;
    private List<String> mdPath;

    private static Phrase createPhrase(String singular, String plural) {
        String base;
        NounClass nounClass;
        if (singular.startsWith("une ")) {
            nounClass = NounClass.FEMININE;
            base = singular.substring(4);
        } else if (singular.startsWith("un ")) {
            nounClass = NounClass.MASCULINE;
            base = singular.substring(3);
        } else {
            nounClass = null;
            base = singular;
        }
        Phrase res = new Phrase(Grammar_fr.getInstance(), base, nounClass);
        if (nounClass != null) {
            res.putVariant(Grammar.INDEFINITE_ARTICLE_SINGULAR, singular);
        }
        res.putVariant(Grammar.PLURAL, plural);
        return res;
    }

    @Deprecated
    public SQLElement(String singular, String plural, SQLTable primaryTable) {
        this(primaryTable, SQLElement.createPhrase(singular, plural));
    }

    public SQLElement(SQLTable primaryTable, Phrase name) {
        this(primaryTable, name, null);
    }

    public SQLElement(SQLTable primaryTable, Phrase name, String code) {
        if (primaryTable == null) {
            throw new DBStructureItemNotFound("table is null for " + this.getClass());
        }
        this.primaryTable = primaryTable;
        this.setL18nPackageName(null);
        this.setDefaultName(name);
        this.code = code == null ? this.createCode() : code;
        this.combo = null;
        this.list = null;
        this.rowActions = new ListChangeRecorder(new ArrayList());
        this.actions = new HashMap();
        this.resetRelationships();
        this.components = new LinkedListMap();
        this.modelCache = null;
        this.additionalFields = new LinkedHashMap<String, JComponent>();
        this.additionalListCols = new ArrayList();
        this.mdPath = Collections.emptyList();
    }

    protected String createCode() {
        return String.valueOf(this.getClass().getName()) + "-" + this.getTable().getName();
    }

    public synchronized void resetRelationships() {
        this.privateFF = null;
        this.parentFF = null;
        this.normalFF = null;
        this.sharedFF = null;
        this.actions.clear();
        this.childRF = null;
        this.privateParentRF = null;
        this.otherRF = null;
    }

    protected final synchronized boolean areRelationshipsInited() {
        return this.sharedFF != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDirectory(SQLElementDirectory directory) {
        assert (directory == null || directory.getElement(this.getTable()) == this);
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            if (this.directory != directory) {
                if (this.areRelationshipsInited()) {
                    this.resetRelationships();
                }
                this.directory = directory;
            }
        }
    }

    public final synchronized SQLElementDirectory getDirectory() {
        return this.directory;
    }

    public final void setL18nPackageName(String name) {
        this.setL18nLocation(name, null);
    }

    public final synchronized void setL18nLocation(String name, Class<?> ctxt) {
        this.l18nPkgName = name;
        this.l18nClass = ctxt == null ? this.getClass() : ctxt;
    }

    public final synchronized void setDefaultName(Phrase name) {
        this.name = name != null ? name : Phrase.getInvariant(this.getTable().getName());
    }

    public CollectionMap<String, String> getShowAs() {
        return null;
    }

    public final SQLTable getTable() {
        return this.primaryTable;
    }

    public final synchronized String getCode() {
        if (this.code == DEFERRED_CODE) {
            String createCode = this.createCode();
            if (createCode == DEFERRED_CODE) {
                throw new IllegalStateException("createCode() returned DEFERRED_CODE");
            }
            this.code = createCode;
        }
        return this.code;
    }

    protected Set<String> getChildren() {
        return Collections.emptySet();
    }

    protected String getParentFFName() {
        return null;
    }

    protected List<String> getPrivateFields() {
        return Collections.emptyList();
    }

    protected abstract List<String> getListFields();

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SQLElement) {
            SQLElement o = (SQLElement)obj;
            boolean parentEq = CompareUtils.equals(this.getParentFFName(), o.getParentFFName());
            return this.getTable().equals(o.getTable()) && CompareUtils.equals(this.getDirectory(), o.getDirectory()) && parentEq && this.getPrivateFields().equals(o.getPrivateFields()) && this.getChildren().equals(o.getChildren());
        }
        return false;
    }

    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.primaryTable.hashCode();
        result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.getTable().getSQLName();
    }
}

