/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.openconcerto.erp.modules.DependencyGraph;
import org.openconcerto.erp.modules.FactoriesByID;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.Tuple2;

public class ModuleManager {
    static final Logger L = Logger.getLogger(ModuleManager.class.getPackage().getName());
    private static ExecutorService exec = null;
    static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final long MIN_VERSION = ModuleVersion.MIN.getMerged();
    private static final String FWK_MODULE_TABLENAME = new String("FWK_MODULE_METADATA");
    private static final String FWK_MODULE_DEP_TABLENAME = new String("FWK_MODULE_DEP");
    private static final String fileMutex = new String("modules");
    private static final Integer TO_INSTALL_VERSION = 1;
    private static ModuleManager instance = null;
    private final FactoriesByID factories;
    private final Map runningModules;
    private final Map<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> modulesElements;
    private boolean inited = false;
    private final Map modulesComponents;
    private final DependencyGraph dependencyGraph;
    private final Map createdModules;
    private final Object varLock = new String("varLock");
    private DBRoot root = null;
    private SQLPreferences dbPrefs = null;
    private Configuration conf = null;
    private boolean exitAllowed = true;

    public ModuleManager() {
        this.factories = new FactoriesByID();
        this.runningModules = new LinkedHashMap();
        this.dependencyGraph = new DependencyGraph();
        this.createdModules = new LinkedHashMap();
        this.modulesElements = new HashMap<ModuleReference, IdentityHashMap<SQLElement, SQLElement>>();
        this.modulesComponents = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRoot(DBRoot root) {
        Object object = this.varLock;
        synchronized (object) {
            if (this.root != root) {
                if (this.root != null) {
                    throw new IllegalStateException("Root already set");
                }
                this.root = root;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLTable getInstalledTable(DBRoot r) throws SQLException {
        String string = FWK_MODULE_TABLENAME;
        synchronized (string) {
            SQLCreateTable createTable;
            ArrayList<SQLCreateTable> createTables = new ArrayList<SQLCreateTable>(4);
            if (!r.contains(FWK_MODULE_TABLENAME)) {
                createTable = new SQLCreateTable(r, FWK_MODULE_TABLENAME);
                createTable.setPlain(true);
                createTable.addColumn("ID", createTable.getSyntax().getPrimaryIDDefinitionShort());
                createTable.setPrimaryKey("ID");
                createTable.addVarCharColumn("MODULE_NAME", 128);
                createTable.addColumn("TABLE", "varchar(128) NULL");
                createTable.addColumn("FIELD", "varchar(128) NULL");
                createTable.addColumn("KEY", "boolean NULL");
                createTable.addColumn("MODULE_VERSION", "bigint NOT NULL");
                createTable.addUniqueConstraint("uniqModule", Arrays.asList("MODULE_NAME", "TABLE", "FIELD"));
                createTables.add(createTable);
            } else {
                createTable = null;
            }
            if (!r.contains(FWK_MODULE_DEP_TABLENAME)) {
                ChangeTable.ForeignColSpec fkNeeded;
                ChangeTable.ForeignColSpec fk;
                SQLCreateTable createDepTable = new SQLCreateTable(r, FWK_MODULE_DEP_TABLENAME);
                createDepTable.setPlain(true);
                if (createTable != null) {
                    fk = ChangeTable.ForeignColSpec.fromCreateTable(createTable);
                    fkNeeded = ChangeTable.ForeignColSpec.fromCreateTable(createTable);
                } else {
                    SQLTable moduleT = r.getTable(FWK_MODULE_TABLENAME);
                    fk = ChangeTable.ForeignColSpec.fromTable(moduleT);
                    fkNeeded = ChangeTable.ForeignColSpec.fromTable(moduleT);
                }
                createDepTable.addForeignColumn(fk.setColumnName("ID_MODULE"), Link.Rule.CASCADE, Link.Rule.CASCADE);
                createDepTable.addForeignColumn(fkNeeded.setColumnName("ID_MODULE_NEEDED"), Link.Rule.CASCADE, Link.Rule.RESTRICT);
                createDepTable.setPrimaryKey("ID_MODULE", "ID_MODULE_NEEDED");
                createTables.add(createDepTable);
            }
            r.createTables(createTables);
        }
        return r.getTable(FWK_MODULE_TABLENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBRoot getRoot() {
        Object object = this.varLock;
        synchronized (object) {
            return this.root;
        }
    }

    public final Set<ModuleReference> getModulesInstalledRemotely() throws SQLException {
        return this.getDBInstalledModuleRowsByRef(null).keySet();
    }

    private final Where getModuleRowWhere(TableRef installedTable) throws SQLException {
        return Where.isNull(installedTable.getField("TABLE")).and(Where.isNull(installedTable.getField("FIELD")));
    }

    private final List<SQLRow> getDBInstalledModuleRows(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect().addSelectStar(installedTable);
        sel.setWhere(this.getModuleRowWhere(installedTable));
        if (id != null) {
            sel.andWhere(new Where((FieldRef)installedTable.getField("MODULE_NAME"), "=", (Object)id));
        }
        return SQLRowListRSH.execute(sel);
    }

    private final ModuleReference getRef(SQLRow r) throws SQLException {
        return new ModuleReference(r.getString("MODULE_NAME"), new ModuleVersion(r.getLong("MODULE_VERSION")));
    }

    private final Map<ModuleReference, SQLRow> getDBInstalledModuleRowsByRef(String id) throws SQLException {
        HashMap<ModuleReference, SQLRow> res = new HashMap<ModuleReference, SQLRow>();
        for (SQLRow r : this.getDBInstalledModuleRows(id)) {
            res.put(this.getRef(r), r);
        }
        return res;
    }

    public final Tuple2<Set<String>, Set<SQLName>> getCreatedItems(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect();
        sel.addSelect(installedTable.getKey());
        sel.addSelect(installedTable.getField("TABLE"));
        sel.addSelect(installedTable.getField("FIELD"));
        sel.setWhere(new Where((FieldRef)installedTable.getField("MODULE_NAME"), "=", (Object)id).and(Where.isNotNull(installedTable.getField("TABLE"))));
        HashSet<String> tables = new HashSet<String>();
        HashSet<SQLName> fields = new HashSet<SQLName>();
        for (SQLRow r : SQLRowListRSH.execute(sel)) {
            String tableName = r.getString("TABLE");
            String fieldName = r.getString("FIELD");
            if (fieldName == null) {
                tables.add(tableName);
                continue;
            }
            fields.add(new SQLName(tableName, fieldName));
        }
        return Tuple2.create(tables, fields);
    }
}

