/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.HashMap;
import org.jdom2.CDATA;
import org.jdom2.CloneBase;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.ContentList;
import org.jdom2.DocType;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.IllegalAddException;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;

public class Document
extends CloneBase
implements Parent {
    transient ContentList content = new ContentList(this);
    protected String baseURI = null;
    private transient HashMap<String, Object> propertyMap = null;

    public Document() {
    }

    public Document(Element rootElement, DocType docType, String baseURI) {
        if (rootElement != null) {
            this.setRootElement(rootElement);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (baseURI != null) {
            this.setBaseURI(baseURI);
        }
    }

    public Document(Element rootElement) {
        this(rootElement, null, null);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(index);
    }

    public Document setRootElement(Element rootElement) {
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            this.content.add(rootElement);
        } else {
            this.content.set(index, rootElement);
        }
        return this;
    }

    public DocType getDocType() {
        int index = this.content.indexOfDocType();
        if (index < 0) {
            return null;
        }
        return (DocType)this.content.get(index);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int docTypeIndex = this.content.indexOfDocType();
            if (docTypeIndex >= 0) {
                this.content.remove(docTypeIndex);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int docTypeIndex = this.content.indexOfDocType();
        if (docTypeIndex < 0) {
            this.content.add(0, docType);
        } else {
            this.content.set(docTypeIndex, docType);
        }
        return this;
    }

    public Document addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public final void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public String toString() {
        Element rootElement;
        StringBuilder stringForm = new StringBuilder().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringForm.append(docType.toString()).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        Element element = rootElement = this.hasRootElement() ? this.getRootElement() : null;
        if (rootElement != null) {
            stringForm.append("Root is ").append(rootElement.toString());
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Document clone() {
        Document doc = (Document)super.clone();
        doc.content = new ContentList(doc);
        for (int i = 0; i < this.content.size(); ++i) {
            Content obj = this.content.get(i);
            if (obj instanceof Element) {
                Element element = ((Element)obj).clone();
                doc.content.add(element);
                continue;
            }
            if (obj instanceof Comment) {
                Comment comment = ((Comment)obj).clone();
                doc.content.add(comment);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                ProcessingInstruction pi = ((ProcessingInstruction)obj).clone();
                doc.content.add(pi);
                continue;
            }
            if (!(obj instanceof DocType)) continue;
            DocType dt = ((DocType)obj).clone();
            doc.content.add(dt);
        }
        return doc;
    }

    public Parent getParent() {
        return null;
    }

    public void canContainContent(Content child, int index, boolean replace) {
        if (child instanceof Element) {
            int cre = this.content.indexOfFirstElement();
            if (replace && cre == index) {
                return;
            }
            if (cre >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.content.indexOfDocType() >= index) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (child instanceof DocType) {
            int cdt = this.content.indexOfDocType();
            if (replace && cdt == index) {
                return;
            }
            if (cdt >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int firstElt = this.content.indexOfFirstElement();
            if (firstElt != -1 && firstElt < index) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (child instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (child instanceof Text) {
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (child instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }
}

