/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.text.UCharacterIterator;
import java.text.CharacterIterator;

public class CharacterIteratorWrapper
extends UCharacterIterator {
    private CharacterIterator iterator;

    public CharacterIteratorWrapper(CharacterIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException();
        }
        this.iterator = iter;
    }

    public int getLength() {
        return this.iterator.getEndIndex() - this.iterator.getBeginIndex();
    }

    public int getIndex() {
        return this.iterator.getIndex();
    }

    public int next() {
        char i = this.iterator.current();
        this.iterator.next();
        if (i == '\uffff') {
            return -1;
        }
        return i;
    }

    public int previous() {
        char i = this.iterator.previous();
        if (i == '\uffff') {
            return -1;
        }
        return i;
    }

    public void setIndex(int index) {
        try {
            this.iterator.setIndex(index);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public Object clone() {
        try {
            CharacterIteratorWrapper result = (CharacterIteratorWrapper)super.clone();
            result.iterator = (CharacterIterator)this.iterator.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

