/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.importer.product.suzuki;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.Constraint;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.importer.DoubleAsLongValueConverter;
import org.openconcerto.erp.importer.NotEmptyConstraint;
import org.openconcerto.erp.importer.RowValuesNavigatorPanel;
import org.openconcerto.erp.importer.ValueConverter;
import org.openconcerto.modules.importer.product.suzuki.ParseSuzukiFile;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ProductImporter {
    private final DecimalFormat decimalFormat = new DecimalFormat("##,##0.00#");
    private Map<Object, Integer> famillesMap = new HashMap<Object, Integer>();
    private Map<Object, Integer> fournisseursMap = new HashMap<Object, Integer>();
    private String[] suzuki = new String[]{"Suzuki"};
    private static final String SUZUKI_FAMILY = "Suzuki";
    private Map<String, Remise> map;
    private BigDecimal margeB;

    public void importArticlesFrom(File file, boolean updateOnly) throws IOException, SQLException, ParseException {
        this.map = new HashMap<String, Remise>();
        Remise[] remiseArray = Remise.values();
        int n = remiseArray.length;
        int n2 = 0;
        while (n2 < n) {
            Remise r = remiseArray[n2];
            this.map.put(r.getCode(), r);
            ++n2;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        panel.add((Component)new JLabel("Marge"), c);
        final JFormattedTextField field = new JFormattedTextField();
        field.setColumns(15);
        MaskFormatter mask = new MaskFormatter("##.##");
        mask.setValidCharacters("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        mask.install(field);
        panel.add((Component)field, c);
        field.setText("11.20");
        ++c.gridy;
        final JButton button = new JButton("Valider");
        panel.add(button);
        field.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void update(DocumentEvent e) {
                button.setEnabled(field.isEditValid());
            }
        });
        PanelFrame frame = new PanelFrame(panel, "Importation tarifs Suzuki");
        button.addActionListener(new AbstractAction("Valider", (JFrame)frame, file, updateOnly, field){
            private final /* synthetic */ JFrame val$frame;
            private final /* synthetic */ File val$file;
            private final /* synthetic */ boolean val$updateOnly;
            private final /* synthetic */ JFormattedTextField val$field;
            {
                this.val$frame = jFrame;
                this.val$file = file;
                this.val$updateOnly = bl;
                this.val$field = jFormattedTextField;
                super($anonymous0);
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    this.val$frame.dispose();
                    ProductImporter.this.importArticles(this.val$file, this.val$updateOnly, this.val$field.getText());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((String)"Erreur pendant l'importation!", (Throwable)e);
                }
            }
        });
        FrameUtil.show((Window)frame);
    }

    private void importArticles(File file, final boolean updateOnly, String marge) throws IOException, SQLException {
        this.margeB = new BigDecimal(marge);
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE_FOURNISSEUR");
        final DataImporter importer = new DataImporter(table){

            protected void customizeRowValuesToFetch(SQLRowValues vals) {
                vals.put("ID_ARTICLE", null);
                vals.put("ID_FOURNISSEUR", null);
            }
        };
        importer.setSkipFirstLine(true);
        ParseSuzukiFile parser = new ParseSuzukiFile(file);
        ArrayTableModel m = new ArrayTableModel(parser.parse());
        try {
            Object[] objsFamille = new Object[]{SUZUKI_FAMILY};
            this.resolveFamille(objsFamille);
        }
        catch (SQLException originalExn) {
            ExceptionHandler.handle((String)"Impossible de cr\u00e9er les familles", (Throwable)originalExn);
            return;
        }
        try {
            this.resolveFournisseur();
        }
        catch (SQLException originalExn) {
            ExceptionHandler.handle((String)"Impossible de cr\u00e9er les fournisseurs", (Throwable)originalExn);
            return;
        }
        importer.map(0, table.getField("CODE"), (ValueConverter)new DoubleAsLongValueConverter(table.getField("CODE")));
        importer.map(1, table.getField("NOM"));
        ValueConverter convertPriceVt = new ValueConverter(table.getField("PV_HT")){

            public Object convertFrom(Object obj) {
                if (obj == null || obj.toString().trim().length() == 0) {
                    return null;
                }
                BigDecimal b = ProductImporter.this.convertPrice(obj.toString());
                return b.multiply(ProductImporter.this.margeB.movePointLeft(2).add(BigDecimal.ONE)).setScale(2, RoundingMode.HALF_UP);
            }
        };
        importer.map(2, table.getField("PV_HT"), convertPriceVt);
        importer.map(4, table.getField("INFOS"));
        importer.addContraint(0, (Constraint)new NotEmptyConstraint());
        importer.addUniqueField(table.getField("CODE"));
        m = importer.createConvertedModel(m);
        importer.importFromModel(m);
        this.addRequiredField(importer.getValuesToInsert());
        this.addRequiredField(importer.getValuesToUpdate());
        RowValuesNavigatorPanel p = new RowValuesNavigatorPanel();
        p.setRowValuesToInsert(importer.getValuesToInsert());
        p.setRowValuesToUpdate(importer.getValuesToUpdate());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProductImporter.doImport(updateOnly, importer);
            }
        });
    }

    private void resolveFamille(Object[] objs) throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("FAMILLE_ARTICLE_FOURNISSEUR");
        this.resolve(objs, table, this.famillesMap);
    }

    private void resolveFournisseur() throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("FOURNISSEUR");
        this.resolve(this.suzuki, table, this.fournisseursMap);
    }

    private final BigDecimal convertPrice(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean start = true;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ',' || c == '.') {
                if (start) {
                    result.append('0');
                }
                result.append('.');
                start = false;
            } else if (start && c != '0') {
                result.append(c);
                start = false;
            } else if (!start) {
                result.append(c);
            }
            ++n2;
        }
        return new BigDecimal(result.toString());
    }

    private void addRequiredField(List<SQLRowValues> values) throws SQLException {
        for (SQLRowValues sqlRowValues : values) {
            sqlRowValues.put("CODE_BARRE", (Object)sqlRowValues.getString("CODE").replaceAll("-", "").replaceAll(" ", ""));
            sqlRowValues.put("ID_MODE_VENTE_ARTICLE", 5);
            BigDecimal pVenteHT = sqlRowValues.getBigDecimal("PV_HT");
            if (pVenteHT == null) {
                pVenteHT = BigDecimal.ZERO;
            }
            sqlRowValues.put("ID_FOURNISSEUR", (Object)this.fournisseursMap.get(SUZUKI_FAMILY));
            if (!sqlRowValues.hasID()) {
                sqlRowValues.put("ID_FAMILLE_ARTICLE_FOURNISSEUR", (Object)this.famillesMap.get(SUZUKI_FAMILY));
            }
            sqlRowValues.put("PRIX_METRIQUE_VT_1", (Object)pVenteHT);
            String remise = sqlRowValues.getString("INFOS");
            sqlRowValues.remove("INFOS");
            if (remise != null && remise.trim().length() > 0) {
                BigDecimal pa = pVenteHT.divide(this.margeB.movePointLeft(2).add(BigDecimal.ONE), MathContext.DECIMAL128);
                Remise r = this.map.get(remise);
                if (r != null) {
                    pa = pa.divide(r.getRemise().movePointLeft(2).add(BigDecimal.ONE), MathContext.DECIMAL128).setScale(6, RoundingMode.HALF_UP);
                    sqlRowValues.put("PA_HT", (Object)pa);
                    sqlRowValues.put("PRIX_METRIQUE_HA_1", (Object)pa);
                }
            }
            BigDecimal pVenteTTC = pVenteHT.multiply(new BigDecimal("1.2"));
            sqlRowValues.put("PV_TTC", (Object)pVenteTTC.setScale(2, RoundingMode.HALF_UP));
            sqlRowValues.put("ID_TAXE", (Object)TaxeCache.getCache().getIdFromTaux(Float.valueOf(20.0f)));
            if (!sqlRowValues.hasID() || sqlRowValues.isForeignEmpty("ID_ARTICLE")) continue;
            List<String> tarifs = Arrays.asList("PRIX_METRIQUE_VT_1", "PA_HT", "PRIX_METRIQUE_HA_1", "PV_TTC", "PV_HT");
            SQLRowValues rowValsArticle = sqlRowValues.getForeign("ID_ARTICLE").createEmptyUpdateRow();
            for (String string : tarifs) {
                rowValsArticle.put(string, sqlRowValues.getObject(string));
            }
            sqlRowValues.put("ID_ARTICLE", (Object)rowValsArticle);
        }
    }

    private void resolve(Object[] objs, SQLTable table, Map<Object, Integer> map) throws SQLException {
        SQLRowValues vals = new SQLRowValues(table);
        vals.put("NOM", null);
        vals.put("CODE", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        List existingRows = fetcher.fetch();
        int i = 0;
        while (i < objs.length) {
            Object o = objs[i];
            String name = o == null ? "Inconnu" : o.toString();
            boolean found = false;
            for (SQLRowValues sqlRowValues : existingRows) {
                String code = sqlRowValues.getString("CODE");
                String nom = sqlRowValues.getString("NOM");
                if (!name.equalsIgnoreCase(code) && !name.equalsIgnoreCase(nom)) continue;
                map.put(o, sqlRowValues.getID());
                found = true;
                break;
            }
            if (!found) {
                SQLRowValues fRowValues = new SQLRowValues(table);
                fRowValues.put("CODE", (Object)name);
                fRowValues.put("NOM", (Object)name);
                SQLRow r = fRowValues.insert();
                map.put(o, r.getID());
            }
            ++i;
        }
    }

    public static void doImport(boolean updateOnly, DataImporter importer) {
        RowValuesNavigatorPanel p = new RowValuesNavigatorPanel();
        int nbValues = 0;
        if (!updateOnly) {
            List valuesToInsert = importer.getValuesToInsert();
            nbValues += valuesToInsert.size();
            p.setRowValuesToInsert(valuesToInsert);
        }
        List valuesToUpdate = importer.getValuesToUpdate();
        p.setRowValuesToUpdate(valuesToUpdate);
        if ((nbValues += valuesToUpdate.size()) >= 0) {
            JFrame f = new JFrame("Import");
            f.setContentPane((Container)p);
            f.pack();
            f.setVisible(true);
            f.setDefaultCloseOperation(2);
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Pas de donn\u00e9es \u00e0 importer");
        }
    }

    public static enum Remise {
        R1("R1", new BigDecimal(10)),
        R2("R2", new BigDecimal(15)),
        R3("R3", new BigDecimal(20)),
        R4("R4", new BigDecimal(30)),
        R5("R5", new BigDecimal(40)),
        R6("R6", new BigDecimal(40)),
        R7("R7", new BigDecimal(40)),
        R8("R8", new BigDecimal(45)),
        X1("X1", new BigDecimal(10)),
        X2("X2", new BigDecimal(15)),
        X3("X3", new BigDecimal(20)),
        X4("X4", new BigDecimal(25)),
        X5("X5", new BigDecimal(30)),
        X6("X6", new BigDecimal(35)),
        X7("X7", new BigDecimal(40)),
        X8("X8", new BigDecimal(45)),
        X9("X9", new BigDecimal(50)),
        C1("C1", new BigDecimal(10)),
        C3("C3", new BigDecimal(20)),
        C4("C4", new BigDecimal(30)),
        C5("C5", new BigDecimal(40)),
        C6("C6", new BigDecimal(40)),
        C7("C7", new BigDecimal(40)),
        C8("C8", new BigDecimal(45)),
        R00("00", new BigDecimal(0)),
        R0X("0X", new BigDecimal(100)),
        RXX("XX", new BigDecimal(100)),
        AC("AC", new BigDecimal(0)),
        OU("OU", new BigDecimal(0)),
        RA("RA", new BigDecimal(10)),
        AR("AR", new BigDecimal(28)),
        AN("AN", new BigDecimal(40)),
        AL("AL", new BigDecimal(75));

        private String code;
        private BigDecimal remise;

        private Remise(String code, BigDecimal remise) {
            this.code = code;
            this.remise = remise;
        }

        public String getCode() {
            return this.code;
        }

        public BigDecimal getRemise() {
            return this.remise;
        }
    }
}

