/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.importer.product.suzuki;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.modules.importer.product.suzuki.ProductImporter;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public final class Module
extends AbstractModule {
    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected void setupMenu(MenuContext menuContext) {
        super.setupMenu(menuContext);
        menuContext.addMenuItem((Action)new AbstractAction("Import Suzuki"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = (Frame)SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)((Component)e.getSource()));
                FileDialog fd = new FileDialog(frame, "Import suzuki", 0);
                fd.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".txt");
                    }
                });
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    File f = new File(fd.getDirectory(), fd.getFile());
                    ProductImporter impoter = new ProductImporter();
                    try {
                        impoter.importArticlesFrom(f, false);
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((String)"Erreur lors de l'importation", (Throwable)e1);
                    }
                }
            }
        }, "menu.file");
    }

    protected void start() {
    }

    protected void stop() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("org.openconcerto.quickLogin", "true");
        File propsFile = new File("module.properties");
        RuntimeModuleFactory factory = new RuntimeModuleFactory(propsFile);
        File distDir = new File("../OpenConcerto/Modules");
        FileUtils.mkdir_p((File)distDir);
        new ModulePackager(propsFile, new File("bin/")).writeToDir(distDir);
        ModuleManager.getInstance().addFactoryAndStart((ModuleFactory)factory, false);
        Gestion.main((String[])args);
    }
}

