/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.importer.product.suzuki;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.Constraint;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.importer.ValueConverter;
import org.openconcerto.modules.importer.product.suzuki.ImporterManager;
import org.openconcerto.modules.importer.product.suzuki.ImporterMapping;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ImporterEditorPanel
extends JPanel {
    private DataImporter importer;
    private File fileToImport;
    private Map<Integer, SQLField> fieldMapping = new HashMap<Integer, SQLField>();
    private SQLTable table;

    public ImporterEditorPanel(File importerConfigurationFile, File fileToImport) throws Exception {
        this.loadFrom(new FileInputStream(importerConfigurationFile));
        this.fileToImport = fileToImport;
        this.initUI();
    }

    public ImporterEditorPanel(SQLTable table, File fileToImport) throws Exception {
        this.importer = new DataImporter(table);
        this.fileToImport = fileToImport;
        this.initUI();
    }

    private void initUI() throws IOException {
        ArrayTableModel m = this.importer.createModelFrom(this.fileToImport);
        int columnCount = m.getColumnCount();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        int i = 0;
        while (i < columnCount) {
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Colonne " + (i + 1)), c);
            ++c.gridx;
            JComboBox<ImporterMapping> box = new JComboBox<ImporterMapping>(this.getMappingType());
            SQLField sqlField = this.fieldMapping.get(i);
            this.add(box, c);
            if (sqlField != null) {
                box.setSelectedItem(ImporterMapping.FIELD);
                ++c.gridx;
                final JComboBox<Object> boxFields = new JComboBox<Object>(this.table.getFields().toArray());
                boxFields.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        String strValue = Configuration.getInstance().getTranslator().getLabelFor((SQLField)value);
                        if (strValue == null || strValue.isEmpty()) {
                            strValue = ((SQLField)value).getName();
                        }
                        return super.getListCellRendererComponent((JList<?>)list, strValue, index, isSelected, cellHasFocus);
                    }
                });
                boxFields.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boxFields.setToolTipText(e.getItem().toString());
                    }
                });
                boxFields.setSelectedItem(sqlField);
                this.add(boxFields, c);
            }
            ++c.gridy;
            ++i;
        }
    }

    private ImporterMapping[] getMappingType() {
        return new ImporterMapping[]{ImporterMapping.DO_NOTHING, ImporterMapping.FIELD};
    }

    private void loadFrom(InputStream inputStream) throws Exception {
        String field;
        SAXBuilder sxb = new SAXBuilder();
        Document document = sxb.build(inputStream);
        Element rootElement = document.getRootElement();
        Element importerElement = rootElement.getChild("importer");
        String tableName = importerElement.getAttributeValue("table");
        boolean skipFirstLine = Boolean.parseBoolean(importerElement.getAttributeValue("skipFirst", "true"));
        this.table = Configuration.getInstance().getRoot().findTable(tableName);
        this.importer = new DataImporter(this.table);
        this.importer.setSkipFirstLine(skipFirstLine);
        List maps = importerElement.getChildren("map");
        for (Element mapElement : maps) {
            int column = Integer.parseInt(mapElement.getAttributeValue("column"));
            field = mapElement.getAttributeValue("field");
            String converterId = mapElement.getAttributeValue("converter");
            ValueConverter converter = ImporterManager.getInstance().getValueConverter(converterId);
            SQLField field2 = this.table.getField(field);
            this.fieldMapping.put(column, field2);
            if (converter != null) {
                this.importer.map(column, field2);
                continue;
            }
            this.importer.map(column, field2, converter);
        }
        List mapsUnicity = importerElement.getChildren("unicity");
        for (Element mapElement : mapsUnicity) {
            field = mapElement.getAttributeValue("field");
            this.importer.addUniqueField(this.table.getField(field));
        }
        List mapsContraint = importerElement.getChildren("contraint");
        for (Element mapElement : mapsContraint) {
            int column = Integer.parseInt(mapElement.getAttributeValue("column"));
            String type = mapElement.getAttributeValue("type");
            Constraint constraint = ImporterManager.getInstance().getConstraint(type);
            this.importer.addContraint(column, constraint);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("ilm.sql.structure.useXML", "true");
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        conf.setupLogging("Logs");
        Configuration.setInstance((Configuration)conf);
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        comptaPropsConfiguration.setUpSocieteDataBaseConnexion(67);
        UserManager.getInstance().setCurrentUser(2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    ImporterEditorPanel p = new ImporterEditorPanel(new File("test.xml"), new File("c:\\customers-en-export.ods"));
                    JFrame f = new JFrame();
                    f.setContentPane(p);
                    f.pack();
                    f.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

