/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.agency;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.AlterTableRestricted;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.modules.agency.AgencyAnalytiqueProvider;
import org.openconcerto.modules.agency.element.PoleProduitSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.utils.CollectionUtils;

public final class Module
extends AbstractModule {
    private final List<String> tableModify = Arrays.asList("SAISIE_VENTE_FACTURE", "COMMANDE_CLIENT", "DEVIS", "BON_DE_LIVRAISON", "AVOIR_CLIENT", "AVOIR_FOURNISSEUR", "BON_RECEPTION", "SAISIE_ACHAT", "COMMANDE");

    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) {
        super.install(ctxt);
        if (ctxt.getLastInstalledVersion() == null && ctxt.getRoot().getTable("POLE_PRODUIT") == null) {
            SQLCreateTable createTable = ctxt.getCreateTable("POLE_PRODUIT");
            createTable.addVarCharColumn("CODE", 128);
            createTable.addVarCharColumn("NOM", 256);
            createTable.addVarCharColumn("NOM_DIRECTEUR", 256);
            createTable.addVarCharColumn("NOM_SECRETAIRE", 256);
            createTable.addVarCharColumn("TEL", 256);
            createTable.addVarCharColumn("FAX", 256);
            createTable.addVarCharColumn("MAIL", 256);
            createTable.addVarCharColumn("RAISON_SOCIALE", 256);
            createTable.addVarCharColumn("INFOS", 2048);
            createTable.addForeignColumn("ID_ADRESSE", ctxt.getRoot().getTable("ADRESSE"));
            createTable.addForeignColumn("ID_POSTE_ANALYTIQUE", ctxt.getRoot().getTable("POSTE_ANALYTIQUE"));
            createTable.addColumn("FACTURE_ADRESSE", "boolean DEFAULT false");
            for (String tableName : this.tableModify) {
                AlterTableRestricted alterFact = ctxt.getAlterTable(tableName);
                alterFact.addForeignColumn("ID_POLE_PRODUIT", (SQLCreateTableBase)createTable);
            }
        }
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
        ComptaPropsConfiguration.getInstanceCompta().getFieldMapper().addMapperStreamFromClass(Module.class);
        dir.addSQLElement(PoleProduitSQLElement.class);
        Configuration.getInstance().getShowAs().show("POLE_PRODUIT", Arrays.asList("CODE", "NOM"));
        for (String table : this.tableModify) {
            final SQLElement element = dir.getElement(table);
            element.addListColumn((SQLTableModelColumn)new BaseSQLTableModelColumn(((PoleProduitSQLElement)dir.getElement(PoleProduitSQLElement.class)).getPluralName(), String.class){

                protected Object show_(SQLRowAccessor r) {
                    if (r.isForeignEmpty("ID_POLE_PRODUIT")) {
                        return "";
                    }
                    return r.getForeign("ID_POLE_PRODUIT").getString("NOM");
                }

                public Set<FieldPath> getPaths() {
                    Path p = new Path(element.getTable());
                    p = (Path)p.add(element.getTable().getField("ID_POLE_PRODUIT"));
                    return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "NOM")});
                }
            });
        }
    }

    protected void setupComponents(ComponentsContext ctxt) {
        for (String table : this.tableModify) {
            if (table.equalsIgnoreCase("SAISIE_VENTE_FACTURE")) continue;
            ctxt.putAdditionalField(table, "ID_POLE_PRODUIT");
        }
        Group group = (Group)GlobalMapper.getInstance().getGroup("sales.invoice.partial").getChildFromID("sales.invoice.partial.identifier");
        group.add(new Item("sales.agency"));
        Group group2 = (Group)GlobalMapper.getInstance().getGroup("sales.invoice.partial.balance").getChildFromID("sales.invoice.partial.balance.identifier");
        group2.add(new Item("sales.agency"));
    }

    protected void setupMenu(final MenuContext ctxt) {
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Liste des agences"){

            public JFrame createFrame() {
                IListFrame frame = new IListFrame((IListPanel)new ListeAddPanel(ctxt.getElement("POLE_PRODUIT")));
                return frame;
            }
        }, "menu.organization");
    }

    protected void start() {
        AgencyAnalytiqueProvider.register();
    }

    protected void stop() {
    }
}

