/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.agency;

import java.sql.SQLException;
import org.openconcerto.erp.generationEcritures.provider.AnalytiqueProvider;
import org.openconcerto.erp.generationEcritures.provider.AnalytiqueProviderManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class AgencyAnalytiqueProvider
implements AnalytiqueProvider {
    public static final String ID = "AGENCY";

    public void addAssociation(SQLRow rowEcr, SQLRow rowSource) {
        SQLRow rowPole;
        if (!rowSource.isForeignEmpty("ID_POLE_PRODUIT") && !(rowPole = rowSource.getForeign("ID_POLE_PRODUIT")).isForeignEmpty("ID_POSTE_ANALYTIQUE")) {
            SQLRow rowPoste = rowPole.getForeign("ID_POSTE_ANALYTIQUE");
            SQLTable tableAssoc = rowSource.getTable().getTable("ASSOCIATION_ANALYTIQUE");
            SQLRowValues rowVals = new SQLRowValues(tableAssoc);
            rowVals.put("ID_POSTE_ANALYTIQUE", rowPoste.getID());
            rowVals.put("POURCENT", (Object)100.0);
            rowVals.put("ID_ECRITURE", rowEcr.getID());
            rowVals.put("MONTANT", (Object)(rowEcr.getLong("DEBIT") - rowEcr.getLong("CREDIT")));
            rowVals.put("GESTION_AUTO", (Object)Boolean.TRUE);
            try {
                rowVals.commit();
            }
            catch (SQLException e) {
                ExceptionHandler.handle((String)"Erreur survenue lors de l'association analytique avec l'agence", (Throwable)e);
            }
        }
    }

    public static final void register() {
        AnalytiqueProviderManager.put((String)ID, (AnalytiqueProvider)new AgencyAnalytiqueProvider());
    }
}

