/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.subscription.panel;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.reports.history.ui.ListeHistoriquePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.state.WindowStateManager;

public class HistoriqueAbonnement {
    private PanelFrame panelFrame;
    private ListeHistoriquePanel listPanel;

    public ListeHistoriquePanel getHistoriquePanel() {
        return this.listPanel;
    }

    public HistoriqueAbonnement() {
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        SQLBase b = comptaPropsConfiguration.getSQLBaseSociete();
        LinkedHashMap<String, List<String>> mapList = new LinkedHashMap<String, List<String>>();
        mapList.put("Devis", Arrays.asList("DEVIS"));
        mapList.put("Bons de commande", Arrays.asList("COMMANDE_CLIENT"));
        mapList.put("Factures", Arrays.asList("SAISIE_VENTE_FACTURE"));
        ComboSQLRequest request = new ComboSQLRequest(b.getTable("ABONNEMENT"), Arrays.asList("NUMERO", "ID_CLIENT"));
        request.setFieldSeparator(" ");
        this.listPanel = new ListeHistoriquePanel("Abonnements", request, mapList, null, null, null, true, null);
        this.panelFrame = new PanelFrame((Container)this.listPanel, "Historique abonnements");
        this.panelFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HistoriqueAbonnement.this.listPanel.removeAllTableListener();
            }
        });
        this.panelFrame.setDefaultCloseOperation(2);
    }

    public PanelFrame getFrame() {
        this.panelFrame.setIconImages(Gestion.getFrameIcon());
        WindowStateManager stateManager = new WindowStateManager((Window)this.panelFrame, new File(Configuration.getInstance().getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + "HistoAbonnements.xml"), true);
        this.panelFrame.setDefaultCloseOperation(2);
        this.panelFrame.pack();
        this.panelFrame.setLocationRelativeTo(null);
        stateManager.loadState();
        return this.panelFrame;
    }
}

