/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.subscription.panel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.panel.ListeFastPrintFrame;
import org.openconcerto.modules.subscription.SubscriptionChecker;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.SwingWorker2;

public class AboPanel
extends JPanel {
    protected final RowAction.PredicateRowAction actionCheck;
    protected final RowAction.PredicateRowAction actionValid;
    protected final RowAction.PredicateRowAction actionGetAbo;

    public AboPanel(final SQLElement elt, final SQLElement itemsElement, final String type) {
        super(new GridBagLayout());
        this.actionCheck = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Configuration.getInstance().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AboPanel.this.parseAbonnement(elt, itemsElement, type);
                        }
                        catch (Exception exn) {
                            ExceptionHandler.handle((String)"Une erreur est survenue pendant la v\u00e9rification des abonnements", (Throwable)exn);
                        }
                    }
                });
            }
        }, true, false, "subscription.check");
        this.actionCheck.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate((int)0, (int)Integer.MAX_VALUE));
        this.actionValid = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                List list = IListe.get((EventObject)arg0).getSelectedRows();
                for (SQLRowAccessor sqlRowAccessor : list) {
                    AboPanel.this.validItem(sqlRowAccessor);
                }
                ListeFastPrintFrame frame = new ListeFastPrintFrame(list, DevisXmlSheet.class);
                frame.setVisible(true);
            }
        }, true, "subscription.validate");
        this.actionValid.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.actionGetAbo = new RowAction.PredicateRowAction((Action)new AbstractAction(){
            EditFrame frame;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get((EventObject)arg0).getSelectedRow();
                if (this.frame == null) {
                    this.frame = new EditFrame(Configuration.getInstance().getDirectory().getElement("ABONNEMENT"), EditPanel.EditMode.MODIFICATION);
                }
                this.frame.selectionId(row.getInt("ID_ABONNEMENT"));
                this.frame.setVisible(true);
            }
        }, false, "subscription.modify");
        this.actionGetAbo.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.createUI(elt, itemsElement, type);
    }

    protected List<RowAction> getAdditionnalRowActions() {
        return Collections.emptyList();
    }

    private void createUI(final SQLElement elt, SQLElement itemsElement, String type) {
        SwingWorker2<SQLTableModelSourceOnline, Object> worker = new SwingWorker2<SQLTableModelSourceOnline, Object>(){

            protected SQLTableModelSourceOnline doInBackground() throws Exception {
                SQLTableModelSourceOnline tableCmd = elt.getTableSource(true);
                Where wD = new Where((FieldRef)elt.getTable().getField("CREATION_AUTO_VALIDER"), "=", (Object)Boolean.FALSE);
                wD = wD.and(new Where((FieldRef)elt.getTable().getField("ID_ABONNEMENT"), "IS NOT", null));
                tableCmd.getReq().setWhere(wD);
                return tableCmd;
            }

            protected void done() {
                try {
                    IListe listCmd = new IListe((SQLTableModelSource)this.get());
                    listCmd.addIListeAction((IListeAction)AboPanel.this.actionValid);
                    listCmd.addIListeAction((IListeAction)AboPanel.this.actionGetAbo);
                    listCmd.addIListeAction((IListeAction)AboPanel.this.actionCheck);
                    listCmd.addIListeActions(AboPanel.this.getAdditionnalRowActions());
                    ListeAddPanel listeCmd = new ListeAddPanel(elt, listCmd, "non valid\u00e9s");
                    DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                    c.gridy = -1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.fill = 1;
                    AboPanel.this.add((Component)listeCmd, c);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((String)"Unable to create subscription list", (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    protected void validItem(SQLRowAccessor sqlRowAccessor) {
        SQLRowValues rowVals = sqlRowAccessor.asRowValues();
        rowVals.put("CREATION_AUTO_VALIDER", (Object)Boolean.TRUE);
        try {
            rowVals.update();
        }
        catch (SQLException exn) {
            exn.printStackTrace();
        }
    }

    private void copyItems(SQLRow row, SQLTable itemsTable, SQLRowValues rowValsDest) {
        List myListItem = row.getReferentRows(itemsTable);
        for (SQLRow rowElt : myListItem) {
            SQLRowValues rowValsItem = rowElt.createUpdateRow();
            rowValsItem.clearPrimaryKeys();
            rowValsItem.put("ID_" + row.getTable().getName(), (Object)rowValsDest);
        }
    }

    protected void injectRow(SQLRow row, SQLRowValues rowVals, Date dateNew, SQLRow rowAbonnement) {
        rowVals.put("ID_CLIENT", row.getObject("ID_CLIENT"));
        rowVals.put("ID_COMMERCIAL", row.getObject("ID_COMMERCIAL"));
        rowVals.put("DATE", (Object)dateNew);
        rowVals.put("T_HT", row.getObject("T_HT"));
        rowVals.put("T_TVA", row.getObject("T_TVA"));
        rowVals.put("T_SERVICE", row.getObject("T_SERVICE"));
        rowVals.put("T_TTC", row.getObject("T_TTC"));
        rowVals.put("INFOS", row.getObject("INFOS"));
        rowVals.put("T_POIDS", row.getObject("T_POIDS"));
        rowVals.put("ID_TARIF", row.getObject("ID_TARIF"));
        rowVals.put("ID_MODELE", row.getObject("ID_MODELE"));
        rowVals.put("ID_ABONNEMENT", rowAbonnement.getID());
        rowVals.put("CREATION_AUTO_VALIDER", (Object)Boolean.FALSE);
        if (row.getTable().contains("SOURCE")) {
            rowVals.put("SOURCE", row.getObject("SOURCE"));
            rowVals.put("IDSOURCE", row.getObject("IDSOURCE"));
        }
        if (row.getTable().contains("ID_AFFAIRE")) {
            rowVals.put("ID_AFFAIRE", row.getObject("ID_AFFAIRE"));
        }
    }

    public void parseAbonnement(SQLElement elt, SQLElement itemsElement, String type) {
        SubscriptionChecker checker = new SubscriptionChecker(elt.getTable());
        Map<SQLRow, Calendar> listLastCreateElt = checker.check();
        for (SQLRow rowAbonnement : listLastCreateElt.keySet()) {
            SQLRow rowsCmd = rowAbonnement.getForeignRow("ID_" + elt.getTable().getName());
            Calendar date = listLastCreateElt.get(rowAbonnement);
            if (date == null) {
                date = rowsCmd.getDate("DATE");
                date.add(2, rowAbonnement.getInt("NB_MOIS_" + type));
            }
            if (date.compareTo(rowAbonnement.getDate("DATE_FIN_" + type)) > 0) continue;
            SQLRowValues rowVals = new SQLRowValues(elt.getTable());
            this.injectRow(rowsCmd, rowVals, date.getTime(), rowAbonnement);
            this.copyItems(rowsCmd, itemsElement.getTable(), rowVals);
            try {
                rowVals.commit();
            }
            catch (SQLException exn) {
                ExceptionHandler.handle((String)("Erreur lors de la cr\u00e9ation  " + elt.getSingularName() + " d'abonnement."), (Throwable)exn);
            }
        }
    }
}

