/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.subscription;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class SubscriptionChecker {
    private final String type;
    private final SQLTable table;

    public SubscriptionChecker(SQLTable table) {
        this.table = table;
        this.type = this.table.getName().equalsIgnoreCase("SAISIE_VENTE_FACTURE") ? "FACTURE" : (this.table.getName().equalsIgnoreCase("DEVIS") ? "DEVIS" : "COMMANDE");
    }

    public Map<SQLRow, Calendar> check() {
        SQLRowValues vals = new SQLRowValues(this.table);
        vals.put(this.table.getKey().getName(), null);
        vals.put("NUMERO", null);
        vals.put("DATE", null);
        vals.put("ID_ABONNEMENT", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect sel) {
                TableRef tableFAlias = sel.getAlias(SubscriptionChecker.this.table);
                SQLSelectJoin join = sel.addJoin("RIGHT", SubscriptionChecker.this.table, "f2", new Where(tableFAlias.getField("ARCHIVE"), "=", 0));
                Where w = new Where(join.getJoinedTable().getField("DATE"), "<=", tableFAlias.getField("DATE"));
                w = w.and(new Where(join.getJoinedTable().getField("ID_ABONNEMENT"), "=", tableFAlias.getField("ID_ABONNEMENT")));
                join.setWhere(w);
                sel.setWhere(new Where(tableFAlias.getField("ID_ABONNEMENT"), "IS NOT", null));
                System.err.println(sel.asString());
                return sel;
            }
        });
        List list = fetcher.fetch();
        HashMap<Integer, SQLRowValues> map = new HashMap<Integer, SQLRowValues>();
        for (SQLRowValues sqlRow : list) {
            map.put(sqlRow.getInt("ID_ABONNEMENT"), sqlRow);
        }
        SQLSelect selAb = new SQLSelect(this.table.getDBSystemRoot(), true);
        SQLTable tableAb = Configuration.getInstance().getRoot().findTable("ABONNEMENT");
        selAb.addSelectStar((TableRef)tableAb);
        List rows = SQLRowListRSH.execute((SQLSelect)selAb);
        HashMap<SQLRow, Calendar> aboFactureRenouvel = new HashMap<SQLRow, Calendar>();
        Date toDay = new Date();
        for (SQLRow sqlRow : rows) {
            if (!sqlRow.getBoolean("CREATE_" + this.type).booleanValue()) continue;
            int nbMois = sqlRow.getInt("NB_MOIS_" + this.type);
            Calendar calStartFact = sqlRow.getDate("DATE_DEBUT_" + this.type);
            SQLRowValues rowFact = (SQLRowValues)map.get(sqlRow.getID());
            if (rowFact != null) {
                if (rowFact.getObject("CREATION_AUTO_VALIDER") == null || !rowFact.getBoolean("CREATION_AUTO_VALIDER").booleanValue()) continue;
                calStartFact = rowFact.getDate("DATE");
            }
            calStartFact.add(2, nbMois);
            if (!toDay.after(calStartFact.getTime())) continue;
            aboFactureRenouvel.put(sqlRow, calStartFact);
        }
        return aboFactureRenouvel;
    }
}

