/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.subscription;

import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.AlterTableRestricted;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.modules.subscription.SourceCellValueProvider;
import org.openconcerto.modules.subscription.element.SubscriptionSQLElement;
import org.openconcerto.modules.subscription.panel.BonCommandeAboPanel;
import org.openconcerto.modules.subscription.panel.DevisAboPanel;
import org.openconcerto.modules.subscription.panel.FacturesAboPanel;
import org.openconcerto.modules.subscription.panel.HistoriqueAbonnement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.utils.i18n.TranslationManager;

public final class Module
extends AbstractModule {
    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) {
        super.install(ctxt);
        if (ctxt.getLastInstalledVersion() == null && ctxt.getRoot().getTable("ABONNEMENT") == null) {
            SQLCreateTable createTable = ctxt.getCreateTable("ABONNEMENT");
            createTable.addVarCharColumn("NUMERO", 256);
            createTable.addVarCharColumn("DESCRIPTION", 1024);
            createTable.addVarCharColumn("NOM", 256);
            createTable.addVarCharColumn("INTITULE_FACTURE", 1024);
            createTable.addVarCharColumn("INFOS", 2048);
            createTable.addColumn("DATE", "date");
            createTable.addForeignColumn("ID_CLIENT", ctxt.getRoot().getTable("CLIENT"));
            createTable.addForeignColumn("ID_SAISIE_VENTE_FACTURE", ctxt.getRoot().getTable("SAISIE_VENTE_FACTURE"));
            createTable.addForeignColumn("ID_DEVIS", ctxt.getRoot().getTable("DEVIS"));
            createTable.addColumn("DATE_DEBUT_FACTURE", "date");
            createTable.addColumn("DATE_FIN_FACTURE", "date");
            createTable.addColumn("DATE_DEBUT_DEVIS", "date");
            createTable.addColumn("DATE_FIN_DEVIS", "date");
            createTable.addColumn("NB_MOIS_DEVIS", "int DEFAULT 3");
            createTable.addColumn("NB_MOIS_FACTURE", "int DEFAULT 3");
            createTable.addColumn("CREATE_FACTURE", "boolean DEFAULT false");
            createTable.addColumn("CREATE_DEVIS", "boolean DEFAULT false");
            createTable.addForeignColumn("ID_COMMANDE_CLIENT", ctxt.getRoot().getTable("COMMANDE_CLIENT"));
            createTable.addColumn("DATE_DEBUT_COMMANDE", "date");
            createTable.addColumn("DATE_FIN_COMMANDE", "date");
            createTable.addColumn("NB_MOIS_COMMANDE", "int DEFAULT 3");
            createTable.addColumn("CREATE_COMMANDE", "boolean DEFAULT false");
            AlterTableRestricted alterNumero = ctxt.getAlterTable("NUMEROTATION_AUTO");
            alterNumero.addVarCharColumn("ABONNEMENT_FORMAT", 128);
            alterNumero.addIntegerColumn("ABONNEMENT_START", 1);
            AlterTableRestricted alterFact = ctxt.getAlterTable("SAISIE_VENTE_FACTURE");
            alterFact.addForeignColumn("ID_ABONNEMENT", (SQLCreateTableBase)createTable);
            alterFact.addColumn("CREATION_AUTO_VALIDER", "boolean DEFAULT false");
            AlterTableRestricted alterDevis = ctxt.getAlterTable("COMMANDE_CLIENT");
            alterDevis.addForeignColumn("ID_ABONNEMENT", (SQLCreateTableBase)createTable);
            alterDevis.addColumn("CREATION_AUTO_VALIDER", "boolean DEFAULT false");
            AlterTableRestricted alterCmd = ctxt.getAlterTable("DEVIS");
            alterCmd.addForeignColumn("ID_ABONNEMENT", (SQLCreateTableBase)createTable);
            alterCmd.addColumn("CREATION_AUTO_VALIDER", "boolean DEFAULT false");
        }
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
        TranslationManager.getInstance().addTranslationStreamFromClass(((Object)((Object)this)).getClass());
        dir.addSQLElement(SubscriptionSQLElement.class);
        NumerotationAutoSQLElement.addClass(SubscriptionSQLElement.class, (String)"ABONNEMENT");
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected void setupMenu(final MenuContext ctxt) {
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Liste des abonnements"){

            public JFrame createFrame() {
                IListFrame frame = new IListFrame((IListPanel)new ListeAddPanel(ctxt.getElement("ABONNEMENT")));
                return frame;
            }
        }, "menu.list");
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Saisie abonnements"){

            public JFrame createFrame() {
                return new EditFrame(ctxt.getElement("ABONNEMENT"));
            }
        }, "menu.create");
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Historique des abonnements"){

            public JFrame createFrame() {
                HistoriqueAbonnement histo = new HistoriqueAbonnement();
                return histo.getFrame();
            }
        }, "menu.list");
    }

    protected void start() {
        MainFrame.getInstance().getTabbedPane().addTab("Devis d'abonnements", (JComponent)new DevisAboPanel());
        MainFrame.getInstance().getTabbedPane().addTab("Bon de commande d'abonnements", (JComponent)new BonCommandeAboPanel());
        MainFrame.getInstance().getTabbedPane().addTab("Facture d'abonnements", (JComponent)new FacturesAboPanel());
        SourceCellValueProvider.register();
    }

    protected void stop() {
    }
}

